/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import com.or.ange.dot.Event;
import com.or.ange.dot.EventGetter;
import com.or.ange.dot.ReportRunnable;
import com.or.ange.dot.UsageStats;
import com.or.ange.dot.utils.LLog;
import com.or.ange.dot.utils.ThreadManager;
import java.util.HashSet;
import java.util.Set;

class Reporter {
    private static final String TAG = "DotReporter";
    private static final boolean DEBUG = false;
    private final ReportRunnable reportRunnable;
    private final BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                Reporter.this.tracker("connectivity state change");
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                Reporter.this.tracker("screen off");
            }
        }
    };
    private final Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){
        private final Set<Activity> activities = new HashSet<Activity>();

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            this.activities.add(activity);
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            this.activities.remove(activity);
            if (this.activities.isEmpty()) {
                Reporter.this.tracker("activities is empty.");
            }
        }
    };

    static Reporter getInstance() {
        return LazyHolder.HOLDER;
    }

    private Reporter() {
        this.reportRunnable = new ReportRunnable();
        this.registerReceiver();
        this.registerLifeCallbacks();
    }

    @SuppressLint(value={"NewApi"})
    private void registerLifeCallbacks() {
        Application application = (Application)UsageStats.getContext().getApplicationContext();
        application.registerActivityLifecycleCallbacks(this.lifecycleCallbacks);
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.intent.action.SCREEN_OFF");
        UsageStats.getContext().registerReceiver(this.receiver, filter);
    }

    public void reportEvent(Event event) {
        EventGetter.get().add(event);
        if (UsageStats.settings().getImmediate().contains(event.getEventId())) {
            this.tracker("event contain in immediate.");
        } else if (EventGetter.get().getEvents().size() >= UsageStats.settings().getMaxCaches() && !this.reportRunnable.isReporting()) {
            this.tracker("event size greater than max cache size.");
        }
    }

    private void tracker(String reason) {
        LLog.d(TAG, "reason:" + reason);
        if (this.isConnected(UsageStats.getContext())) {
            ThreadManager.getSingleExecutor().submit(this.reportRunnable);
        } else {
            LLog.w(TAG, "net work is disconnect.");
        }
    }

    private boolean isConnected(Context context) {
        NetworkInfo info = this.getActiveNetworkInfo(context);
        return info != null && info.isConnected();
    }

    @SuppressLint(value={"MissingPermission"})
    private NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (manager == null) {
            return null;
        }
        return manager.getActiveNetworkInfo();
    }

    private static class LazyHolder {
        static final Reporter HOLDER = new Reporter();

        private LazyHolder() {
        }
    }
}

