/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import com.or.ange.dot.Event;
import com.or.ange.dot.UsageStats;
import com.or.ange.dot.utils.LLog;
import com.or.ange.dot.utils.ThreadManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class EventGetter {
    private static final String TAG = "EventGetter";
    private static final boolean DEBUG = false;
    private final List<Event> events = new CopyOnWriteArrayList<Event>();
    private static final Object LOCK = new Object();
    private volatile boolean isLoaded = false;

    static EventGetter get() {
        return GetterHolder.HOLDER;
    }

    private EventGetter() {
        LLog.d(TAG, "create EventGetter");
        ThreadManager.getNormalExecutor().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    LLog.d(EventGetter.TAG, "EventGetter load start");
                    List temp = UsageStats.getEventLikeModel().findAll();
                    if (temp != null) {
                        LLog.d(EventGetter.TAG, "create submit size:" + temp.size());
                        if (temp.size() < 1000) {
                            EventGetter.this.events.addAll(temp);
                        } else {
                            LLog.w(EventGetter.TAG, "more event, drop table...");
                            UsageStats.getEventLikeModel().drop();
                        }
                    } else {
                        LLog.d(EventGetter.TAG, "create submit is empty.");
                    }
                    LLog.d(EventGetter.TAG, "EventGetter load end");
                }
                catch (Exception e) {
                    LLog.w(EventGetter.TAG, e.getMessage());
                }
                Object object = LOCK;
                synchronized (object) {
                    EventGetter.this.isLoaded = true;
                    LOCK.notifyAll();
                }
            }
        });
    }

    void add(final Event event) {
        this.waitForLoaded();
        if (!this.events.contains(event)) {
            ThreadManager.getNormalExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    UsageStats.getEventLikeModel().save((Object)event);
                }
            });
            this.events.add(event);
            int removeLength = this.events.size() - 1000;
            if (removeLength > 0) {
                ArrayList<Event> toBeRemove = new ArrayList<Event>();
                for (int i = 0; i < removeLength; ++i) {
                    toBeRemove.add(this.events.get(i));
                }
                for (int j = 0; j < toBeRemove.size(); ++j) {
                    this.events.remove(toBeRemove.get(j));
                }
            }
        }
    }

    void trackSuccess(final Event event) {
        this.waitForLoaded();
        if (this.events.contains(event)) {
            ThreadManager.getNormalExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    UsageStats.getEventLikeModel().delete("eventId=? AND ts=?", new String[]{event.getEventId(), String.valueOf(event.getTimestamp())});
                }
            });
            this.events.remove(event);
        } else {
            LLog.w(TAG, "track success not contain event:" + event);
        }
    }

    List<Event> getEvents() {
        this.waitForLoaded();
        return this.events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLoaded() {
        if (this.isLoaded) {
            return;
        }
        LLog.d(TAG, "waitForLoaded isLoaded =" + this.isLoaded);
        Object object = LOCK;
        synchronized (object) {
            while (!this.isLoaded) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static interface GetterHolder {
        public static final EventGetter HOLDER = new EventGetter();
    }
}

