package com.zl.sdk.util.log;

import android.text.TextUtils;
import android.util.Log;

public class LogToLogcat extends AbsLog {

    @Override
    public void w(String tag, String msg) {
        if (null == msg) {
            msg = "";
        }
        Log.w(GLOBAL_TAG + "." + tag, "" + msg);

    }

    @Override
    public void i(String tag, String msg) {
        if (null == msg) {
            msg = "";
        }
        Log.i(GLOBAL_TAG + "." + tag, "" + msg);
    }

    @Override
    public void v(String tag, String msg) {
        if (null == msg) {
            msg = "";
        }
        Log.v(GLOBAL_TAG + "." + tag, "" + msg);
    }

    @Override
    public void d(String tag, String msg) {
        if (null == msg) {
            msg = "";
        }
        Log.d(GLOBAL_TAG + "." + tag, "" + msg);
    }

    @Override
    public void e(String tag, String msg) {
        if (null == msg) {
            msg = "";
        }
        Log.e(GLOBAL_TAG + "." + tag, "" + msg);
    }

    @Override
    public void e(String tag, String msg, Throwable e) {
        if (null == msg) {
            msg = "";
        }
        Log.e(GLOBAL_TAG + "." + tag, "" + msg, e);
    }

    @Override
    public void e(String tag, Throwable e) {
        Log.e(GLOBAL_TAG + "." + tag, "", e);
    }

    @Override
    public void dForce(String msg) {
        msg = null2Length0(msg);
        Log.d(GLOBAL_TAG, msg);
    }

    @Override
    public void dForce(String tag, String msg) {
        msg = null2Length0(msg);
        Log.d(GLOBAL_TAG + "." + tag, msg);
    }

    @Override
    public void wForce(String tag, String msg) {
        msg = null2Length0(msg);
        Log.w(GLOBAL_TAG + "." + tag, msg);
    }

    @Override
    public void wForce(String tag, Throwable e) {
        Log.w(GLOBAL_TAG + "." + tag, "", e);
    }

    @Override
    public void wForce(String tag, String msg, Throwable e) {
        Log.w(GLOBAL_TAG + "." + tag, msg, e);
    }

    @Override
    public void eForce(String tag, String msg, Throwable e) {
        msg = null2Length0(msg);
        Log.e(GLOBAL_TAG + "." + tag, msg, e);
    }

    @Override
    public void eForce(String tag, Throwable e) {
        eForce(tag, "", e);
    }

    @Override
    public void debugLog(Object debugLog) {
        dForce("debugLog", String.valueOf(debugLog));
    }

    private String null2Length0(String str) {
        if (TextUtils.isEmpty(str)) {
            return "";
        } else {
            return str;
        }
    }
}
