/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.or.ange.database.AbstractLikeModel;
import com.or.ange.database.ColumnModel;
import com.or.ange.database.LikePalException;
import com.or.ange.database.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class LikeModelSupport<T>
extends AbstractLikeModel<T> {
    LikeModelSupport(Class<T> clazz, String dbName, String table) {
        super(clazz, dbName, table);
    }

    @Override
    public long save(T obj) {
        return this.save(obj, 4);
    }

    @Override
    public long save(T obj, int conflictAlgorithm) {
        SQLiteDatabase db = Operator.getDatabase(this.getDbName());
        try {
            ContentValues values = this.getContentValues(obj);
            long l = db.insertWithOnConflict(this.getTable().getTableName(), null, values, conflictAlgorithm);
            return l;
        }
        catch (Exception e) {
            throw new LikePalException("save obj:" + obj, e);
        }
        finally {
            Operator.release(this.getDbName());
        }
    }

    @Override
    public void delete(T t) {
        try {
            StringBuilder where = new StringBuilder();
            ArrayList<String> args = new ArrayList<String>();
            Collection<ColumnModel> columnModels = this.getTable().getColumnModels();
            int columnCount = 0;
            for (ColumnModel columnModel : columnModels) {
                if (!columnModel.isPrimaryKey()) continue;
                if (columnCount > 0) {
                    where.append(" AND ");
                }
                where.append(columnModel.getName());
                where.append("=?");
                args.add(String.valueOf(columnModel.getField().get(t)));
                ++columnCount;
            }
            String[] values = new String[args.size()];
            args.toArray(values);
            this.delete(where.toString(), values);
        }
        catch (Exception e) {
            throw new LikePalException("delete exception", e);
        }
    }

    @Override
    public void delete(String whereClause, String[] whereArgs) {
        SQLiteDatabase db = Operator.getDatabase(this.getDbName());
        try {
            db.delete(this.getTable().getTableName(), whereClause, whereArgs);
        }
        catch (Exception e) {
            throw new LikePalException("delete exception", e);
        }
        finally {
            Operator.release(this.getDbName());
        }
    }

    @Override
    public int update(T obj) {
        try {
            StringBuilder where = new StringBuilder();
            ArrayList<String> args = new ArrayList<String>();
            Collection<ColumnModel> columnModels = this.getTable().getColumnModels();
            int columnCount = 0;
            for (ColumnModel columnModel : columnModels) {
                if (!columnModel.isPrimaryKey()) continue;
                if (columnCount > 0) {
                    where.append(" AND ");
                }
                where.append(columnModel.getName());
                where.append("=?");
                args.add(String.valueOf(columnModel.getField().get(obj)));
                ++columnCount;
            }
            String[] values = new String[args.size()];
            args.toArray(values);
            return this.update(obj, where.toString(), values, 5);
        }
        catch (Exception e) {
            throw new LikePalException("delete exception", e);
        }
    }

    @Override
    public int update(T obj, String whereClause, String[] whereArgs, int conflictAlgorithm) {
        SQLiteDatabase db = Operator.getDatabase(this.getDbName());
        try {
            ContentValues values = this.getContentValues(obj);
            int n = db.updateWithOnConflict(this.getTable().getTableName(), values, whereClause, whereArgs, conflictAlgorithm);
            return n;
        }
        catch (Exception e) {
            throw new LikePalException("update obj:" + obj, e);
        }
        finally {
            Operator.release(this.getDbName());
        }
    }

    @Override
    public T findFirst(String column) {
        List<T> objectList = this.find(null, null, null, null, column, "1");
        return objectList.isEmpty() ? null : (T)objectList.get(0);
    }

    @Override
    public T findLast(String column) {
        List<T> objectList = this.find(null, null, null, null, column + " desc", "1");
        return objectList.isEmpty() ? null : (T)objectList.get(0);
    }

    @Override
    public List<T> findAll() {
        return this.find(null, null, null, null, null, null);
    }

    @Override
    public List<T> find(String selection, String[] selectionArgs) {
        return this.find(selection, selectionArgs, null, null, null, null);
    }

    @Override
    public List<T> find(String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.find(null, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    @Override
    public List<T> find(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = Operator.getDatabase(this.getDbName());
            cursor = db.query(this.getTable().getTableName(), columns, selection, selectionArgs, groupBy, having, orderBy, limit);
            List list = this.getResult(columns, null, cursor);
            return list;
        }
        catch (Exception e) {
            throw new LikePalException("find error", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Operator.release(this.getDbName());
        }
    }

    @Override
    public void drop() {
        SQLiteDatabase db = Operator.getDatabase(this.getDbName());
        try {
            db.execSQL("DROP TABLE IF EXISTS " + this.getTable().getTableName());
            this.releaseTable();
        }
        catch (Exception e) {
            throw new LikePalException("drop table:" + this.getTable().getTableName() + " exception", e);
        }
        finally {
            Operator.release(this.getDbName());
        }
    }

    @Override
    public long count() {
        return this.count(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(String selection, String[] selectionArgs) {
        try {
            long l = DatabaseUtils.queryNumEntries((SQLiteDatabase)Operator.getDatabase(this.getDbName()), (String)this.getTable().getTableName(), (String)selection, (String[])selectionArgs);
            return l;
        }
        finally {
            Operator.release(this.getDbName());
        }
    }

    @Override
    public <V> V max(String columnName) {
        return this.max(columnName, null, null);
    }

    @Override
    public <V> V max(String columnName, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = Operator.getDatabase(this.getDbName());
            String s = !TextUtils.isEmpty((CharSequence)selection) ? " WHERE " + selection : "";
            cursor = db.rawQuery("SELECT MAX(" + columnName + ") AS MAX FROM " + this.getTable().getTableName() + s, selectionArgs);
            List objectList = this.getResult(new String[]{columnName}, new String[]{"MAX"}, cursor);
            Object object = objectList.isEmpty() ? null : objectList.get(0);
            ColumnModel model = this.getTable().getColumnModelByName(columnName);
            if (object != null) {
                Object object2 = model.getField().get(object);
                return (V)object2;
            }
        }
        catch (Exception e) {
            throw new LikePalException("find error", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Operator.release(this.getDbName());
        }
        return null;
    }

    @Override
    public <V> V min(String columnName) {
        return this.min(columnName, null, null);
    }

    @Override
    public <V> V min(String columnName, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = Operator.getDatabase(this.getDbName());
            String s = !TextUtils.isEmpty((CharSequence)selection) ? " WHERE " + selection : "";
            cursor = db.rawQuery("SELECT MIN(" + columnName + ") AS MIN FROM " + this.getTable().getTableName() + s, selectionArgs);
            List objectList = this.getResult(new String[]{columnName}, new String[]{"MIN"}, cursor);
            Object object = objectList.isEmpty() ? null : objectList.get(0);
            ColumnModel model = this.getTable().getColumnModelByName(columnName);
            if (object != null) {
                Object object2 = model.getField().get(object);
                return (V)object2;
            }
        }
        catch (Exception e) {
            throw new LikePalException("find error", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            Operator.release(this.getDbName());
        }
        return null;
    }

    @Override
    public void execSQL(String sql) throws SQLException {
        if (this.checkTable()) {
            Operator.getDatabase(this.getDbName()).execSQL(sql);
        }
    }

    @Override
    public void execSQL(String sql, Object[] bindArgs) throws SQLException {
        if (this.checkTable()) {
            Operator.getDatabase(this.getDbName()).execSQL(sql, bindArgs);
        }
    }

    @Override
    public void beginTransaction() {
        if (this.checkTable()) {
            Operator.getDatabase(this.getDbName()).beginTransaction();
        }
    }

    @Override
    public void setTransactionSuccessful() {
        if (this.checkTable()) {
            Operator.getDatabase(this.getDbName()).setTransactionSuccessful();
        }
    }

    @Override
    public void endTransaction() {
        if (this.checkTable()) {
            Operator.getDatabase(this.getDbName()).endTransaction();
        }
    }
}

