/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.util.Log;

@SuppressLint(value={"NewApi"})
public final class DeviceIDUtils {
    private static final String TAG = "DeviceIDUtils";

    DeviceIDUtils() {
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getImei(Context context) {
        boolean has = DeviceIDUtils.hasPermissions(context, "android.permission.READ_PHONE_STATE");
        if (!has) {
            return "";
        }
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            return telephonyManager.getDeviceId();
        }
        catch (Exception var3) {
            return "";
        }
    }

    static boolean hasPermissions(Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"hasPermissions: API version < M, returning true by default");
            return true;
        }
        String[] var2 = perms;
        int var3 = perms.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String perm = var2[var4];
            if (DeviceIDUtils.checkSelfPermission(context, perm) == 0) continue;
            return false;
        }
        return true;
    }

    private static int checkSelfPermission(Context context, String permission) {
        if (permission == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return context.checkPermission(permission, Process.myPid(), Process.myUid());
    }
}

