/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

@SuppressLint(value={"All"})
class Http {
    private static final String TAG = "Http";
    public static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int HTTP_TEMP_REDIRECT = 307;
    private static final int DEFAULT_TIMEOUT = 20000;
    private static final String KEY = "widfhbqwijdnqjodnqijdbkn";

    private Http() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postMethod(String url, String param) {
        StringBuffer rest = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        BufferedReader br = null;
        try {
            URL restUrl = new URL(url);
            conn = (HttpURLConnection)restUrl.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "keep-Alive");
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            conn.setDoOutput(true);
            conn.connect();
            out = conn.getOutputStream();
            out.write(param.getBytes());
            out.flush();
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
            String line = null;
            while (null != (line = br.readLine())) {
                rest.append(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return rest.toString();
    }

    public static HttpURLConnection head(String uri) throws IOException {
        return Http.head(uri, null);
    }

    public static HttpURLConnection head(String uri, Map<String, String> heads) throws IOException {
        URL url = new URL(uri);
        System.setProperty("http.keepAlive", "false");
        block5: while (true) {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            Http.setHttpsFactory(conn);
            conn.setConnectTimeout(20000);
            conn.setReadTimeout(20000);
            conn.setRequestMethod("HEAD");
            int responseCode = conn.getResponseCode();
            switch (responseCode) {
                case 200: 
                case 206: {
                    return conn;
                }
                case 416: {
                    throw new StopRequestException(416);
                }
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    String location = conn.getHeaderField("Location");
                    url = new URL(location);
                    continue block5;
                }
            }
            break;
        }
        return null;
    }

    private static void setHttpsFactory(HttpURLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            httpsConn.setHostnameVerifier(new SkipHostnameVerifier());
            try {
                httpsConn.setSSLSocketFactory(Http.createSslSocketFactory());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static HttpURLConnection post(String uri) throws IOException {
        return Http.post(uri, null);
    }

    public static HttpURLConnection post(String uri, Map<String, String> heads) throws IOException {
        return Http.post(uri, heads, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpURLConnection post(String uri, Map<String, String> heads, Map<String, String> params, String body) throws IOException {
        URL url = params != null && params.size() > 0 ? new URL(uri + "?" + Http.convertRequestParamsToString(params)) : new URL(uri);
        OutputStream outputStream = null;
        block22: while (true) {
            HttpURLConnection httpURLConnection;
            try {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setAllowUserInteraction(false);
                conn.setConnectTimeout(20000);
                conn.setReadTimeout(20000);
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/octet-stream");
                conn.setRequestProperty("e", "5");
                Http.setHttpsFactory(conn);
                if (!TextUtils.isEmpty((CharSequence)body)) {
                    byte[] encryptBody = Http.encrypt(Base64.encode((byte[])body.getBytes(StandardCharsets.UTF_8), (int)0));
                    outputStream = conn.getOutputStream();
                    outputStream.write(encryptBody);
                    outputStream.flush();
                }
                int responseCode = conn.getResponseCode();
                switch (responseCode) {
                    case 200: 
                    case 206: {
                        HttpURLConnection httpURLConnection2 = conn;
                        return httpURLConnection2;
                    }
                    case 416: {
                        throw new StopRequestException(416);
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String location = conn.getHeaderField("Location");
                        url = new URL(location);
                        continue block22;
                    }
                }
                httpURLConnection = null;
            }
            catch (Exception ex) {
                HttpURLConnection httpURLConnection3 = null;
                return httpURLConnection3;
            }
            finally {
                if (outputStream == null) continue;
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            return httpURLConnection;
            break;
        }
    }

    private static void addRequestHeaders(HttpURLConnection conn, Map<String, String> heads) {
        if (heads != null) {
            Set<Map.Entry<String, String>> headEntries = heads.entrySet();
            for (Map.Entry<String, String> entry : headEntries) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public static String convertRequestParamsToString(Map<String, String> params) throws IOException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (TextUtils.isEmpty((CharSequence)value)) continue;
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(key, "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(value, "UTF-8"));
        }
        return result.toString();
    }

    private static SSLSocketFactory createSslSocketFactory() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, new TrustManager[]{new SkipX509TrustManager()}, new SecureRandom());
        return context.getSocketFactory();
    }

    private static byte[] doEnc(byte[] bArr) throws UnsupportedEncodingException {
        byte[] bArr2 = new byte[bArr.length];
        byte[] keyBytes = KEY.getBytes("UTF-8");
        int size = keyBytes.length;
        for (int i = 0; i < bArr.length; ++i) {
            bArr2[i] = (byte)(bArr[i] ^ keyBytes[i % size]);
        }
        return bArr2;
    }

    public static byte[] encrypt(byte[] httpBody) {
        byte[] keyBytes = KEY.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[httpBody.length];
        for (int i = 0; i < httpBody.length; ++i) {
            data[i] = (byte)(httpBody[i] ^ keyBytes[i % keyBytes.length]);
        }
        return data;
    }

    public static String decrypt(byte[] httpBody) {
        byte[] kBytes = KEY.getBytes();
        byte[] bArr2 = new byte[httpBody.length];
        for (int i = 0; i < httpBody.length; ++i) {
            bArr2[i] = (byte)(httpBody[i] ^ kBytes[i % kBytes.length]);
        }
        return new String(bArr2);
    }

    public static class StopRequestException
    extends RuntimeException {
        private int code;

        public StopRequestException(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    private static class SkipHostnameVerifier
    implements HostnameVerifier {
        private SkipHostnameVerifier() {
        }

        @Override
        @SuppressLint(value={"BadHostnameVerifier"})
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    private static class SkipX509TrustManager
    implements X509TrustManager {
        private SkipX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        @SuppressLint(value={"TrustAllX509TrustManager"})
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

