package com.zl.sdk.event.statistics;

import android.content.Context;

import com.or.ange.dot.UsageStats;
import com.zl.sdk.OutHelp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class DotOperator extends AbsStatistics {

    public DotOperator(Context context) {
    }

    @Override
    public void onResume(Context context) {
    }

    @Override
    public void onPause(Context context) {
    }

    @Override
    public void onPageStart(Context context, String pageName) {
    }

    @Override
    public void onPageEnd(Context context, String pageName) {
    }

    @Override
    public void onEvent(Context context, String eventId) {
        try {
            Map<String, String> map = new HashMap<>();
            map.put("ver_name", OutHelp.get().getDexVersionName());
            map.put("ver_code", OutHelp.get().getDexVersionCode());
            UsageStats.onEvent(eventId, map);
        } catch (Exception e) {
        }
    }

    @Override
    public void onEvent(Context context, String eventId, String eventLabel) {
        try {
            Map<String, String> map = new HashMap<>();
            map.put("ver_name", OutHelp.get().getDexVersionName());
            map.put("ver_code", OutHelp.get().getDexVersionCode());
            UsageStats.onEvent(eventId, eventLabel);
        } catch (Exception e) {
        }
    }

    @Override
    public void onEvent(Context context, String eventId, String eventLabel, Map<String, Object> eventMap) {
        Map<String, String> map = new HashMap<>();
        if (eventMap != null) {
            for (String key : eventMap.keySet()) {
                Object value = eventMap.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        map.put(key, (String) value);
                    } else {
                        try {
                            map.put(key, String.valueOf(value));
                        } catch (Exception ex) {
                        }
                    }
                }
            }
        }
        try {
            map.put("ver_name", OutHelp.get().getDexVersionName());
            map.put("ver_code", OutHelp.get().getDexVersionCode());
            UsageStats.onEvent(eventId, eventLabel, map);
        } catch (Exception e) {
        }
    }

    @Override
    public void dotEvent(Context context, String eventId, String eventLabel, Map<String, Object> eventMap) {
        Map<String, String> map = new HashMap<>();
        if (eventMap != null) {
            for (String key : eventMap.keySet()) {
                Object value = eventMap.get(key);
                if (value != null) {
                    if (value instanceof String) {
                        map.put(key, (String) value);
                    } else {
                        try {
                            map.put(key, String.valueOf(value));
                        } catch (Exception ex) {
                        }
                    }
                }
            }
        }
        try {
            map.put("ver_name", OutHelp.get().getDexVersionName());
            map.put("ver_code", OutHelp.get().getDexVersionCode());
            UsageStats.onEvent(eventId, eventLabel, map);
        } catch (Exception e) {
        }
    }

    @Override
    public void onError(Context context, Throwable throwable) {
    }

    public void onEvent(Context context, String eventId, Map<String, String> eventMap) {
        Map<String, String> map = new ConcurrentHashMap<>();
        if (eventMap != null) {
            for (String key : eventMap.keySet()) {
                Object value = eventMap.get(key);
                if (value != null && value instanceof String) {
                    map.put(key, (String) value);
                }
            }
        }
        try {
            map.put("ver_name", OutHelp.get().getDexVersionName());
            map.put("ver_code", OutHelp.get().getDexVersionCode());
            UsageStats.onEvent(eventId, map);
        } catch (Exception e) {
        }
    }

    @Override
    public void dotEvent(String eventId) {
        try {
            Map<String, String> map = new HashMap<>();
            map.put("ver_name", OutHelp.get().getDexVersionName());
            map.put("ver_code", OutHelp.get().getDexVersionCode());
            UsageStats.onEvent(eventId, map);
        } catch (Exception e) {
        }
    }
}
