package com.zl.sdk.icon;

import android.text.TextUtils;

import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.OutConfig;
import com.zl.sdk.data.DataManager;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.out.DxManager;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.SPUtils;

import org.json.JSONObject;

public class IconHelp {
    private IconHelp() {
    }

    private static class Holder {
        private static final IconHelp INSTANCE = new IconHelp();
    }

    public static IconHelp get() {
        return Holder.INSTANCE;
    }

    private static final String TAG = "IconHelp ---> ";

    //icon是否可见
    private volatile boolean iconHide = false;

    //重试间隔时间  默认20秒
    private long retryShowAdTime = 20 * 1000L;
    //重试次数  默认2次
    private int retryShowAdCount = 2;

    public long getRetryShowAdTime() {
        return retryShowAdTime;
    }

    public int getRetryShowAdCount() {
        return retryShowAdCount;
    }

    public void setRetryShowAdTime(long retryShowAdTime) {
        this.retryShowAdTime = retryShowAdTime;
    }

    public void setRetryShowAdCount(int retryShowAdCount) {
        this.retryShowAdCount = retryShowAdCount;
    }


    public void init() {
        iconHide = OutHelp.get().iconIsHide();
        LogUtil.d(TAG + "初始化：检查icon状态 iconHide=" + iconHide);

        if (iconHide) {
            iconHadHide();
        }
    }

    public boolean isIconHide() {
        return iconHide;
    }

    /**
     * icon状态变化
     */
    public void changeIconState(boolean isHide) {
        if (iconHide == isHide) {
            return;
        }

        iconHide = isHide;
        LogUtil.d(TAG + "检查icon状态：iconHide=" + iconHide);

        if (iconHide) {
            iconHadHide();
        }
    }

    private static void statIconHideUser() {
        try {
            Statistics.getInstance().dotEvent("hd_ic_start");
        } catch (Exception e) {
        }
    }

    private void iconHadHide() {
        statIconHideUser();

        OutConfig adConfig = DataManager.get().getOutDataFromSP(OutHelp.get().getContext());
        if (adConfig != null) {
            IconHelp.get().setRetryShowAdCount(adConfig.retry_times);
            IconHelp.get().setRetryShowAdTime(adConfig.retry_interval_time * 1000L);
        }

        DxManager.get().removeAllSLKActivity();
        OutHelp.get().clearNotification();
        OutHelp.get().clearNotification();
    }
}