package com.zl.sdk.ad;

import static com.zl.sdk.bean.OutAdData.CP_AD_TOPON;
import static com.zl.sdk.bean.OutAdData.CP_AD_TYPE_CHAPING;

import android.text.TextUtils;

import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.OutAdData;
import com.zl.sdk.data.DataManager;
import com.zl.sdk.util.LogUtil;

import java.util.ArrayList;
import java.util.Map;

import cn.kw.lib.common.PROP;

public class AdDataManager {
    private AdDataManager() {
    }

    private static class Holder {
        private static final AdDataManager INSTANCE = new AdDataManager();
    }

    public static AdDataManager get() {
        return AdDataManager.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow AdDataManager --> ";

    private OutAdData.NormalAdData defaultData = null;

    public void setDefaultData(OutAdData.NormalAdData defaultData) {
        this.defaultData = defaultData;
    }

    public OutAdData.NormalAdData getDefaultData() {
        return defaultData;
    }


    public ArrayList<OutAdData.NormalAdData> getOutAdData(int position, String cpName) {
        Map<Integer, ArrayList<OutAdData.NormalAdData>> adDataFromSP = DataManager.get().getAdDataFromSP(OutHelp.get().getContext());

        ArrayList<OutAdData.NormalAdData> cpNameList = new ArrayList<>();

        if (adDataFromSP == null || adDataFromSP.isEmpty()) {
            LogUtil.d(TAG + "getOutAdData adDataMap empty");
            return cpNameList;
        }

        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG + "getOutAdData cpName empty");
            return cpNameList;
        }

        ArrayList<OutAdData.NormalAdData> list = adDataFromSP.get(position);

        if (list == null) {
            LogUtil.d(TAG + "getOutAdData list empty position =" + position);
            return cpNameList;
        }

        for (OutAdData.NormalAdData data : list) {
            LogUtil.d(TAG + "getOutAdData data.cpAdtype =" + data.cpAdtype + " ,cpName :" + cpName + ",,," + data.cpName);
            if (cpName.equalsIgnoreCase(data.cpName)) {
                if (CP_AD_TYPE_CHAPING.equals(data.cpAdtype)) {
                    LogUtil.d(TAG + "getOutAdData data = " + data);
                    cpNameList.add(data);
                }
            }
        }

        LogUtil.d(TAG + "getOutAdData list size =" + cpNameList.size());

        return cpNameList;
    }


    /**
     * 获取展示的广告信息
     *
     * @return
     */
    public OutAdData.NormalAdData getShowAdData() {
        try {
            OutAdData.NormalAdData adData = null;

            ArrayList<OutAdData.NormalAdData> list = AdDataManager.get().getOutAdData(OutAdData.POSITION_HOME, CP_AD_TOPON);

            int size = list.size();

            if (size > 0) {
                //TODO 去掉原生数据
           /* Random random = new Random();
            final int index = random.nextInt(size);
            try {
                adData = list.get(index);
            } catch (Exception ignored) {
            }*/
                adData = list.get(0);
            }

            if (adData == null) {
                adData = new OutAdData.NormalAdData();
                adData.cpName = OutAdData.CP_AD_TOPON;
                adData.cpAdtype = OutAdData.CP_AD_TYPE_CHAPING;
                adData.position = OutAdData.POSITION_HOME;
                adData.cpAppid = PROP.isTest() ? "a6501757a165c4" : "";
                adData.cpAdslot = PROP.isTest() ? "b6509805ed0208" : "";//cp:b6509805ed0208   native:b1f5eocpkk4f3f  release cp:b1f5i60t92g4gq
                adData.showCount = 5;
                adData.showTimes = 5;
                adData.interval = 1 * 60;//30分钟  未隐藏icon
                adData.intervalHide = 10 * 60;//10分钟  隐藏icon
                adData.showTimesHideForAdId = 30;
                adData.showTimeHide = 30;
                adData.moment = 8;
                adData.modeAd = 3;
                adData.modeContent = 3;
                adData.showTop = 10;
                adData.showMid = 10;
                adData.showBottom = 10;

//                adData = getDefaultData();
                LogUtil.d(TAG, "getAdData adData（test） =" + adData);
            } else {
                LogUtil.d(TAG, "getAdData adData(release) =" + adData);
            }
            return adData;
        } catch (Exception e) {
            LogUtil.d(TAG, "getAppOutAdData e =" + e);
        }
        return null;
    }
}
