package com.zl.sdk.event.statistics;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

import com.blankj.utilcode.util.LogUtils;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;


public class Utils {

    private static final Object TAG = "Utils";

    /**
     * 获取VersionName
     */
    public static String getAppVersionName(Context context) {
        String versionName = "unknown version";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            versionName = "" + packInfo.versionName;
        } catch (Exception e) {
        }
        return versionName;
    }

    /**
     * 获取VersionName
     */
    public static String getPackageName(Context context) {
        if (null == context) {
            return "";
        }

        return context.getApplicationContext().getPackageName();
    }

    /**
     * 获取VersionCode
     */
    public static int getAppVersionCode(Context context) {
        int versionCode = 0;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            versionCode = packInfo.versionCode;
        } catch (Exception e) {

        }
        return versionCode;
    }

    public static int dip2px(Context context, float dipValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dipValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);

    }

    public static int px2px(Context context, float pxValue) {
        final float scale = context.getResources().getDisplayMetrics().density;
        return (int) (pxValue / 1.5 * scale);
    }

    public static String getCurrStackExceptionInfo() {
        return "\n" + getExceptionInfo(new Exception());
    }

    public static String getExceptionInfo(Throwable ex) {
        if (null == ex) {
            return "";
        }
        PrintWriter pw = null;
        try {
            Writer errorWriter = new StringWriter();
            pw = new PrintWriter(errorWriter);
            ex.printStackTrace(pw);
            return errorWriter.toString();
        } catch (Exception e) {
            return "get exception info error " + e;
        } finally {
            closeIO(pw);
        }
    }

    public static void closeIO(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        } catch (IOException e) {
        }
    }

    private static ConnectivityManager connectivity;

    /**
     * 获取 ConnectivityManager
     *
     * @param context
     * @return
     */
    public static ConnectivityManager getConnectivityManager(Context context) {
        connectivity = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        return connectivity;
    }

    public static NetworkInfo getNetworkInfo(Context context) {
        connectivity = getConnectivityManager(context);
        if (connectivity == null) {
            return null;
        }
        try {
            return connectivity.getActiveNetworkInfo();
        } catch (Exception e) {
            return null;
        }
    }

    public static boolean equalNoThrow(String str1, String str2) {
        if (str1 != null && str2 != null) {
            if (str1.contentEquals(str2)) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isExceedLimitTime(long earlier, long later, long limitMillisecond) {
        return Math.abs(later - earlier) >= limitMillisecond;
    }



    public static int getDisplayWidth(Context context) {
        DisplayMetrics dm;
        int jellyBean_4_2 = 17;// android.os.Build.VERSION_CODES.JELLY_BEAN_MR1
        if (Build.VERSION.SDK_INT >= jellyBean_4_2) {
            WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            Display display = wm.getDefaultDisplay();
            dm = new DisplayMetrics();
            display.getRealMetrics(dm);
        } else {
            dm = context.getResources().getDisplayMetrics();
        }
        return dm.widthPixels;

    }

    /**
     * 获取未安装的APK信息
     *
     * @param context
     * @param archiveFilePath APK文件的路径。如：/sdcard/download/XX.apk
     */
    public static PackageInfo getApkInfo(Context context, String archiveFilePath) throws Exception {
        PackageManager pm = context.getPackageManager();
        PackageInfo apkInfo = pm.getPackageArchiveInfo(archiveFilePath, PackageManager.GET_META_DATA);
        return apkInfo;
    }

    public static String getApkVersionByFilePath(Context context, String archiveFilePath) {
        try {
            PackageInfo apkInfo = getApkInfo(context, archiveFilePath);
            return apkInfo.versionName;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static Bitmap getMediaBitmap(Bitmap bitmap, int mediaWidth, int mediaHeight) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();

        if (width <= mediaWidth || height <= mediaHeight) {
            LogUtils.d(TAG, "width = " + width + ", height = " + height);
            return bitmap;
        } else {
            int w;
            int h;
            int a = width * mediaHeight;
            int b = height * mediaWidth;
            if (a == b) {
                w = mediaWidth;
                h = mediaHeight;
            } else if (a > b) {
                w = a / height;
                h = mediaHeight;
            } else {
                w = mediaWidth;
                h = b / width;
            }
            LogUtils.d(TAG, "width = " + width + ", height = " + height + ", w = " + w + ", h = " + h);
            return Bitmap.createScaledBitmap(bitmap, w, h, true);
        }
    }

    /**
     * 打印当前线程的调用堆栈
     */
    public static String getTrackInfo() {
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        if (st == null) {
            System.out.println("无堆栈...");
            return "";
        }
        StringBuffer sbf = new StringBuffer();
        for (StackTraceElement e : st) {
            if (sbf.length() > 0) {
                sbf.append(" <- ");
                sbf.append(System.getProperty("line.separator"));
            }
            sbf.append(java.text.MessageFormat.format("{0}.{1}() {2}"
                    , e.getClassName()
                    , e.getMethodName()
                    , e.getLineNumber()));
        }
        return sbf.toString();
    }
}
