package com.zl.sdk;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import androidx.annotation.Keep;

import com.blankj.utilcode.util.AppUtils;
import com.pgl.ssdk.C;
import com.zl.sdk.ad.topOn.TopOnAdManager;
import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.DialogShowStatusCallback;
import com.zl.sdk.out.OutAdManager;
import com.zl.sdk.util.LogUtil;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Timer;
import java.util.TimerTask;

@Keep
public final class OutHelp implements KPListener {
    private OutHelp() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final OutHelp INSTANCE = new OutHelp();
    }

    public static OutHelp get() {
        return OutHelp.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow OutHelp ---> ";
    private Context mContext = null;
    private boolean isDebug = false;
    private Intent intent = null;


    //是否第一次轮询
    private boolean firstLx = true;

    //外展弹窗拉起回调
    private DialogShowStatusCallback dialogShowStatusCallback = null;

    /**
     * 初始化
     *
     * @param context 上下文
     * @param isDebug 开启调试
     * @param isDebug appId
     * @param isDebug appKey
     */
    public void init(Context context, boolean isDebug, String appId, String appKey) {
        this.mContext = context;
        this.isDebug = isDebug;

        AdAppInfo appInfo = new AdAppInfo("", "");
        //初始化广告SDK
        TopOnAdManager.get().initSDK(context, appInfo);

        //Icon初始化
//        IcOptManager.getInstance().init(context);
        IconHelp.get().init(context);

        //初始化触发条件
        initTriggerConditions();
    }

    private void initTriggerConditions() {
        initTimer();
        initReceiver();
    }

    private void initTimer() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                showOutAd(firstLx, null);
            }
        }, 60 * 1000);
    }

    private void initReceiver() {
        TriggerReceiver triggerReceiver = new TriggerReceiver();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction(Intent.ACTION_USER_PRESENT);
        intentfilter.addAction(Intent.ACTION_SCREEN_ON);
        intentfilter.addAction(Intent.ACTION_CLOSE_SYSTEM_DIALOGS);
        mContext.registerReceiver(triggerReceiver, intentfilter);
    }


    /**
     * 进入外展广告播放逻辑（解锁）
     *
     * @param actionFrom 动作来源
     * @param callback   结果回调
     */
    public void showOutAd(ActionFrom actionFrom, DialogShowStatusCallback callback) {
        intent = new Intent(mContext, );
        dialogShowStatusCallback = callback;
        OutAdManager.get().startShowOutAd(actionFrom);
    }


    /**
     * 进入外展广告播放逻辑 （轮询）
     *
     * @param isFirst  是否第一次检查
     * @param callback 结果回调
     */
    private void showOutAd(boolean isFirst, DialogShowStatusCallback callback) {
        intent = new Intent(mContext, );
        dialogShowStatusCallback = callback;
        OutAdManager.get().checkShowOutAd(isFirst);
    }


    public void startDialogSuccess() {
        LogUtil.d(TAG + "广告SLK 拉起成功");
        try {
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_OK, "", , actionState);
        } catch (Throwable throwable) {
        }
    }


//    /**
//     * 设置广告数据
//     *
//     * @param map         线上配置广告信息
//     * @param defaultData 本地默认广告信息
//     */
//    public void setAdDataMap(Map<Integer, ArrayList<WeatherAdData.NormalAdData>> map, WeatherAdData.NormalAdData defaultData) {
//        AdDataManager.get().setAdDataMap(map);
//        AdDataManager.get().setDefaultData(defaultData);
//    }


    public Context getContext() {
        return mContext;
    }

    public Intent getIntent() {
        return intent;
    }

    public boolean isDebug() {
        return isDebug;
    }

    public DialogShowStatusCallback getDialogShowStatusCallback() {
        return dialogShowStatusCallback;
    }

    public void cleanDialogCallBack() {
        dialogShowStatusCallback = null;
    }


    /**
     * 反射获取保活是否初始化
     */
    @Override
    public boolean isInit() {
        try {
            Class<?> kpClass = Class.forName("KplvManager");
            Method instanceMethod = kpClass.getMethod("getInstance");
            Object obj = instanceMethod.invoke(null);
            Method isInitMethod = kpClass.getMethod("isInit");
            Object isInit = isInitMethod.invoke(kpClass.cast(obj));
            if (isInit != null) {
                return (boolean) isInit;
            } else {
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            return false;
        }
    }

    /**
     * 反射获取icon状态
     */
    @Override
    public boolean iconShow() {
        return false;
    }


    @Override
    public boolean isAppForeground() {
        return AppUtils.isAppForeground(mContext.getPackageName());
    }

    /**
     * 反射调用保活拉起弹窗
     *
     * @param intent
     * @param callback
     */
    @Override
    public void startOutDialog(Intent intent, DialogShowStatusCallback callback) {
        try {
            Class<?> fgClass = Class.forName("FG");
            Method surpriseMethod = fgClass.getMethod("surprise");

            Class<?> startCallbackClass = Class.forName("StartCallback");
            Constructor constructor = startCallbackClass.getConstructor();
            Object callObj = constructor.newInstance();

            Object newCallBack = Proxy.newProxyInstance(
                    startCallbackClass.getClassLoader(),
                    new Class[]{startCallbackClass},
                    new StartCallbackProxy(callObj, callback)
            );

            surpriseMethod.invoke(null, mContext, intent, "", true, newCallBack);
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException | InstantiationException e) {
            if (callback != null) {
                callback.fail("执行失败");
            }
        }
    }


    public class StartCallbackProxy implements InvocationHandler {
        private Object proxyObj;
        private DialogShowStatusCallback callback;

        public StartCallbackProxy(Object obj, DialogShowStatusCallback callback) {
            this.proxyObj = obj;
            this.callback = callback;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (callback != null) {
                if ("onSuccess".equals(method.getName())) {
                    callback.success();
                } else if ("onFail".equals(method.getName())) {
                    if (objects.length >= 2) {
                        callback.fail((String) objects[1]);
                    } else {
                        callback.fail("unknown");
                    }
                }
            }
            return method.invoke(proxyObj, objects);
        }
    }

    public class TriggerReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            switch (action) {
                case Intent.ACTION_USER_PRESENT: {
                    LogUtil.d("OutShow ===>>> 解锁");
                    OutHelp.get().showOutAd(ActionFrom.ACTION_USER_PRESENT, null);
                    break;
                }
                case Intent.ACTION_SCREEN_ON: {
                    LogUtil.d("OutShow ===>>> 亮屏");
                    break;
                }
                case Intent.ACTION_CLOSE_SYSTEM_DIALOGS: {
                    LogUtil.d("OutShow ===>>> 桌面");
                    break;
                }
                default: {
                }
            }
        }
    }
}