package com.zl.sdk.ad;

import static com.zl.sdk.bean.WeatherAdData.CP_AD_TYPE_CHAPING;

import android.text.TextUtils;

import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.util.LogUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AdDataManager {
    private AdDataManager() {
    }

    private static class Holder {
        private static final AdDataManager INSTANCE = new AdDataManager();
    }

    public static AdDataManager get() {
        return AdDataManager.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow AdDataManager --> ";

    private Map<Integer, ArrayList<WeatherAdData.NormalAdData>> adDataMap = new HashMap();

    private WeatherAdData.NormalAdData defaultData = null;

    public void setAdDataMap(Map<Integer, ArrayList<WeatherAdData.NormalAdData>> adDataMap) {
        this.adDataMap = adDataMap;
    }

    public void setDefaultData(WeatherAdData.NormalAdData defaultData) {
        this.defaultData = defaultData;
    }

    public WeatherAdData.NormalAdData getDefaultData() {
        return defaultData;
    }

    public ArrayList<WeatherAdData.NormalAdData> getOutAdData(int position, String cpName) {
        ArrayList<WeatherAdData.NormalAdData> cpNameList = new ArrayList<>();

        if (adDataMap == null || adDataMap.isEmpty()) {
            LogUtil.d(TAG + "getOutAdData adDataMap empty");
            return cpNameList;
        }

        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG + "getOutAdData cpName empty");
            return cpNameList;
        }

        ArrayList<WeatherAdData.NormalAdData> list = adDataMap.get(position);

        if (list == null) {
            LogUtil.d(TAG + "getOutAdData list empty position =" + position);
            return cpNameList;
        }

        for (WeatherAdData.NormalAdData data : list) {
            LogUtil.d(TAG + "getOutAdData data.cpAdtype =" + data.cpAdtype + " ,cpName :" + cpName + ",,," + data.cpName);
            if (cpName.equalsIgnoreCase(data.cpName)) {
                if (CP_AD_TYPE_CHAPING.equals(data.cpAdtype)) {
                    cpNameList.add(data);
                }
            }
        }

        LogUtil.d(TAG + "getOutAdData list size =" + cpNameList.size());

        return cpNameList;
    }


    /**
     * 获取展示的广告信息
     *
     * @return
     */
    public WeatherAdData.NormalAdData getShowAdData() {
        try {
            WeatherAdData.NormalAdData adData = null;

            ArrayList<WeatherAdData.NormalAdData> list = AdDataManager.get().getOutAdData(WeatherAdData.POSITION_HOME, WeatherAdData.CP_AD_TOPON);

            int size = list.size();

            if (size > 0) {
                //TODO 去掉原生数据
           /* Random random = new Random();
            final int index = random.nextInt(size);
            try {
                adData = list.get(index);
            } catch (Exception ignored) {
            }*/
                adData = list.get(0);
            }

            if (adData == null) {
//            adData = new WeatherAdData.NormalAdData();
//            adData.cpName = WeatherAdData.CP_AD_TOPON;
//            adData.cpAdtype = WeatherAdData.CP_AD_TYPE_CHAPING;
//            adData.position = WeatherAdData.POSITION_HOME;
//            adData.cpAppid = "a654e2fe6de6d6";
//            adData.cpAdslot = "b1f5i60t92g4gq";//cp:b1f5eocpkk4pq8   native:b1f5eocpkk4f3f  release cp:b1f5i60t92g4gq
//            adData.showCount = 5;
//            adData.showTimes = 5;
//            adData.interval = 30 * 60;//30分钟  未隐藏icon
//            adData.intervalHide = 10 * 60;//10分钟  隐藏icon
//            adData.showTimesHideForAdId = 30;
//            adData.showTimeHide = 30;
//            adData.moment = 8;
//            adData.modeAd = 3;
//            adData.modeContent = 3;
//            adData.showTop = 10;
//            adData.showMid = 10;
//            adData.showBottom = 10;

                adData = getDefaultData();
                LogUtil.d(TAG, "getAdData adData（test） =" + adData);
            } else {
                LogUtil.d(TAG, "getAdData adData(release) =" + adData);
            }
            return adData;
        } catch (Exception e) {
            LogUtil.d(TAG, "getAppOutAdData e =" + e);
        }
        return null;
    }
}
