/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.os.Parcelable;
import com.or.ange.database.ColumnModel;
import com.or.ange.database.LikeModel;
import com.or.ange.database.ModelHolder;
import com.or.ange.database.SerializeUtils;
import com.or.ange.database.TableModel;
import com.or.ange.database.Type;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

abstract class AbstractLikeModel<T>
implements LikeModel<T> {
    private final ModelHolder<T> holder;

    AbstractLikeModel(Class<T> clazz, String dbName, String table) {
        this.holder = new ModelHolder<T>(clazz, dbName, table);
    }

    ContentValues getContentValues(T obj) throws IllegalAccessException {
        ContentValues values = new ContentValues();
        Collection<ColumnModel> models = this.getTable().getColumnModels();
        for (ColumnModel model : models) {
            String name = model.getName();
            Field field = model.getField();
            Object value = field.get(obj);
            Type<?> type = model.getType();
            if (Type.Bitmap.equals(type)) {
                Bitmap bitmap = Type.Bitmap.cast(value);
                if (bitmap == null) continue;
                model.put(values, name, SerializeUtils.toBytes(bitmap));
                continue;
            }
            if (Type.Serializable.equals(type)) {
                Serializable serializable = Type.Serializable.cast(value);
                if (serializable == null) continue;
                model.put(values, name, SerializeUtils.toBytes(serializable));
                continue;
            }
            if (Type.Parcelable.equals(type)) {
                Parcelable parcelable = Type.Parcelable.cast(value);
                if (parcelable == null) continue;
                model.put(values, name, SerializeUtils.toBytes(parcelable));
                continue;
            }
            model.put(values, name, value);
        }
        return values;
    }

    List<T> getResult(String[] columns, String[] as, Cursor cursor) throws Exception {
        ArrayList<T> dataList = new ArrayList<T>();
        if (cursor.moveToFirst()) {
            do {
                Constructor<T> constructor = this.getTable().getClazz().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                T item = constructor.newInstance(new Object[0]);
                for (ColumnModel model : this.getTable().getColumnModels()) {
                    Object parcelable;
                    Type<?> type = model.getType();
                    Field field = model.getField();
                    int columnIndex = cursor.getColumnIndex(this.getColumnIndexName(model.getName(), columns, as));
                    if (columns != null && !this.hasObject(columns, model.getName())) continue;
                    if (Type.Integer.equals(type)) {
                        field.set(item, cursor.getInt(columnIndex));
                        continue;
                    }
                    if (Type.Float.equals(type)) {
                        field.set(item, Float.valueOf(cursor.getFloat(columnIndex)));
                        continue;
                    }
                    if (Type.Double.equals(type)) {
                        field.set(item, cursor.getDouble(columnIndex));
                        continue;
                    }
                    if (Type.Long.equals(type)) {
                        field.set(item, cursor.getLong(columnIndex));
                        continue;
                    }
                    if (Type.Short.equals(type)) {
                        field.set(item, cursor.getShort(columnIndex));
                        continue;
                    }
                    if (Type.Character.equals(type)) {
                        field.set(item, cursor.getString(columnIndex));
                        continue;
                    }
                    if (Type.Boolean.equals(type)) {
                        field.set(item, cursor.getInt(columnIndex) == 1);
                        continue;
                    }
                    if (Type.String.equals(type)) {
                        field.set(item, cursor.getString(columnIndex));
                        continue;
                    }
                    if (Type.ByteArray.equals(type)) {
                        field.set(item, cursor.getBlob(columnIndex));
                        continue;
                    }
                    if (Type.Bitmap.equals(type)) {
                        Bitmap bitmap = SerializeUtils.toBitmap(cursor.getBlob(columnIndex));
                        if (bitmap == null) continue;
                        field.set(item, bitmap);
                        continue;
                    }
                    if (Type.Serializable.equals(type)) {
                        Object serializable = SerializeUtils.toSerializable(cursor.getBlob(columnIndex));
                        if (serializable == null) continue;
                        field.set(item, serializable);
                        continue;
                    }
                    if (!Type.Parcelable.equals(type) || (parcelable = SerializeUtils.toParcelable(cursor.getBlob(columnIndex), field.getType())) == null) continue;
                    field.set(item, parcelable);
                }
                dataList.add(item);
            } while (cursor.moveToNext());
        }
        return dataList;
    }

    TableModel<T> getTable() {
        return this.holder.getTable();
    }

    boolean checkTable() {
        return this.getTable() != null;
    }

    String getDbName() {
        return this.holder.getDbName();
    }

    void releaseTable() {
        this.holder.releaseTable();
    }

    private String getColumnIndexName(String name, String[] columns, String[] as) {
        if (as == null) {
            return name;
        }
        if (columns == null) {
            return name;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].equals(name)) continue;
            return as[i];
        }
        return name;
    }

    private boolean hasObject(String[] list, String key) {
        if (list != null && list.length > 0) {
            for (String item : list) {
                if (!item.equals(key)) continue;
                return true;
            }
        }
        return false;
    }
}

