package com.zl.sdk.out;

import com.zl.sdk.bean.RemindersInfo;
import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.out.ui.DxActivity;

import java.util.Stack;

public class DxManager {
    private DxManager() {
    }

    private static class Holder {
        private static final DxManager INSTANCE = new DxManager();
    }

    public static DxManager get() {
        return DxManager.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow DxManager --> ";


    private RemindersInfo outRemindersInfo = null;
    private WeatherAdData.NormalAdData outAdData = null;

    public RemindersInfo getOutRemindersInfo() {
        return outRemindersInfo;
    }

    public void setOutRemindersInfo(RemindersInfo outRemindersInfo) {
        this.outRemindersInfo = outRemindersInfo;
    }

    public WeatherAdData.NormalAdData getOutAdData() {
        return outAdData;
    }

    public void setOutAdData(WeatherAdData.NormalAdData outAdData) {
        this.outAdData = outAdData;
    }


    private final Stack<DxActivity> appOutActivities = new Stack<>();


    public boolean existAppOutActivities() {
        return !appOutActivities.isEmpty();
    }


    public void addActivity(DxActivity activity) {
        appOutActivities.push(activity);
    }

    public void removeActivity(DxActivity activity) {
        appOutActivities.remove(activity);
    }

    public void removeAllSLKActivity() {
        if (appOutActivities.isEmpty()) {
            return;
        }

        for (DxActivity activity : appOutActivities) {
            activity.finishAndRemoveTask();
        }

        appOutActivities.clear();
    }
}
