package com.zl.sdk.ad.topOn;

import android.content.Context;

import com.anythink.core.api.ATSDK;
import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.util.LogUtil;

import cn.kw.lib.common.PROP;

public class TopOnAdManager {
    private static String TAG = "OutShow TopOn Ad ---> ";

    private TopOnAdManager() {
    }

    private static class Holder {
        private static final TopOnAdManager INSTANCE = new TopOnAdManager();
    }

    public static TopOnAdManager get() {
        return Holder.INSTANCE;
    }

    public void initSDK(Context context, AdAppInfo appInfo) {
        if (appInfo == null) {
            LogUtil.e(TAG, "ad app info is null");
            return;
        }

        LogUtil.d(TAG + "初始化：topon应用信息：" + appInfo);

        //SDK日志功能，集成测试阶段建议开启，上线前必须关闭
        ATSDK.setNetworkLogDebug(PROP.isLogEnabled());

//        ATSDK.setDebuggerConfig(
//                context,
//                "596795a7-b851-4514-bd7e-8561d641a968",
//                new ATDebuggerConfig.Builder(Pangle_NETWORK).build());

        ATSDK.init(context, appInfo.app_id, appInfo.app_key);
    }
}
