package com.zl.sdk.data;

import static com.zl.sdk.bean.OutAdData.CP_AD_TOPON;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.zl.sdk.bean.IconOpt;
import com.zl.sdk.bean.OutAdData;
import com.zl.sdk.bean.OutConfig;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.SPUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据管理类
 */
public class DataManager {
    private DataManager() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final DataManager INSTANCE = new DataManager();
    }

    public static DataManager get() {
        return DataManager.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow DataManager ---> ";
    private static final String CONFIG_SP = "configSp";
    private static final String AD_CONFIG = "ads_config";
    private static final String OUT_CONFIG = "out_config";
    private static final String ICON_CONFIG = "icon_config";

    private Map<Integer, ArrayList<OutAdData.NormalAdData>> adDataMap = null;
    private IconOpt iconOpt = null;
    private OutConfig outConfig = null;

    /**
     * 从SP中获取广告信息
     */
    public Map<Integer, ArrayList<OutAdData.NormalAdData>> getAdDataFromSP(Context context) {
        if (adDataMap != null) {
            LogUtil.d(TAG + "Ad配置 1 = " + adDataMap);
            return adDataMap;
        }

        String adConfigString = SPUtils.getInstance(context, CONFIG_SP).getString(AD_CONFIG, "");
        LogUtil.d(TAG + "Ad配置 adConfigString= " + adConfigString);

        OutAdData outAdData = null;

        if (!TextUtils.isEmpty(adConfigString)) {
            outAdData = new Gson().fromJson(adConfigString, OutAdData.class);

            LogUtil.d(TAG + "Ad配置 weatherAdData= " + outAdData);
            if (outAdData == null) {
                SPUtils.getInstance(context, CONFIG_SP).remove(AD_CONFIG, true);
            }
        }


        if (outAdData == null) {
            LogUtil.d(TAG + "Ad配置 error 1");
            return null;
        }

        OutAdData.Data data = outAdData.getData();
        if (data == null) {
            LogUtil.d(TAG + "Ad配置 error 2");
            return null;
        }

        if (data.normal.isEmpty()) {
            LogUtil.d(TAG + "Ad配置 error 3");
            return null;
        }

        adDataMap = new HashMap<>();

        for (OutAdData.NormalAdData adData : data.normal) {
            if (adData.isSelfFlag()) {
                continue;
            }
            List<OutAdData.CpAdData> cpList = adData.cpList;
            if (cpList.isEmpty()) {
                continue;
            }

            if (adData.isWZAdType()) {
                ArrayList<OutAdData.NormalAdData> adDataList = new ArrayList<>();
                for (OutAdData.CpAdData cpAdData : cpList) {
                    String cpName = cpAdData.name;
                    String appid = cpAdData.appid;
                    String adslot = cpAdData.adslot;
                    String adType = cpAdData.adType;
                    if (CP_AD_TOPON.equalsIgnoreCase(cpName)
                            && !TextUtils.isEmpty(cpName)
                            && !TextUtils.isEmpty(appid)
                            && !TextUtils.isEmpty(adslot)
                            && !TextUtils.isEmpty(adType)) {
                        adData.cpName = cpAdData.name;
                        adData.cpAppid = cpAdData.appid;
                        adData.cpAdslot = cpAdData.adslot;
                        adData.cpAdtype = cpAdData.adType;
                        adData.showTimes = cpAdData.showTimes;
                        adData.showTimesHideForAdId = cpAdData.showTimesHide;
                        adData.adStyle = cpAdData.adStyle;
                        adData.ad_Scenes = "wz";
                        OutAdData.NormalAdData newAdData = adData.cloneAdData();
                        adDataList.add(newAdData);
                    }
                }
                LogUtil.d(TAG + "Ad配置 adData = " + data);
                adDataMap.put(adData.position, adDataList);
            }
        }
        LogUtil.d(TAG + "Ad配置 2 = " + adDataMap);
        return adDataMap;
    }

    /**
     * 从SP中获取外展配置数据
     */
    public OutConfig getOutDataFromSP(Context context) {
        if (outConfig != null) {
            LogUtil.d(TAG + "Out配置 1 = " + outConfig);
            return outConfig;
        }

        String outConfigString = SPUtils.getInstance(context, CONFIG_SP).getString(OUT_CONFIG, "");

        if (!TextUtils.isEmpty(outConfigString)) {
            LogUtil.d(TAG + "Out配置 SP数据：" + outConfigString);
            outConfig = new Gson().fromJson(outConfigString, OutConfig.class);

            if (outConfig == null) {
                SPUtils.getInstance(context, CONFIG_SP).remove(OUT_CONFIG, true);
            }
        } else {
            LogUtil.d(TAG + "Out配置 SP数据为空");
        }
        LogUtil.d(TAG + "Out配置 2 = " + outConfig);
        return outConfig;
    }

    /**
     * 从SP中获取Icon配置数据
     */
    public IconOpt getIconDataFromSP(Context context) {
        if (iconOpt != null) {
            LogUtil.d(TAG + "icon配置 1 = " + iconOpt);
            return iconOpt;
        }

        String iconConfigString = SPUtils.getInstance(context, CONFIG_SP).getString(ICON_CONFIG, "");
        if (!TextUtils.isEmpty(iconConfigString)) {
            LogUtil.d(TAG + "icon配置 SP数据：" + iconConfigString);

            iconOpt = new Gson().fromJson(iconConfigString, IconOpt.class);
            LogUtil.d(TAG + "icon配置 222 = " + iconOpt);

            if (iconOpt == null) {
                SPUtils.getInstance(context, CONFIG_SP).remove(ICON_CONFIG, true);
            }
        } else {
            LogUtil.d(TAG + "icon配置 SP数据为空");
        }
        LogUtil.d(TAG + "icon配置 2 = " + iconOpt);
        return iconOpt;
    }

}
