/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.or.ange.database.ColumnModel;
import com.or.ange.database.LikePalException;
import com.or.ange.database.Operator;
import com.or.ange.database.annotation.Table;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TableModel<T> {
    private final Class<T> clazz;
    private final String tableName;
    private final Map<String, ColumnModel> columnModels;
    private final String dbName;

    TableModel(Class<T> clazz, String dbName, String tableName) {
        this.clazz = clazz;
        this.dbName = dbName;
        this.tableName = this.createTableName(tableName);
        this.columnModels = this.createColumnModels();
        this.connectTable();
    }

    ColumnModel getColumnModelByName(String name) {
        ColumnModel columnModel = this.columnModels.get(name);
        if (columnModel == null) {
            throw new IllegalArgumentException("illegal column:" + name);
        }
        return columnModel;
    }

    private String createTableName(String tableName) {
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            return tableName;
        }
        Table annotation = this.clazz.getAnnotation(Table.class);
        if (annotation != null) {
            return TextUtils.isEmpty((CharSequence)annotation.name()) ? this.clazz.getSimpleName() : annotation.name();
        }
        return this.clazz.getSimpleName();
    }

    private Map<String, ColumnModel> createColumnModels() {
        HashMap<String, ColumnModel> models = new HashMap<String, ColumnModel>();
        List<Field> fields = this.getAllFields(this.clazz);
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            ColumnModel columnModel = new ColumnModel(field);
            if (columnModel.isIgnore()) continue;
            models.put(columnModel.getName(), columnModel);
        }
        return models;
    }

    private void connectTable() {
        SQLiteDatabase db = Operator.getDatabase(this.dbName);
        db.execSQL(this.getCreateTableSql());
        this.createIndex(db);
        this.forUpdateColumn(db);
    }

    private void createIndex(SQLiteDatabase db) {
        try {
            for (ColumnModel columnModel : this.columnModels.values()) {
                String columnIndex = columnModel.getIndex();
                if (TextUtils.isEmpty((CharSequence)columnIndex)) continue;
                db.execSQL("CREATE INDEX IF NOT EXISTS " + columnIndex + " ON " + this.getTableName() + " (" + columnModel.getName() + ");");
            }
        }
        catch (Exception e) {
            throw new LikePalException("create index exception", e);
        }
    }

    private void forUpdateColumn(SQLiteDatabase db) {
        ArrayList<String> columnNames = new ArrayList<String>();
        try (Cursor cursor = db.rawQuery("PRAGMA table_info(" + this.tableName + ")", null);){
            if (cursor.moveToFirst()) {
                do {
                    String name = cursor.getString(cursor.getColumnIndexOrThrow("name"));
                    columnNames.add(name);
                } while (cursor.moveToNext());
            }
        }
        catch (Exception e) {
            throw new LikePalException("update column exception", e);
        }
        for (ColumnModel columnModel : this.columnModels.values()) {
            if (columnNames.contains(columnModel.getName()) || TextUtils.isEmpty((CharSequence)columnModel.getDbType())) continue;
            db.execSQL("ALTER TABLE " + this.tableName + " ADD COLUMN " + columnModel.getName() + " " + columnModel.getDbType());
            String columnIndex = columnModel.getIndex();
            if (TextUtils.isEmpty((CharSequence)columnIndex)) continue;
            db.execSQL("CREATE INDEX IF NOT EXISTS " + columnIndex + " ON " + this.getTableName() + " (" + columnModel.getName() + ");");
        }
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        return this.getAllFields(clazz, fields);
    }

    private List<Field> getAllFields(Class<?> clazz, List<Field> fields) {
        Field[] declaredFields = clazz.getDeclaredFields();
        fields.addAll(Arrays.asList(declaredFields));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return fields;
        }
        if (Object.class.equals(superClass)) {
            return fields;
        }
        return this.getAllFields(superClass, fields);
    }

    private String getCreateTableSql() {
        int primaryKeyCount = this.checkPrimaryKey();
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS ");
        sql.append(this.tableName).append("(");
        for (ColumnModel model : this.columnModels.values()) {
            String dbType = model.getDbType();
            String name = model.getName();
            sql.append(name).append(' ');
            sql.append(dbType).append(' ');
            if (model.isPrimaryKey()) {
                if (primaryKeyCount == 1) {
                    sql.append("PRIMARY KEY").append(' ');
                }
                if (model.isAutoIncrement() && model.isAutoIncrementKey()) {
                    sql.append("AUTOINCREMENT").append(' ');
                }
            }
            if (model.isNotnull()) {
                sql.append("NOT NULL").append(' ');
            }
            if (model.isUnique()) {
                sql.append("UNIQUE").append(' ');
            }
            if (!TextUtils.isEmpty((CharSequence)model.getCheck())) {
                sql.append("CHECK(").append(model.getCheck()).append(")").append(' ');
            }
            sql.append(',');
        }
        if (primaryKeyCount > 1) {
            sql.append("PRIMARY KEY (");
            for (ColumnModel model : this.columnModels.values()) {
                if (!model.isPrimaryKey() || !model.isLegalKey()) continue;
                sql.append("'").append(model.getName()).append("'").append(",");
            }
            if (sql.charAt(sql.length() - 1) == ',') {
                sql.deleteCharAt(sql.length() - 1);
            }
            sql.append(")");
        } else if (sql.charAt(sql.length() - 1) == ',') {
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(")");
        return sql.toString();
    }

    private int checkPrimaryKey() {
        int primaryKeyCount = 0;
        int autoIncrementCount = 0;
        for (ColumnModel model : this.columnModels.values()) {
            if (!model.isPrimaryKey()) continue;
            if (model.isLegalKey()) {
                ++primaryKeyCount;
            } else {
                throw new LikePalException("primary key type must for integer or text");
            }
            if (!model.isAutoIncrement() || !model.isAutoIncrementKey()) continue;
            ++autoIncrementCount;
        }
        if (primaryKeyCount == 0) {
            throw new IllegalStateException("without primary key.");
        }
        if (primaryKeyCount > 1 && autoIncrementCount > 0) {
            throw new IllegalStateException("more primary key and have auto increment key");
        }
        return primaryKeyCount;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Collection<ColumnModel> getColumnModels() {
        return this.columnModels.values();
    }

    public String getDbName() {
        return this.dbName;
    }
}

