/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.or.ange.database.LikeModel;
import com.or.ange.database.LikeModelFactory;
import com.or.ange.database.LikeOpenHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class Operator {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;
    private static final Map<String, LikeOpenHelper> openHelper;

    Operator() {
    }

    static void initialize(Context context) {
        if (context == null) {
            throw new NullPointerException("initialize context is null");
        }
        Operator.context = context.getApplicationContext();
    }

    static synchronized SQLiteDatabase getDatabase(String dbName) {
        SQLiteDatabase db;
        LikeOpenHelper likeOpenHelper = openHelper.get(dbName);
        if (likeOpenHelper == null) {
            likeOpenHelper = new LikeOpenHelper(dbName);
            openHelper.put(dbName, likeOpenHelper);
        }
        if ((db = likeOpenHelper.getDatabase()) != null && db.isOpen()) {
            return db;
        }
        likeOpenHelper = new LikeOpenHelper(dbName);
        openHelper.put(dbName, likeOpenHelper);
        return likeOpenHelper.getDatabase();
    }

    static synchronized void release(String dbName) {
        LikeOpenHelper helper = openHelper.get(dbName);
        if (helper != null) {
            helper.release();
        }
    }

    static Context getContext() {
        Operator.checkInitialize();
        return context;
    }

    static <T> LikeModel<T> getLikeModel(Class<T> clazz, String dbName, String table) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null.");
        }
        Operator.checkInitialize();
        return LikeModelFactory.getInstance().getLikeModel(clazz, dbName, table);
    }

    private static void checkInitialize() {
        if (context == null) {
            throw new IllegalStateException("must initialize first.");
        }
    }

    static {
        openHelper = new ConcurrentHashMap<String, LikeOpenHelper>();
    }
}

