#--------------------------1.通用-------------------------------
# 设置混淆的压缩比率 0 ~ 7
-optimizationpasses 5
# 混淆时不使用大小写混合，混淆后的类名为小写
-dontusemixedcaseclassnames
# 指定不去忽略非公共库的类
-dontskipnonpubliclibraryclasses
# 指定不去忽略非公共库的成员
-dontskipnonpubliclibraryclassmembers
# 混淆时不做预校验
-dontpreverify
# 混淆时不记录日志
-verbose
# 忽略警告
-ignorewarnings
# 代码优化
-dontshrink
# 不优化输入的类文件
-dontoptimize
# 保留注解不混淆
-keepattributes *Annotation*,InnerClasses
# 避免混淆泛型
-keepattributes Signature
# 保留代码行号，方便异常信息的追踪
-keepattributes SourceFile,LineNumberTable
# 混淆采用的算法
-optimizations !code/simplification/cast,!field/*,!class/merging/*

# dump.txt文件列出apk包内所有class的内部结构
-dump class_files.txt
# seeds.txt文件列出未混淆的类和成员
-printseeds seeds.txt
# usage.txt文件列出从apk中删除的代码
-printusage unused.txt
# mapping.txt文件列出混淆前后的映射
-printmapping mapping.txt

#--------------------------2.通用配置-------------------------------
#枚举类
-keepclassmembers enum * {
    public static **[] values();
    public static ** valueOf(java.lang.String);
}

#native
-keepclasseswithmembernames class * {
    native <methods>;
}

#注解
-keepattributes *Annotation*

#LiveData
-keep class androidx.lifecycle.LiveData {*;}
-keep class androidx.lifecycle.LiveData$ObserverWrapper {*;}
-keep class androidx.arch.core.internal.SafeIterableMap {*;}

#Parcelable
-keep class * implements android.os.Parcelable {
  public static final android.os.Parcelable$Creator *;
}

#Serializable
-keepclassmembers class * implements java.io.Serializable {
    static final long serialVersionUID;
    private static final java.io.ObjectStreamField[] serialPersistentFields;
    !static !transient <fields>;
    private void writeObject(java.io.ObjectOutputStream);
    private void readObject(java.io.ObjectInputStream);
    java.lang.Object writeReplace();
    java.lang.Object readResolve();
}

#去除日志打包
-assumenosideeffects class android.util.Log {
   public static *** d(...);
   public static *** v(...);
   public static *** i(...);
   public static *** w(...);
   public static *** e(...);
}

#实体类
-keep class com.zl.sdk.bean.**{*;}

-keep public class * extends android.app.Service

# Retrofit
-dontwarn retrofit2.**
-keep class retrofit2.$** { *; }
-keepattributes Signature
-keepattributes Exceptions

-keepattributes JavascriptInterface

-keep public class * implements com.bumptech.glide.module.GlideModule
-keep public enum com.bumptech.glide.load.resource.bitmap.ImageHeaderParser$** {
  **[] $VALUES;
  public *;
}

#Gson
-keepattributes Signature
-keepattributes *Annotation*
-keep class com.google.gson.* { *;}
-dontwarn com.google.gson.**