package com.zl.sdk.out.ui;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.zl.sdk.ad.OnInAdListener;
import com.zl.sdk.ad.TopOnAdLoadManager;
import com.zl.sdk.bean.RemindersInfo;
import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.AdScenes;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.AppOutSP;
import com.zl.sdk.util.DpiUtil;
import com.zl.sdk.util.LogUtil;

import java.util.HashMap;
import java.util.Map;

class WeatherPureAdDialog extends AbsView {
    private static final String TAG = "WeatherPureAdDialog";
    private FrameLayout rootView;
    private RemindersInfo remindersInfo;
    private WeatherAdData.NormalAdData data;
    private View contentView;
//    private LinearLayout weatherAdContainer;

    private OnInAdListener onInAdListener;

    public WeatherPureAdDialog(RemindersInfo remindersInfo, WeatherAdData.NormalAdData data) {
        this.remindersInfo = remindersInfo;
        this.data = data;
    }

    @Override
    public void onCreate(Activity activity, Intent intent, FrameLayout rootView) {
        this.activity = activity;
        this.rootView = rootView;
        if (data == null) {
            finishActivity();
            return;
        }
        initView();
        initData();
    }


    @Override
    public void onResume() {
    }


    @Override
    public void onPause() {
    }


    private void initView() {
        contentView = getContentView();
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.MATCH_PARENT,
                FrameLayout.LayoutParams.WRAP_CONTENT
        );

        rootView.addView(contentView, params);
//        weatherAdContainer = contentView.findViewById(R.id.weatherAdContainer);
    }

    private View getContentView() {
        //TODO 只加了根容器，原生广告容器没添加
        RelativeLayout relativeLayout = new RelativeLayout(activity);
        int padding = DpiUtil.dipTopx(8);
        relativeLayout.setPadding(padding, padding, padding, padding);
        relativeLayout.setBackgroundColor(Color.TRANSPARENT);
        return relativeLayout;
    }


    private void initData() {
        if (!remindersInfo.isAdType) {
            LogUtil.d(TAG + "initAd no isAdType");
            finishActivity();
            return;
        }

        String cpName = data.cpName;
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG + "initAd cpName empty");
            finishActivity();
            return;
        }

        String adUnitId = data.cpAdslot;
        if (TextUtils.isEmpty(adUnitId)) {
            LogUtil.d(TAG + "initAd cpAdslot empty");
            finishActivity();
            return;
        }

        String adType = data.cpAdtype;
        if (TextUtils.isEmpty(adType)) {
            LogUtil.d(TAG + "initAd adType empty");
            finishActivity();
            return;
        }
        if (adType.equals(WeatherAdData.CP_AD_TYPE_BANNER)) {
            LogUtil.d(TAG + "initAd adType banner");
            finishActivity();
            return;
        }

        registerCallBack(adType);

        if (adType.equals(WeatherAdData.CP_AD_TYPE_CHAPING)) {
            checkCanShowItAd(cpName, adUnitId);
            return;
        }

//        if (adType.equals(WeatherAdData.CP_AD_TYPE_NATIVE)) {
//            checkCanShowNativeAd();
//            return;
//        }

        LogUtil.d(TAG + "initAd no support adType=" + adType);
        finishActivity();
    }


    private void registerCallBack(String adType) {
        onInAdListener = new OnInAdListener() {
            @Override
            public void onCloseAd() {
                LogUtil.d(TAG + "initAd onCloseAd");
                finishActivity();
            }

            @Override
            public void onLoadAd() {
                LogUtil.d(TAG + "initAd onLoadAd");
            }

            @Override
            public void onShow() {
                LogUtil.d(TAG + "initAd onShow");
            }

            @Override
            public void onNotAd(String errorMessage) {
                LogUtil.d(TAG + "initAd onNotAd errorMessage =" + errorMessage);
                EventUtils.statOutOnlyAdFail(remindersInfo, data, errorMessage);
                finishActivity();
            }

            @Override
            public void onClk() {
                LogUtil.d(TAG + "initAd onClk");
                finishActivity();
            }

            @Override
            public void cacheDataTimeOut() {
                LogUtil.d(TAG + "initAd cacheDataTimeOut");
            }
        };
        TopOnAdLoadManager.getInstance().registerCallBack(adType, TopOnAdLoadManager.REGISTER_TAG_WEATHER_PURE_AD, onInAdListener);
    }


    private void checkCanShowItAd(String cpName, String adUnitId) {
        boolean isReady = TopOnAdLoadManager.getInstance().isInterstitialReady(cpName, adUnitId);
        LogUtil.d(TAG + "initAd interstitial isReady =" + isReady);

        statAdDialogExp(isReady);

        if (isReady) {
            showInterstitial();
            return;
        }

        TopOnAdLoadManager.getInstance().loadInterstitialAd(data, AdScenes.AD_SCENES_PURE);
        finishActivity();
    }

    private void statAdDialogExp(boolean adReady) {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("ad_ready", String.valueOf(adReady));
            Statistics.getInstance().dotEvent(activity, "ad_dialog_exp", "", map);
        } catch (Exception e) {
        }
    }


//    private void checkCanShowNativeAd() {
//        Object cacheData = TopOnAdLoadManager.getInstance().getAdCacheData(data.cpAdslot);
//        boolean hasCache = cacheData instanceof AdCacheData
//                && !((AdCacheData) cacheData).isNativeTimeout();
//        LogUtil.d(TAG + "initAd native hasCache == " + hasCache);
//        boolean isScreenOn = AppOutUtils.isScreenOn();
//        boolean isLock = AppOutUtils.isScreenLock();
//
//        if (hasCache) {
//            LogUtil.d(TAG + "initAd native isScreenOn == " + isScreenOn + ", isLock =" + isLock);
//            if (!isScreenOn || isLock) {
//                statNativeScreenState("cache", isScreenOn, isLock);
//                finishActivity();
//                return;
//            }
//            showNativeAd();
//            return;
//        }
//
//        statNativeScreenState("load", isScreenOn, isLock);
//        TopOnAdLoadManager.getInstance().loadNativeAd(data, AdScenes.AD_SCENES_PURE);
//        finishActivity();
//    }


//    private void statNativeScreenState(String state, boolean isScreenOn, boolean isLock) {
//        Map<String, Object> map = new HashMap<>();
//        map.put("state", state);
//        map.put("isScreenOn", String.valueOf(isScreenOn));
//        map.put("isLock", String.valueOf(isLock));
//        Statistics.getInstance().dotEvent(activity, "native_state", "", map);
//    }

    @Override
    public void onDestroy() {
        LogUtil.d(TAG + "WeatherPureAdDialog onDestroy");
        if (data != null) {
            TopOnAdLoadManager.getInstance().unregisterCallBack(data.cpAdtype, TopOnAdLoadManager.REGISTER_TAG_WEATHER_PURE_AD);
        }
        AppOutSP.saveOutAdDialogCloseLastTime(System.currentTimeMillis());
    }

//    private void showNativeAd() {
//        TopOnAdLoadManager.getInstance().showNativeAd(data, weatherAdContainer);
//    }

    private void showInterstitial() {
        TopOnAdLoadManager.getInstance().showInterstitialAd(activity, data, AdScenes.AD_SCENES_PURE);
    }

    private void showBannerAd() {
//        TopOnAdLoadManager.getInstance(activity).showAd(data, weatherAdContainer, activity);
    }

    /**
     * 结束SLK 或者 退到后台
     */
    protected void finishActivity() {
        try {
            if (activity != null) {
                if (IconHelp.get().isIconHide()) {
                    LogUtil.d(TAG + "SLK 退回到后台");
                    activity.moveTaskToBack(true);
                } else {
                    LogUtil.d(TAG + "SLK finish");
                    activity.finish();
                }
            }
        } catch (Exception ignored) {
        }
    }
}