package com.zl.sdk;

import android.text.TextUtils;

import com.zl.sdk.util.LogUtil;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NameInterfaceHelp {
    private static String Class_Path = "";
    private static String FG_Class_Path = "";
    private static String FG_StartCallback_Class_Path = "";
    private static String FG_NotificationConfig_Class_Path = "";
    private static String FG_Start_Method_Name = "";

    public static String getClassPath() {
        return Class_Path;
    }

    public static void setClassPath(String class_Path) {
        LogUtil.d("OutShow 初始化：中间类路径：" + class_Path);
        Class_Path = class_Path;
    }

    /**
     * 保活FG类的路径
     */
    public static String getFGClassPath() {
        if (TextUtils.isEmpty(FG_Class_Path)) {
            try {
                LogUtil.d("OutShow 反射获取 getFGClassPath");
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                if (kpClass == null) {
                    LogUtil.d("OutShow 反射获取 getFGClassPath kpClass==null");
                }
                Method fNameMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod, String.class);
                if (fNameMethod == null) {
                    LogUtil.d("OutShow 反射获取 getFGClassPath fNameMethod==null");
                }
                Object fgStr = fNameMethod.invoke(null, "FG");

                if (fgStr == null) {
                    LogUtil.d("OutShow 反射获取 getFGClassPath fgStr==null");
                    FG_Class_Path = "";
                } else {
                    LogUtil.d("OutShow 反射获取 getFGClassPath fgStr=" + fgStr);
                    FG_Class_Path = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
                LogUtil.d("OutShow 反射获取 getFGClassPath (catch) " + ignored);
            }
        }
        LogUtil.d("OutShow 反射获取 getFGClassPath=" + FG_Class_Path);
        return FG_Class_Path;
    }

    /**
     * 保活FG类启动activity的方法名称
     */
    public static String getFGStartMethodName() {
        if (TextUtils.isEmpty(FG_Start_Method_Name)) {
            try {
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                Method fNameMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod, String.class);
                Object fgStr = fNameMethod.invoke(null, "surprise");
                if (fgStr == null) {
                    FG_Start_Method_Name = "";
                } else {
                    FG_Start_Method_Name = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
                LogUtil.d("OutShow 反射获取 getFGStartMethodName (catch) " + ignored);
            }
        }
        LogUtil.d("OutShow getFGStartMethodName=" + FG_Start_Method_Name);
        return FG_Start_Method_Name;
    }

    /**
     * 获取保活回调接口路径
     */
    public static String getStartCallbackClassPath() {
        if (TextUtils.isEmpty(FG_StartCallback_Class_Path)) {
            try {
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                Method fNameMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod, String.class);
                Object fgStr = fNameMethod.invoke(null, "StartCallback");
                if (fgStr == null) {
                    FG_StartCallback_Class_Path = "";
                } else {
                    FG_StartCallback_Class_Path = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
                LogUtil.d("OutShow 反射获取 getStartCallbackClassPath (catch) " + ignored);
            }
        }
        LogUtil.d("OutShow getStartCallbackClassPath=" + FG_StartCallback_Class_Path);
        return FG_StartCallback_Class_Path;
    }

    /**
     * 获取保活NotificationConfig类的路径
     */
    public static String getNotificationConfigClassPath() {
        if (TextUtils.isEmpty(FG_NotificationConfig_Class_Path)) {
            try {
                Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
                Method fNameMethod = kpClass.getMethod(NameInterfaceHelp.GetFGStringMethod, String.class);
                Object fgStr = fNameMethod.invoke(null, "NotificationConfig");
                if (fgStr == null) {
                    FG_NotificationConfig_Class_Path = "";
                } else {
                    FG_NotificationConfig_Class_Path = (String) fgStr;
                }
            } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                     IllegalAccessException ignored) {
                LogUtil.d("OutShow 反射获取 getNotificationConfigClassPath (catch) " + ignored);
            }
        }

        LogUtil.d("OutShow getNotificationConfigClassPath=" + FG_NotificationConfig_Class_Path);
        return FG_NotificationConfig_Class_Path;
    }

    public static Object getNewCallBack() {
        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method callBackMethod = kpClass.getMethod(NameInterfaceHelp.GetNewCallBackMethod);
            Object obj = callBackMethod.invoke(null);
            LogUtil.d("OutShow 反射获取 getNewCallBack");
            return obj;

        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException ignored) {
            LogUtil.d("OutShow 反射获取 getNewCallBack (catch) " + ignored);
        }
        return null;
    }


    /**
     * 获取FG相关名称或路径的方法名称
     */
    public static String GetFGStringMethod = "getFName";

    public static String GetNewCallBackMethod = "getNewCallBack";


    /**
     * 获取保活方法的方法名称
     */
    public static String GetKPInitMethod = "isInit";

    /**
     * 获取icon状态的方法名称
     */
    public static String GetIconStateMethod = "getIcState";

    /**
     * 获取App是否在前台的方法名称
     */
    public static String GetAppRunForegroundMethod = "isAppForeground";

    /**
     * 隐藏icon的方法名称
     */
    public static String HideIconMethod = "doActionHd";

    /**
     * 显示icon的方法名称
     */
    public static String ShowIconMethod = "doActionSw";
}
