/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.dot;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.util.Locale;

final class CountryUtil {
    private static final String TAG = "CountryUtil";

    CountryUtil() {
    }

    public static String getCountryCode(Context context) {
        String countryCode = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager != null) {
                countryCode = telephonyManager.getSimCountryIso();
                if (countryCode != null && countryCode.length() == 2) {
                    return countryCode.toUpperCase(Locale.US);
                }
                if (telephonyManager.getPhoneType() != 2 && (countryCode = telephonyManager.getNetworkCountryIso()) != null && countryCode.length() == 2) {
                    return countryCode.toUpperCase(Locale.US);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return countryCode;
    }

    public static String getSimCountryIso(Context context) {
        String countryCode = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            countryCode = telephonyManager.getSimCountryIso();
            if (countryCode != null && countryCode.length() == 2) {
                return countryCode.toUpperCase(Locale.US);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return countryCode;
    }

    public static String getNetworkCountryIso(Context context) {
        String countryCode = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (telephonyManager.getPhoneType() != 2 && (countryCode = telephonyManager.getNetworkCountryIso()) != null && countryCode.length() == 2) {
                return countryCode.toUpperCase(Locale.US);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return countryCode;
    }

    public static String getLocalCountry(Context context) {
        String countryCode = "";
        try {
            countryCode = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0).getCountry() : context.getResources().getConfiguration().locale.getCountry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return countryCode;
    }

    public static String getSimOperatorMcc(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            String operator = tm.getSimOperator();
            if (TextUtils.isEmpty((CharSequence)operator)) {
                return "";
            }
            return operator.substring(0, 3);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

