package com.zl.sdk.out;

import com.zl.sdk.OutHelp;
import com.zl.sdk.util.SPUtils;

public final class AppOutSP {

    private static final String TAG = "AppOutSP";
    private static final String APP_OUT_PREF_FILE_NAME = "pref_app_out_file";
    private static final String KEY_OUT_INTERSTITIAL_AD_DAY_SHOW_COUNT = "out_interstitial_ad_day_show_count";
    private static final String KEY_OUT_LAST_SHOW_TIME = "out_last_show_time";
    private static final String KEY_OUT_AD_DIALOG_CLOSE_LAST_TIME = "out_ad_dialog_close_last_time";

    private static final String KEY_IS_APP_FIRST_START = "is_app_first_start_in_devices";

    private static final String KEY_LAST_SCREEN_OFF = "key_last_screen_off";


    private static long OutLastScreenOff = -1L;

    public static void saveLastScreenOffTime(long value) {
        getAppOutPref().put(KEY_LAST_SCREEN_OFF, value);
        OutLastScreenOff = value;
    }

    public static long getLastScreenOffTime() {
        if (OutLastScreenOff == -1) {
            OutLastScreenOff = getAppOutPref().getLong(KEY_LAST_SCREEN_OFF, 0);
        }
        return OutLastScreenOff;
    }

    private static int OutInterstitialAdDayShowCount = -1;

    public static void saveOutInterstitialAdDayShowCount(int value) {
        getAppOutPref().put(KEY_OUT_INTERSTITIAL_AD_DAY_SHOW_COUNT, value);
        OutInterstitialAdDayShowCount = value;
    }

    public static int getOutInterstitialAdDayShowCount() {
        if (OutInterstitialAdDayShowCount == -1) {
            OutInterstitialAdDayShowCount = getAppOutPref().getInt(KEY_OUT_INTERSTITIAL_AD_DAY_SHOW_COUNT, 0);
        }
        return OutInterstitialAdDayShowCount;
    }


    private static long OutLastShowTime = -1L;

    public static void saveOutLastShowTime(long value) {
        getAppOutPref().put(KEY_OUT_LAST_SHOW_TIME, value);
        OutLastShowTime = value;
    }

    public static long getOutLastShowTime() {
        if (OutLastShowTime == -1) {
            OutLastShowTime = getAppOutPref().getLong(KEY_OUT_LAST_SHOW_TIME, 0);
        }
        return OutLastShowTime;
    }


    private static long OutAdDialogCloseLastTime = -1L;

    public static void saveOutAdDialogCloseLastTime(long value) {
        getAppOutPref().put(KEY_OUT_AD_DIALOG_CLOSE_LAST_TIME, value);
        OutAdDialogCloseLastTime = value;
    }

    public static long getOutAdDialogCloseLastTime() {
        if (OutAdDialogCloseLastTime == -1) {
            OutAdDialogCloseLastTime = getAppOutPref().getLong(KEY_OUT_AD_DIALOG_CLOSE_LAST_TIME, 0);
        }
        return OutAdDialogCloseLastTime;
    }

    private static SPUtils outPref = null;

    private static SPUtils getAppOutPref() {
        if (outPref == null) {
            if (OutHelp.get().getContext() != null) {
                outPref = SPUtils.getInstance(OutHelp.get().getContext(), APP_OUT_PREF_FILE_NAME);
            }
        }
        return outPref;
    }

    public static boolean isAppFirstStart() {
        return getAppOutPref().getBoolean(KEY_IS_APP_FIRST_START, true);
    }

    public static void setIsAppFirstStart(boolean firstStart) {
        getAppOutPref().put(KEY_IS_APP_FIRST_START, firstStart);
    }

}
