package com.zl.sdk.bean;

import android.text.TextUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WeatherAdData extends BaseWeatherBean {
    public static final String CP_AD_TOPON = "topon";
    public static final String CP_AD_PANGLE = "Pangle";
    public static final String CP_ADMOD_PARTNER_ADMOD = "admob";
    public static final String CP_ADMOD_PARTNER_FACEBOOK = "facebook";

    public final static String CP_AD_TYPE_BANNER = "1";//BannerAd
    public final static String CP_AD_TYPE_NATIVE = "2";//NativeAd
    public final static String CP_AD_TYPE_CHAPING = "3";//ChaPing

    //1=应用每天总展示次数类型
    public static final int CONFIG_TYPE_APP_SHOW_TIMES = 1;
    //2=平台每天展示次数类型，会存在多个平台
    public static final int CONFIG_TYPE_PLATFORM_SHOW_TIMES = 2;
    //3=免费广告时长类型/小时
    public static final int CONFIG_TYPE_AD_FREE_DURATION = 3;
    //4=免费广告次数类型
    public static final int CONFIG_TYPE_AD_FREE_COUNT = 4;

    public static final String JUMP_TYPE_DEEPLINK = "DeepLink";
    public static final String JUMP_TYPE_WEB = "H5";

    //开平广告
    public final static int POSITION0 = 0;
    //首页顶部广告
    public final static int POSITION1 = 1;
    //主界面激励广告
    public final static int POSITION2 = 2;
    //主界面底部悬浮广告
    public final static int POSITION3 = 3;
    //应用退出广告
    public final static int POSITION4 = 4;
    //全屏插屏广告
    public final static int POSITION5 = 5;
    //卡片广告
    public final static int POSITION6 = 6;
    //熱啓動開屏廣告
//    public final static int POSITION7 = 7;
    //air_quality_detail
    public final static int POSITION8 = 8;
    //hour weather details page
    public final static int POSITION9 = 9;
    //锁屏
    public final static int POSITION_LOCK = 10001;
    //桌面
    public final static int POSITION_HOME = 10002;
    //在屏幕的展示位置类型
    public final static int SHOW_TOP = 1;
    public final static int SHOW_MID = 2;
    public final static int SHOW_BOTTOM = 3;

    //自营类
    public final static int AD_SELF_FLAG = 1;
    public final static int AD_OTHER_FLAG = 0;

    private Data data;

    public boolean isDataOK() {
        return "0".equals(getErrorCode());
    }

    public Data getData() {
        return data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public static class Data implements Serializable {
        public List<NormalAdData> normal = new ArrayList<>(8);
        public ConfigData config = new ConfigData();
    }

    public static class NormalAdData implements Serializable {
        public int id;
        public String title;
        public String ad_Scenes;

        @Override
        public String toString() {
            return "NormalAdData{" +
                    "id=" + id +
                    ", title='" + title + '\'' +
                    ", position=" + position +
                    ", adStyle=" + adStyle +
                    ", jumpType='" + jumpType + '\'' +
                    ", jumpData='" + jumpData + '\'' +
                    ", interval=" + interval +
                    ", intervalHide=" + intervalHide +
                    ", showCount=" + showCount +
                    ", showTimes=" + showTimes +
                    ", showTimeHide=" + showTimeHide +
                    ", showTimesHideForAdId=" + showTimesHideForAdId +
                    ", freeAdCount=" + freeAdCount +
                    ", cardPosition=" + cardPosition +
                    ", selfFlag=" + selfFlag +
                    ", imageList=" + Arrays.toString(imageList) +
                    ", moment=" + moment +
                    ", modeAd=" + modeAd +
                    ", modeContent=" + modeContent +
                    ", showTop=" + showTop +
                    ", showMid=" + showMid +
                    ", showBottom=" + showBottom +
                    ", cpName='" + cpName + '\'' +
                    ", cpAppid='" + cpAppid + '\'' +
                    ", cpAdslot='" + cpAdslot + '\'' +
                    ", cpAdtype='" + cpAdtype + '\'' +
                    ", cpList=" + cpList +
                    '}';
        }

        //0=开平广告; 1=首页顶部广告; 2=主界面激励广告; 3=主界面底部悬浮广告; 4=应用退出广告; 5=全屏插屏广告; 6=卡片广告
        public int position;
        //1=自动小; 2=自动大; 3=手动小; 4=手动中; 5=手动大
        public int adStyle = 1;
        public String jumpType;//DeepLink/H5
        public String jumpData;

        public int interval;//刷新间隔时间/s
        public int intervalHide;//刷新间隔时间/s  隐藏icon
        public int showCount;//展示次数（总）
        public int showTimes;//针对cpAdtype类型的展示次数
        public int showTimeHide;//针对隐藏icon的外展展示次数 总次数
        public int showTimesHideForAdId;//针对隐藏icon的外展展示次数 广告类型次数
        public int freeAdCount;//免费展示次数
        public int cardPosition;//卡片广告位置
        public int selfFlag;//1=自营; 0=非自营
        public String[] imageList;//

        public int moment;//展示停留时长/s

        public int modeAd;//纯广告次数
        public int modeContent;//内通+广告次数

        //展示位置权重
        public int showTop;
        public int showMid;
        public int showBottom;

        public  String cpName;
        public  String cpAppid;
        public  String cpAdslot;
        public  String cpAdtype;

        public String card_native_ex;
        public String add_city_interstitial_ex;
        public List<CpAdData> cpList = new ArrayList<>(2);


        public boolean isWZAdType() {
            return position == POSITION_HOME || position == POSITION_LOCK;
        }

        public boolean isCardAdTypeByPositionSix() {
            return position == POSITION6;
        }

        public boolean isOpenAdType() {
            return position == POSITION0;
        }

        public boolean isSelfFlag() {
            return selfFlag == AD_SELF_FLAG;
        }

        public boolean isDeepLink() {
            return JUMP_TYPE_DEEPLINK.equals(jumpType);
        }

        public boolean isWeb() {
            return JUMP_TYPE_WEB.equals(jumpType);
        }

        public boolean isSameAdData(NormalAdData data) {
            if (null != data) {
                return isSameAdSlot(data) && isSameScenes(data);
            }
            return false;
        }

        private boolean isSameAdSlot(NormalAdData data) {
            return !TextUtils.isEmpty(data.cpAdslot) && data.cpAdslot.equals(cpAdslot);
        }

        private boolean isSameScenes(NormalAdData data) {
            return (data.ad_Scenes == null && ad_Scenes == null)
                    || (!TextUtils.isEmpty(data.ad_Scenes) && !TextUtils.isEmpty(ad_Scenes) && data.ad_Scenes.equals(ad_Scenes));
        }

        public NormalAdData cloneAdData() {
            NormalAdData newAdData = new NormalAdData();
            newAdData.id = this.id;
            newAdData.title = this.title;
            newAdData.ad_Scenes = this.ad_Scenes;
            newAdData.position = this.position;
            newAdData.adStyle = this.adStyle;
            newAdData.jumpType = this.jumpType;
            newAdData.jumpData = this.jumpData;
            newAdData.interval = this.interval;
            newAdData.intervalHide = this.intervalHide;
            newAdData.showCount = this.showCount;
            newAdData.showTimes = this.showTimes;
            newAdData.showTimeHide = this.showTimeHide;
            newAdData.showTimesHideForAdId = this.showTimesHideForAdId;
            newAdData.freeAdCount = this.freeAdCount;
            newAdData.cardPosition = this.cardPosition;
            newAdData.selfFlag = this.selfFlag;
            newAdData.imageList = this.imageList;
            newAdData.moment = this.moment;
            newAdData.modeAd = this.modeAd;
            newAdData.modeContent = this.modeContent;
            newAdData.showTop = this.showTop;
            newAdData.showMid = this.showMid;
            newAdData.showBottom = this.showBottom;
            newAdData.cpName = this.cpName;
            newAdData.cpAppid = this.cpAppid;
            newAdData.cpAdslot = this.cpAdslot;
            newAdData.cpAdtype = this.cpAdtype;
            newAdData.card_native_ex = this.card_native_ex;
            newAdData.add_city_interstitial_ex = this.add_city_interstitial_ex;
            return newAdData;
        }

    }

    public static class ConfigData implements Serializable {
        public List<ConfigAdData> timesConfig = new ArrayList<>();
    }

    public static class ConfigAdData implements Serializable {
        //1=应用每天总展示次数类型 2=平台每天展示次数类型，会存在多个平台，会存在多个 3=免费广告时长类型/小时 4=免费广告次数类型
        public int type;
        public String name;
        public String value;

        public boolean isAppShowTimesType() {
            return type == CONFIG_TYPE_APP_SHOW_TIMES;
        }

        public boolean isPlatformShowTimesType() {
            return type == CONFIG_TYPE_PLATFORM_SHOW_TIMES;
        }

        public boolean isFreeDurationType() {
            return type == CONFIG_TYPE_AD_FREE_DURATION;
        }

        public boolean isFreeAdCountType() {
            return type == CONFIG_TYPE_AD_FREE_COUNT;
        }
    }

    public static class CpAdData implements Serializable {
        public String name;
        public String appid;
        public String adslot;
        public String adType;
        public int priority;
        public String ad_Scenes;
        //当前adType的展示次数
        public int showTimes;
        public int showTimesHide;
        //1=自动小; 2=自动大; 3=手动小; 4=手动中; 5=手动大
        public int adStyle = 1;

        @Override
        public String toString() {
            return "CpAdData{" +
                    "name='" + name + '\'' +
                    ", appid='" + appid + '\'' +
                    ", adslot='" + adslot + '\'' +
                    ", adType='" + adType + '\'' +
                    ", priority=" + priority +
                    ", ad_Scenes='" + ad_Scenes + '\'' +
                    ", showTimes=" + showTimes +
                    ", showTimeHide=" + showTimesHide +
                    ", adStyle=" + adStyle +
                    '}';
        }
    }
}
