package com.zl.sdk.bean;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.NonNull;

import com.zl.sdk.Config;

import java.io.Serializable;
import java.util.Objects;

public class RemindersInfo implements Parcelable, Serializable {
    public int reminderType;
    public String id = "";
    public long createTime;
    public boolean isAdType = false;
    public int adScene = Config.AD_SCENE_TYPE_HOME;

    public RemindersInfo() {
        createTime = System.currentTimeMillis();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RemindersInfo that = (RemindersInfo) o;
        return reminderType == that.reminderType && Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reminderType, id);
    }

    protected RemindersInfo(Parcel in) {
        reminderType = in.readInt();
        id = in.readString();
        createTime = in.readLong();
        isAdType = in.readByte() != 0;
        adScene = in.readInt();
    }

    public static final Creator<RemindersInfo> CREATOR = new Creator<RemindersInfo>() {
        @Override
        public RemindersInfo createFromParcel(Parcel in) {
            return new RemindersInfo(in);
        }

        @Override
        public RemindersInfo[] newArray(int size) {
            return new RemindersInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(reminderType);
        dest.writeString(id);
        dest.writeLong(createTime);
        dest.writeByte((byte) (isAdType ? 1 : 0));
        dest.writeInt(adScene);
    }

    @Override
    public String toString() {
        return "RemindersInfo{" +
                "reminderType=" + reminderType +
                ", id='" + id + '\'' +
                ", createTime='" + createTime + '\'' +
                ", isAdType='" + isAdType + '\'' +
                ", adScene='" + adScene + '\'' +
                '}';
    }
}
