package com.zl.sdk.ad;

import android.app.Activity;
import android.text.TextUtils;

import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.ATAdStatusInfo;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.interstitial.api.ATInterstitialListener;
import com.zl.sdk.OutHelp;
import com.zl.sdk.event.AdsParamsInfo;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.ReportBean;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.out.AppOutSP;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AdManagerV2 implements ATInterstitialListener {
    private volatile ATInterstitial atInterstitial = null;

    private OnInAdListener mListener = null;

    private int reloadCount = 3;

    private String adId = "";

    private long requestTime = 0L;

    private static final AdManagerV2 mgr = new AdManagerV2();

    private AdManagerV2() {

    }

    public static AdManagerV2 get() {
        return mgr;
    }

    @Override
    public void onInterstitialAdLoaded() {
        LogUtil.d("OutShow", "Topon: ad loaded");
        reloadCount = 3;

        if (atInterstitial.checkValidAdCaches() == null || atInterstitial.checkValidAdCaches().isEmpty()) {
            EventUtils.statAdLoaded(getReportBean(null, null), requestTime);
        } else {
            EventUtils.statAdLoaded(getReportBean(atInterstitial.checkValidAdCaches().get(0), null), requestTime);
        }
        //记录广告返回的时间，供上报缓存时间和价格
        requestTime = System.currentTimeMillis();
    }

    @Override
    public void onInterstitialAdLoadFail(AdError adError) {
        LogUtil.d("OutShow", "Topon: ad load fail :" +adError.getFullErrorInfo());
        String builder = "error info : code=" + adError.getCode() +
                " msg=" + adError.getDesc() +
                " all=" + adError.getFullErrorInfo();
        EventUtils.statAdLoadFail(getReportBean(null, builder), requestTime);

        reloadCount--;
        if (reloadCount > 0) {
            atInterstitial = new ATInterstitial(OutHelp.get().getContext(), adId);
            atInterstitial.setAdListener(this);
            atInterstitial.load();
            requestTime = System.currentTimeMillis();
            EventUtils.statAdReport(getReportRequestBean(adId));
        } else {
            reloadCount = 3;
        }
    }

    @Override
    public void onInterstitialAdClicked(ATAdInfo atAdInfo) {
        LogUtil.d("OutShow", "Topon: ad click");
        EventUtils.statAdClick(getReportBean(atAdInfo, null));
    }

    @Override
    public void onInterstitialAdShow(ATAdInfo atAdInfo) {
        LogUtil.d("OutShow", "Topon: ad show");

        int outInterstitialAdDayShowCount = AppOutSP.getOutInterstitialAdDayShowCount() + 1;
        AppOutSP.saveOutInterstitialAdDayShowCount(outInterstitialAdDayShowCount);

        LogUtil.d("OutShow", "Topon: ad show times=" + outInterstitialAdDayShowCount);

        EventUtils.statAdExpose(getReportBean(atAdInfo, null));

        atInterstitial = new ATInterstitial(OutHelp.get().getContext(), adId);
        atInterstitial.setAdListener(this);
        atInterstitial.load();
        requestTime = System.currentTimeMillis();
        EventUtils.statAdReport(getReportRequestBean(adId));

        LogUtil.d("OutShow", "Topon: ad show mListener=" + mListener);
        if (mListener != null) {
            mListener.onShow();
        }
    }

    @Override
    public void onInterstitialAdClose(ATAdInfo atAdInfo) {
        LogUtil.d("OutShow", "Topon: ad close");
        EventUtils.statAdClose(getReportBean(atAdInfo, null));
        if (mListener != null) {
            mListener.onCloseAd();
            removeListener();
        }

        OutHelp.get().setShowLock(false);
    }

    @Override
    public void onInterstitialAdVideoStart(ATAdInfo atAdInfo) {
        LogUtil.d("OutShow", "Topon: ad video start");
    }

    @Override
    public void onInterstitialAdVideoEnd(ATAdInfo atAdInfo) {
        LogUtil.d("OutShow", "Topon: ad video end");
    }

    @Override
    public void onInterstitialAdVideoError(AdError adError) {
        LogUtil.d("OutShow", "Topon: ad video error");
        String builder = "error info : code=" + adError.getCode() +
                " msg=" + adError.getDesc() +
                " all=" + adError.getFullErrorInfo();
        EventUtils.statDisplayFail(getReportBean(null, builder));

        if (mListener != null) {
            mListener.showFail();
            removeListener();
        }

        OutHelp.get().setShowLock(false);
    }

    public boolean loadAd(String id) {
        LogUtil.d("OutShow", "Topon: loadAd : " + id);
        adId = id;
        if (atInterstitial != null) {
            ATAdStatusInfo atAdStatusInfo = atInterstitial.checkAdStatus();
            LogUtil.d("OutShow", "atAdStatusInfo :" + atAdStatusInfo );
            if (atAdStatusInfo.isReady()) {
                LogUtil.d("OutShow", "ad isReady!");
                return false;
            }
            if (!atAdStatusInfo.isLoading()) {
                LogUtil.d("OutShow", "load ad !");
                atInterstitial.load();
                requestTime = System.currentTimeMillis();
                EventUtils.statAdReport(getReportRequestBean(adId));
            } else {
                LogUtil.d("OutShow", "ad is loading !");
            }
        } else {
            LogUtil.d("OutShow", "new ad and load !");
            atInterstitial = new ATInterstitial(OutHelp.get().getContext(), adId);
            atInterstitial.setAdListener(this);
            atInterstitial.load();
            requestTime = System.currentTimeMillis();
            EventUtils.statAdReport(getReportRequestBean(adId));
        }
        return true;
    }

    public void showAd(Activity activity, OnInAdListener listener) {
        LogUtil.d("OutShow", "Topon: showAd");

        mListener = listener;

        ATInterstitial.entryAdScenario("111", "");
        atInterstitial.show(activity);
        statCallShow(activity);
    }

    public void removeListener() {
        mListener = null;
    }

    private void statCallShow(Activity activity) {
        try {
            Map<String, Object> para = new HashMap<>();
            para.put("screen_state", String.valueOf(AppOutUtils.isScreenOn()));
            para.put("foreground", OutHelp.get().isAppForeground());
            String adPage = OutHelp.get().getPage();
            if (!TextUtils.isEmpty(adPage)) {
                para.put("page", adPage);
            }
            Statistics.getInstance().dotEvent(activity, "ad_call_show", "", para);
        } catch (Exception e) {
        }
    }


    private ReportBean getReportBean(ATAdInfo adInfo, String errorMsg) {
        ReportBean bean = new ReportBean();
        bean.adtype = AdsParamsInfo.INTERSTITIAL;
        bean.adUnitId = adId;
        if (null != adInfo) {
            bean.platform = adInfo.getNetworkPlacementId();
            bean.source = adInfo.getAdNetworkType();
        }
        bean.ad_msg_error = errorMsg;
        bean.time = (new Date()).getTime();
        return bean;
    }

    private ReportBean getReportRequestBean(String adId) {
        ReportBean bean = new ReportBean();
        bean.eventid = AdsParamsInfo.F_REQUEST;
        bean.adtype = AdsParamsInfo.INTERSTITIAL;
        bean.adUnitId = adId;
        return bean;
    }
}
