package com.zl.sdk.ad.natives;

import android.text.TextUtils;

import com.zl.sdk.ad.AdBean;

import java.util.HashMap;

public class TopOnNativeAdManager {
    private final HashMap<String, TopOnNativeAdLoad> dataMap;

    public TopOnNativeAdManager() {
        dataMap = new HashMap<>();
    }

    public void showNative(AdBean adBean, TopOnAdNativeCallBack adNativeCallBack) {
        String key = adBean.getAdUnitId();
        TopOnNativeAdLoad nativeAdLoad = dataMap.get(key);
        if (null == nativeAdLoad) {
            nativeAdLoad = new TopOnNativeAdLoad();
            dataMap.put(key, nativeAdLoad);
        }
        nativeAdLoad.setAdBean(adBean).showNative(adNativeCallBack);
    }

    public void setAdNativeCallBack(AdBean adBean, TopOnAdNativeCallBack adNativeCallBack) {
        if (adBean == null) {
            return;
        }
        String keyId = adBean.getAdUnitId();
        TopOnNativeAdLoad nativeAdLoad = dataMap.get(keyId);
        if (null != nativeAdLoad) {
            nativeAdLoad.setAdBean(adBean).setAdNativeCallBack(adNativeCallBack);
        }

    }

    public void destroy(String adUnitId) {
        if (TextUtils.isEmpty(adUnitId)) {
            return;
        }
        TopOnNativeAdLoad nativeAdLoad = dataMap.get(adUnitId);
        if (null != nativeAdLoad) {
            nativeAdLoad.onDestroy();
        }
    }

    public void destroy() {
        for (String key : dataMap.keySet()) {
            TopOnNativeAdLoad nativeAdLoad = dataMap.get(key);
            if (null != nativeAdLoad) {
                nativeAdLoad.onDestroy();
            }
        }
        dataMap.clear();
    }
}
