package com.zl.sdk.util;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.PowerManager;
import android.telephony.TelephonyManager;

import com.zl.sdk.OutHelp;

import java.util.ArrayList;
import java.util.List;

public final class AppOutUtils {

    private static final String TAG = "AppOutUtils";

    public static boolean isScreenLock() {
        try {
            KeyguardManager km =
                    (KeyguardManager) OutHelp.get().getContext().getSystemService(Context.KEYGUARD_SERVICE);
            if (km == null) return false;
            return km.inKeyguardRestrictedInputMode();
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean isKeyguardSecure() {
        try {
            KeyguardManager keyguardManager = (KeyguardManager) OutHelp.get().getContext().getSystemService(Context.KEYGUARD_SERVICE);
            return keyguardManager.isKeyguardSecure();
        } catch (Exception e) {
        }
        return false;
    }

    public static void unlockSystem() {
        try {
            KeyguardManager keyguardManager = (KeyguardManager) OutHelp.get().getContext()
                    .getSystemService(Context.KEYGUARD_SERVICE);
            KeyguardManager.KeyguardLock keyguardLock = keyguardManager.newKeyguardLock(Context.KEYGUARD_SERVICE);
            keyguardLock.disableKeyguard();
        } catch (Exception e) {
        }
    }

    public static boolean isScreenOn() {
        try {
            PowerManager powerManager = (PowerManager) OutHelp.get().getContext().getSystemService(Context.POWER_SERVICE);
            boolean isScreenOn = powerManager.isInteractive();
            LogUtil.d(TAG + "isScreenOn=" + isScreenOn);
            return isScreenOn;
        } catch (Exception e) {
        }
        return true;
    }

    private static List<String> getHomes(Context context) {
        List<String> names = new ArrayList<String>();
        try {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent(Intent.ACTION_MAIN);
            intent.addCategory(Intent.CATEGORY_HOME);
            List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivities(intent,
                    PackageManager.MATCH_DEFAULT_ONLY);
//            for (ResolveInfo resolveInfo : resolveInfoList) {
//                LogUtil.d(TAG, "getHomes pkg =" + resolveInfo.activityInfo.packageName);
//                names.add(resolveInfo.activityInfo.packageName);
//            }
        } catch (Exception e) {
            LogUtil.e(TAG, "getHomes e =" + e);
        }
        return names;
    }

    public static boolean isHome(Context context) {
        try {
            ActivityManager mActivityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
            List<ActivityManager.RunningTaskInfo> taskInfoList = mActivityManager.getRunningTasks(1);
            if (taskInfoList == null || taskInfoList.isEmpty()) {
                LogUtil.d(TAG, "isHome taskInfoList empty");
                return false;
            }
//            for (ActivityManager.RunningTaskInfo info :
//                    taskInfoList) {
//                LogUtil.d(TAG, "isHome pkg =" + info.topActivity.getPackageName());
//            }
            return getHomes(context).contains(taskInfoList.get(0).topActivity.getPackageName());
        } catch (Exception e) {
            LogUtil.e(TAG, "isHome e =" + e);
        }
        return false;
    }

    public static boolean isPhoneInUse(Context context) {
        try {
            TelephonyManager mTelephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            int state = mTelephonyManager.getCallState();
            return state != TelephonyManager.CALL_STATE_IDLE;
        } catch (Exception e) {
        }
        return false;
    }
}
