package com.zl.sdk.util;


import com.zl.sdk.util.log.AbsLog;

import java.util.Vector;

public class LogUtil {
    private static Vector<AbsLog> sObserver = new Vector<>();

    public synchronized static void addObserver(AbsLog abLog) {
        if (sObserver.contains(abLog)) {
            return;
        }
        sObserver.add(abLog);
    }


    public static void w(String tag, String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.w(tag, msg);
        }
    }

    public static void i(String tag, String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.i(tag, msg);
        }
    }

    public static void v(String tag, String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.v(tag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.d(tag, msg);
        }
    }

    public static void d(String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.d("", msg);
        }
    }

    public static void e(String tag, String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.e(tag, msg);
        }
    }

    public static void e(String tag, String msg, Throwable e) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.e(tag, msg, e);
        }
    }

    public static void e(String tag, Throwable e) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.e(tag, e);
        }
    }

    public static void dForce(String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.dForce(msg);
        }
    }

    public static void dForce(String tag, String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.dForce(tag, msg);
        }
    }

    public static void wForce(String tag, String msg) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.wForce(tag, msg);
        }
    }

    public static void wForce(String tag, Throwable e) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.wForce(tag, e);
        }
    }

    public static void wForce(String tag, String msg, Throwable e) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.wForce(tag, msg, e);
        }
    }

    public static void eForce(String tag, String msg, Throwable e) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            abLog.eForce(tag, msg, e);
        }
    }

    public static void eForce(String tag, Throwable e) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            abLog.eForce(tag, "", e);
        }
    }

    /**
     * 啥也不做，为了sonar检查通过
     */
    public static void ignore(Exception e) {

    }

    /**
     * 啥也不做，为了sonar检查通过
     */
    public static void ignore(String message) {

    }

    public static void wForce(String msg) {
        wForce("", msg);
    }

    public static void wForce(Throwable e) {
        wForce("", e);
    }

    public static void eForce(Throwable e) {
        eForce("", e);
    }

    /**
     * 是否测试环境
     *
     * @return
     */
    public static boolean isDebug() {
        return AbsLog.isAllowProcessLog();
    }


    /**
     * debug模式下的调试代码，用于跟踪问题，问题确认完请及时删除调用代码或者注释，后期会定时删除调用的地方，生产环境不打印
     *
     * @param debugLog
     */
    public static void debugLog(Object debugLog) {
        if (sObserver.isEmpty()) {
            return;
        }
        for (AbsLog abLog : sObserver) {
            if (!abLog.isAllowProcessLog()) {
                return;
            }
            abLog.debugLog(debugLog);
        }
    }
}
