package com.zl.sdk.ad.natives;

import android.content.Context;

import com.anythink.core.api.ATAdConst;
import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.AdError;
import com.anythink.nativead.api.ATNative;
import com.anythink.nativead.api.ATNativeAdView;
import com.anythink.nativead.api.ATNativeDislikeListener;
import com.anythink.nativead.api.ATNativeEventListener;
import com.anythink.nativead.api.ATNativeNetworkListener;
import com.anythink.nativead.api.ATNativePrepareInfo;
import com.anythink.nativead.api.NativeAd;
import com.blankj.utilcode.util.ScreenUtils;
import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.AdBean;
import com.zl.sdk.event.AdsParamsInfo;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.ReportBean;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TopOnNativeAdLoad {

    private static final String TAG = "MaxNativeAdLoad";
    private Context context;
    private AdBean adBean;
    private ATNative atNative;
    private long requestTime;
    private String netWorkName;
    private TopOnAdNativeCallBack adNativeCallBack;


    public TopOnNativeAdLoad() {
        context = OutHelp.get().getContext();
    }

    public TopOnNativeAdLoad setAdBean(AdBean adBean) {
        this.adBean = adBean;
        return this;
    }

    public void showNative(TopOnAdNativeCallBack callBack) {
        adNativeCallBack = callBack;
        atNative = new ATNative(context, adBean.getAdUnitId(), new ATNativeNetworkListener() {
            @Override
            public void onNativeAdLoaded() {
                ATAdInfo adInfo;
                if (atNative.checkValidAdCaches() == null || atNative.checkValidAdCaches().isEmpty()) {
                    adInfo = null;
                } else {
                    adInfo = atNative.checkValidAdCaches().get(0);
                }

                EventUtils.statAdLoaded(getReportBean(adInfo, null), requestTime);
                requestTime = System.currentTimeMillis();


                ATNativePrepareInfo nativePrepareInfo = new ATNativePrepareInfo();

                NativeAd nativeAd = atNative.getNativeAd();
                if (!nativeAd.isNativeExpress()) {
                    adNativeCallBack.onNativeAdLoadFailed(adBean.getAdUnitId(), "not support selfRenderView");
                    EventUtils.statAdLoadFail(getReportBean(null, "not support selfRenderView"), requestTime);
                    return;
                }

                nativeAd.setNativeEventListener(new ATNativeEventListener() {
                    @Override
                    public void onAdImpressed(ATNativeAdView atNativeAdView, ATAdInfo atAdInfo) {
                        adNativeCallBack.onAdRevenuePaid(adBean.getAdUnitId());
                        adNativeCallBack.onAdImpression(adBean.getAdUnitId(), adBean.getAdData());

                        ReportBean reportBean = getReportBean(atAdInfo, null);
                        reportBean.valueMicros = atAdInfo.getEcpmLevel();
                        reportBean.currencyCode = "USD";
                        reportBean.precision = String.valueOf(atAdInfo.getEcpm());
                        EventUtils.statAdPaidEven(reportBean, requestTime);

                        EventUtils.statAdExpose(getReportBean(atAdInfo, null));
                    }

                    @Override
                    public void onAdClicked(ATNativeAdView atNativeAdView, ATAdInfo atAdInfo) {
                        adNativeCallBack.onNativeAdClicked(adBean.getAdUnitId());
                        EventUtils.statAdClick(getReportBean(adInfo, null));
                    }

                    @Override
                    public void onAdVideoStart(ATNativeAdView atNativeAdView) {

                    }

                    @Override
                    public void onAdVideoEnd(ATNativeAdView atNativeAdView) {

                    }

                    @Override
                    public void onAdVideoProgress(ATNativeAdView atNativeAdView, int i) {

                    }
                });

                ATNativeAdView nativeAdView = new ATNativeAdView(context);

//                View mSelfRenderView = View.inflate(AppGlobal.getContext(), adBean.nativeLayoutId, null);
//                if (!nativeAd.isNativeExpress()) {
//                    //自渲染
//                    bindSelfRenderView(AppGlobal.getContext(), nativeAd.getAdMaterial(), mSelfRenderView, nativePrepareInfo);
//                    nativeAd.renderAdContainer(nativeAdView, mSelfRenderView);
//                } else {
//                }

                nativeAd.setDislikeCallbackListener(new ATNativeDislikeListener() {
                    @Override
                    public void onAdCloseButtonClick(ATNativeAdView view, ATAdInfo entity) {
                        adNativeCallBack.onCloseAd();
                    }
                });
                //模板渲染
                nativeAd.renderAdContainer(nativeAdView, null);
                nativeAd.prepare(nativeAdView, nativePrepareInfo);

                adNativeCallBack.onNativeAdLoaded(adBean.getAdUnitId(), adBean.getAdScenes(), adBean.getAdData(), nativeAdView);
            }

            @Override
            public void onNativeAdLoadFail(AdError adError) {
                StringBuilder builder = new StringBuilder();
                builder.append("error info : code=").append(adError.getCode())
                        .append(" msg=").append(adError.getDesc())
                        .append(" all=").append(adError.getFullErrorInfo());

                adNativeCallBack.onNativeAdLoadFailed(adBean.getAdUnitId(), builder.toString());
                EventUtils.statAdLoadFail(getReportBean(null, builder.toString()), requestTime);
            }
        });

        Map<String, Object> localMap = new HashMap<>();
        localMap.put(ATAdConst.KEY.AD_WIDTH, ScreenUtils.getScreenWidth() - dip2px(context, 20));//单位：px，期望展示广告的宽度
        localMap.put(ATAdConst.KEY.AD_HEIGHT, dip2px(context, 300));//单位：px，期望展示广告的高度
        atNative.setLocalExtra(localMap);
        atNative.makeAdRequest();

        requestTime = System.currentTimeMillis();
        EventUtils.statAdRequest(getReportRequestBean());
    }

    protected void onDestroy() {
        if (atNative != null) {
            atNative.getNativeAd().destory();
        }
    }

    public void setAdNativeCallBack(TopOnAdNativeCallBack callBack) {
        this.adNativeCallBack = callBack;
    }

    private ReportBean getReportRequestBean() {
        ReportBean bean = new ReportBean();
        bean.adtype = AdsParamsInfo.NATIVE;
        if (null != adBean) {
            bean.ad_scenes = adBean.getAdScenes();
            bean.ad_position = adBean.getAdPosition();
            bean.adUnitId = adBean.getAdUnitId();
        }
        return bean;
    }

    public ReportBean getReportBean(ATAdInfo info, String errorMsg) {
        ReportBean bean = new ReportBean();
        bean.adtype = AdsParamsInfo.NATIVE;
        if (null != adBean) {
            bean.ad_position = adBean.getAdPosition();
            bean.adUnitId = adBean.getAdUnitId();
            bean.ad_scenes = adBean.getAdScenes();
        }
        try {
            if (null != info) {
                bean.source = info.getAdNetworkType();
            } else if (null != netWorkName) {
                bean.source = netWorkName;
                netWorkName = null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        bean.ad_msg_error = errorMsg;
        bean.time = (new Date()).getTime();
        return bean;
    }


//    public static void bindSelfRenderView(Context context, ATNativeMaterial adMaterial, View selfRenderView, ATNativePrepareInfo nativePrepareInfo) {
//        int padding = dip2px(context, 5);
//        selfRenderView.setPadding(padding, padding, padding, padding);
//
//        TextView titleView = selfRenderView.findViewById(R.id.ad_tle);
//        TextView descView = selfRenderView.findViewById(R.id.ad_dsc);
//        TextView ctaView = selfRenderView.findViewById(R.id.ad_clk);
//        TextView adFromView = selfRenderView.findViewById(R.id.advertiser_text_view);
////        FrameLayout iconArea = (FrameLayout) selfRenderView.findViewById(R.id.ad_im);
//        FrameLayout contentArea = (FrameLayout) selfRenderView.findViewById(R.id.options_view);
//        final ATNativeImageView logoView = (ATNativeImageView) selfRenderView.findViewById(R.id.ad_im);
////        View closeView = selfRenderView.findViewById(R.id.native_ad_close);
////        FrameLayout shakeViewContainer = (FrameLayout)selfRenderView.findViewById(R.id.native_ad_shake_view_container);
//
//        // bind view
//        List<View> clickViewList = new ArrayList<>();//click views
//
//        String title = adMaterial.getTitle();
//        // title
//        if (!TextUtils.isEmpty(title)) {
//            titleView.setText(title);
//            nativePrepareInfo.setTitleView(titleView);//bind title
//            clickViewList.add(titleView);
//            titleView.setVisibility(View.VISIBLE);
//        } else {
//            titleView.setVisibility(View.GONE);
//        }
//
//        String descriptionText = adMaterial.getDescriptionText();
//        if (!TextUtils.isEmpty(descriptionText)) {
//            // desc
//            descView.setText(descriptionText);
//            nativePrepareInfo.setDescView(descView);//bind desc
//            clickViewList.add(descView);
//            descView.setVisibility(View.VISIBLE);
//        } else {
//            descView.setVisibility(View.GONE);
//        }
//
//        // icon
//        View adIconView = adMaterial.getAdIconView();
//        String iconImageUrl = adMaterial.getIconImageUrl();
////        iconArea.removeAllViews();
////        final ATNativeImageView iconView = new ATNativeImageView(context);
////        if (adIconView != null) {
////            iconArea.addView(adIconView);
////            nativePrepareInfo.setIconView(adIconView);//bind icon
////            clickViewList.add(adIconView);
////            iconArea.setVisibility(View.VISIBLE);
////        } else if (!TextUtils.isEmpty(iconImageUrl)) {
////            iconArea.addView(iconView);
////            iconView.setImage(iconImageUrl);
////            nativePrepareInfo.setIconView(iconView);//bind icon
////            clickViewList.add(iconView);
////            iconArea.setVisibility(View.VISIBLE);
////        } else {
////            iconArea.setVisibility(View.INVISIBLE);
////        }
//
//        // cta button
//        String callToActionText = adMaterial.getCallToActionText();
//        if (!TextUtils.isEmpty(callToActionText)) {
//            ctaView.setText(callToActionText);
//            nativePrepareInfo.setCtaView(ctaView);//bind cta button
//            clickViewList.add(ctaView);
//            ctaView.setVisibility(View.VISIBLE);
//        } else {
//            ctaView.setVisibility(View.GONE);
//        }
//
//        // AppDownloadButton(Only Huawei Ads support)
////        View appDownloadButton = adMaterial.getAppDownloadButton();
////        if (appDownloadButton != null) {
////            if (appDownloadButton instanceof AppDownloadButton) {
////                ((AppDownloadButton) appDownloadButton).setTextSize(dip2px(context, 12));
////            }
////            ((ViewGroup) selfRenderView).addView(appDownloadButton, new ViewGroup.LayoutParams(dip2px(context, 74), dip2px(context, 26)));
////            appDownloadButton.setVisibility(View.VISIBLE);
////            ctaView.setVisibility(View.GONE);
////        }
//
//        // media view
//        View mediaView = adMaterial.getAdMediaView(contentArea);
//        int mainImageHeight = adMaterial.getMainImageHeight();
//        int mainImageWidth = adMaterial.getMainImageWidth();
//        int realMainImageWidth = context.getResources().getDisplayMetrics().widthPixels - dip2px(context, 10);
//        int realMainHeight = 0;
//        FrameLayout.LayoutParams mainImageParam = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT
//                , FrameLayout.LayoutParams.WRAP_CONTENT);
//        if (mainImageWidth > 0 && mainImageHeight > 0 && mainImageWidth > mainImageHeight) {
//            realMainHeight = realMainImageWidth * mainImageHeight / mainImageWidth;
//            mainImageParam.width = realMainImageWidth;
//            mainImageParam.height = realMainHeight;
//        } else {
//            mainImageParam.width = FrameLayout.LayoutParams.MATCH_PARENT;
//            mainImageParam.height = realMainImageWidth * 600 / 1024;
//        }
//
//        contentArea.removeAllViews();
//        if (mediaView != null) {
//            if (mediaView.getParent() != null) {
//                ((ViewGroup) mediaView.getParent()).removeView(mediaView);
//            }
//            mainImageParam.gravity = Gravity.CENTER;
//            mediaView.setLayoutParams(mainImageParam);
//            contentArea.addView(mediaView, mainImageParam);
//            clickViewList.add(mediaView);
//            contentArea.setVisibility(View.VISIBLE);
//        } else if (!TextUtils.isEmpty(adMaterial.getMainImageUrl())) {
//            ATNativeImageView imageView = new ATNativeImageView(context);
//            imageView.setImage(adMaterial.getMainImageUrl());
//            imageView.setLayoutParams(mainImageParam);
//            contentArea.addView(imageView, mainImageParam);
//
//            nativePrepareInfo.setMainImageView(imageView);//bind main image
//            clickViewList.add(imageView);
//            contentArea.setVisibility(View.VISIBLE);
//        } else {
//            contentArea.removeAllViews();
//            contentArea.setVisibility(View.GONE);
//        }
//
//
//        //Ad Logo
//        String adChoiceIconUrl = adMaterial.getAdChoiceIconUrl();
//        Bitmap adLogoBitmap = adMaterial.getAdLogo();
//        if (!TextUtils.isEmpty(adChoiceIconUrl)) {
//            logoView.setImage(adChoiceIconUrl);
//            nativePrepareInfo.setAdLogoView(logoView);//bind ad choice
//            logoView.setVisibility(View.VISIBLE);
//        } else if (adLogoBitmap != null) {
//            logoView.setImageBitmap(adLogoBitmap);
//            logoView.setVisibility(View.VISIBLE);
//        } else {
//            logoView.setImageBitmap(null);
//            logoView.setVisibility(View.GONE);
//        }
//
//        String adFrom = adMaterial.getAdFrom();
//
//        // ad from
//        if (!TextUtils.isEmpty(adFrom)) {
//            adFromView.setText(adFrom);
//            adFromView.setVisibility(View.VISIBLE);
//        } else {
//            adFromView.setVisibility(View.GONE);
//        }
//        nativePrepareInfo.setAdFromView(adFromView);//bind ad from
//
////        String domain = adMaterial.getDomain(); //(v6.1.20+) Yandex domain
////        if (!TextUtils.isEmpty(domain)) {
////            domainView.setVisibility(View.VISIBLE);
////            domainView.setText(domain);
////            clickViewList.add(domainView);
////            nativePrepareInfo.setDomainView(domainView);
////        } else {
////            domainView.setVisibility(View.GONE);
////        }
////
////        String warning = adMaterial.getWarning(); //(v6.1.20+) Yandex warning
////        if (!TextUtils.isEmpty(warning)) {
////            warningView.setVisibility(View.VISIBLE);
////            warningView.setText(warning);
////            clickViewList.add(warningView);
////            nativePrepareInfo.setWarningView(warningView);
////        } else {
////            warningView.setVisibility(View.GONE);
////        }
//
//        //(v6.1.40+) get the shakeView if the ad platform support, width or height at least 80dp.
//        int shakeViewWidth = dip2px(context, 100), shakeViewHeight = dip2px(context, 100);
//        View shakeView = adMaterial.getShakeView(shakeViewWidth, shakeViewHeight, new ATShakeViewListener() {
//            @Override
//            public void onDismiss() {
//
//            }
//        });
//
////        if (shakeView != null && shakeViewContainer != null) {
////            shakeViewContainer.setVisibility(View.VISIBLE);
////            shakeViewContainer.removeAllViews();
////            FrameLayout.LayoutParams shakeViewLayoutParams = new FrameLayout.LayoutParams(shakeViewWidth,                                                  shakeViewHeight);
////            shakeViewLayoutParams.gravity = Gravity.CENTER;
////            shakeViewContainer.addView(shakeView, shakeViewLayoutParams);
////        }
//
//        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(dip2px(context, 40), dip2px(context, 10));//ad choice
//        layoutParams.gravity = Gravity.BOTTOM | Gravity.RIGHT;
//        nativePrepareInfo.setChoiceViewLayoutParams(layoutParams);//bind layout params for ad choice
////        nativePrepareInfo.setCloseView(closeView);//bind close button
//
//        nativePrepareInfo.setClickViewList(clickViewList);//bind click view list
//
//        if (nativePrepareInfo instanceof ATNativePrepareExInfo) {
//            List<View> creativeClickViewList = new ArrayList<>();//click views
//            creativeClickViewList.add(ctaView);
//            ((ATNativePrepareExInfo) nativePrepareInfo).setCreativeClickViewList(creativeClickViewList);//bind custom view list
//        }
//
//        //6.2.32 如果支持设置权限View List，则可以传ViewList进去，点击事件由广告平台触发
//        if (adMaterial.supportSetPermissionClickViewList()) {
//            if (nativePrepareInfo instanceof ATNativePrepareExInfo) {
//                List<View> permissionClickViewList = new ArrayList<>();
////              permissionClickViewList.add(yourPermissionView);
//                ((ATNativePrepareExInfo) nativePrepareInfo).setPermissionClickViewList(permissionClickViewList);//bind custom view list
//            }
//        }
//        //6.2.32 如果支持设置隐私View List，则可以传ViewList进去，点击事件由广告平台触发
//        if (adMaterial.supportSetPrivacyClickViewList()) {
//            if (nativePrepareInfo instanceof ATNativePrepareExInfo) {
//                List<View> privacyClickViewList = new ArrayList<>();//click views
////               permissionClickViewList.add(yourPricacyView);
//                ((ATNativePrepareExInfo) nativePrepareInfo).setPrivacyClickViewList(privacyClickViewList);//bind custom view list
//            }
//        }
//    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int) (dipValue * scale + 0.5f);
    }
}
