package com.zl.sdk.out;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;

import com.zl.sdk.Config;
import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.AdDataManager;
import com.zl.sdk.ad.AdManagerV2;
import com.zl.sdk.bean.OutAdData;
import com.zl.sdk.bean.RemindersInfo;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.out.ui.DxActivity;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;

import java.util.HashMap;
import java.util.Map;

import cn.kuwo.show.mod.ACTD;


public class OutAdManager extends BaseOutShowManager {

    private HandlerThread handlerThread;
    private Handler workHandler;

    private OutAdManager() {
        handlerThread = new HandlerThread("ot_a");
        handlerThread.start();
        workHandler = new Handler(handlerThread.getLooper());
    }

    private static final OutAdManager INSTANCE = new OutAdManager();

    public static OutAdManager get() {
        return INSTANCE;
    }

    private static final String TAG = "OutShow OutAdManager --> ";


    @Override
    OutAdData.NormalAdData getAdData() {
        return AdDataManager.get().getShowAdData();
    }


    @Override
    RemindersInfo getReminderInfo() {
        RemindersInfo remindersInfo = new RemindersInfo();
        remindersInfo.reminderType = Config.REMINDER_TYPE_WEATHER_PURE_AD;
        remindersInfo.adScene = Config.AD_SCENE_TYPE_HOME;
        remindersInfo.isAdType = true;
        return remindersInfo;
    }


    @Override
    boolean checkCanShowForRemindInfo(RemindersInfo remindersInfo) {
        return false;
    }


    private volatile boolean working = false;
    /**
     * 开始进入广告逻辑
     *
     * @param actionFrom
     */
    public void startShowOutAd(ActionFrom actionFrom) {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑开始<<< ===> START action=" + actionFrom);
        LogUtil.d(TAG);
        if (working) {
            LogUtil.d(TAG + ">>>广告逻辑正在执行， 返回！");
            return;
        }
        workHandler.post(new Runnable() {
            @Override
            public void run() {
                doWork(actionFrom);
            }
        });
    }

    /**
     * 外展逻辑开始
     *
     * @param actionFrom
     */
    private void doWork(ActionFrom actionFrom) {
        try {
            working = true;
            Map<String, Object> map = new HashMap<>();
            map.put("type", String.valueOf(actionFrom.getAction()));
            Statistics.getInstance().dotEvent(OutHelp.get().getContext(), EventUtils.OUT_AD_START, "", map);

            OutAdData.NormalAdData adData = getAdData();
            if (adData == null) {
                return;
            }

            LogUtil.d(TAG);
            LogUtil.d(TAG + ">>>播放广告<<< =============>>> start");
            LogUtil.d(TAG);

            //次数检查
            boolean adTimesNoExceed = CheckHelper.checkCanShowAdByTimesFromAdData(adData, actionFrom.getAction(), EventUtils.SCENES_SHOW);
            if (!adTimesNoExceed) {
                LogUtil.d(TAG + "（次数检查）超过次数限制，返回");
                return;
            }

            if (AdManagerV2.get().loadAd(adData.cpAdslot)) {
                LogUtil.d(TAG + " 预加载广告，返回");
                return;
            }

            //场景检查
            boolean canShowByScene = CheckHelper.checkAdCanShowByScene(actionFrom.getAction(), EventUtils.SCENES_SHOW);
            if (!canShowByScene) {
                LogUtil.d(TAG + " 场景检查不通过，返回");
                return;
            }

            //时间间隔检查
            boolean adInterval = CheckHelper.checkCanShowAdByInterValFromAdData(adData, actionFrom.getAction(), EventUtils.SCENES_SHOW);
            if (!adInterval) {
                LogUtil.d(TAG + " 时间间隔内，返回");
                return;
            }

            OutHelp.get().setShowLock(true);

            LogUtil.d(TAG + ">>>播放广告<<< ============>>> END 检查通过 开始启动SLK");
            startAdDialog(OutHelp.get().getContext(), actionFrom, getReminderInfo(), adData);
        } catch (Exception e) {
        } finally {
            working = false;
        }

    }


    /**
     * 外展逻辑完成-成功
     */
    private void returnSuccessCallBack() {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑结束<<< ===> END 返回成功");
        LogUtil.d(TAG);
    }

    /**
     * 外展逻辑完成-失败
     */
    private void returnFailCallBack(String reason) {
        LogUtil.d(TAG);
        LogUtil.d(TAG + ">>>广告逻辑结束<<< ===> END 返回失败 reason=" + reason);
        LogUtil.d(TAG);
    }


    /**
     * 去拉起外展弹窗  播放or加载广告
     */
    private void startAdDialog(Context context, ActionFrom actionFrom, RemindersInfo remindersInfo, OutAdData.NormalAdData data) {
        try {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName(context, OutHelp.get().getActivityName()));
            try {
                intent.putExtra(ACTD.ATD, DxActivity.class.getName());
                intent.putExtra("SDK_NAME", OutHelp.get().getSdkName());
            } catch (Exception e) {
                intent.putExtra(ACTD.ATD, DxActivity.class.getName());
            }

            if (AppOutUtils.isScreenLock()) {
                AppOutUtils.unlockSystem();
            }

        /*    DxManager.get().setOutRemindersInfo(remindersInfo);
            DxManager.get().setOutAdData(data);*/

            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START, "", true, actionFrom.getAction());

//            NotificationConfig notificationConfig = new NotificationConfig(null);
            //这个参数传0 就是不悬挂在桌面，1000 就是悬挂一秒，-1 就是持续悬挂
//            notificationConfig.duration = 0;

            LogUtil.d(TAG + "拉起广告弹窗 :" + OutHelp.get().getSdkName());

            OutHelp.get().setLastShowTime();

            OutHelp.get().startOutDialog(intent, new DialogShowStatusCallback() {
                @Override
                public void success() {
                    outDialogShowSuccess(actionFrom);
                }

                @Override
                public void fail(String reason) {
                    outDialogShowFail(context, actionFrom, remindersInfo, data, reason);
                }
            });
        } catch (Exception e) {
            LogUtil.d(TAG + "广告弹窗 拉起失败 catch 不再重试");
            returnFailCallBack("slk show fail");
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_NO, e.toString(), true, actionFrom.getAction());
        }
    }

    private void outDialogShowFail(Context context, ActionFrom actionFrom, RemindersInfo remindersInfo, OutAdData.NormalAdData data, String reason) {
        LogUtil.d(TAG, "广告弹窗 拉起失败 失败原因：" + reason);
        try {
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_NO, reason, true, actionFrom.getAction());

            OutHelp.get().clearNotification();
//            if (!hadStartAdDialogFail) {
//            hadStartAdDialogFail = true;
//            LogUtil.d(TAG, "广告弹窗 拉起失败 " + startAdDialogIntervalTime + "后重试一次");
//            new Handler().postDelayed(() -> startAdDialog(context, actionFrom, remindersInfo, data), startAdDialogIntervalTime);
//            } else {
//                LogUtil.d(TAG + "广告弹窗 拉起失败 已经重试一次，不再重试");
//                LogUtil.d(TAG + "广告弹窗 拉起失败 ，不再重试");
//                returnFailCallBack(reason);
//            }
        } catch (Throwable ignored) {
        }
    }

    private void outDialogShowSuccess(ActionFrom actionFrom) {
        LogUtil.d(TAG + "广告弹窗（播放） 拉起成功");
        try {
            EventUtils.statRemindOutFgSurpriseStart(EventUtils.SLK_START_OK, "", true, actionFrom.getAction());
            returnSuccessCallBack();
        } catch (Throwable ignored) {
        }
    }


    public void showAdSuccess(OutAdData.NormalAdData adData) {
        LogUtil.d(TAG, "showAdSuccess adData =" + adData);
        if (adData == null) {
            return;
        }
        int outInterstitialAdDayShowCount = AppOutSP.getOutInterstitialAdDayShowCount();
        AppOutSP.saveOutInterstitialAdDayShowCount(++outInterstitialAdDayShowCount);
        LogUtil.d(TAG, "showAdSuccess interstitial outInterstitialAdDayShowCount =" + outInterstitialAdDayShowCount);
    }

    public void adClosed() {
    }
}