package com.zl.sdk.out;

import com.zl.sdk.OutHelp;
import com.zl.sdk.util.SPUtils;

public final class AppOutSP {

    private static final String TAG = "AppOutSP";
    private static final String APP_OUT_PREF_FILE_NAME = "pref_app_out_file";
    private static final String KEY_LOCK_NATIVE_AD_DAY_SHOW_COUNT = "lock_native_ad_day_show_count";
    private static final String KEY_LOCK_INTERSTITIAL_AD_DAY_SHOW_COUNT = "lock_interstitial_ad_day_show_count";
    private static final String KEY_HOME_NATIVE_AD_DAY_SHOW_COUNT = "home_native_ad_day_show_count";
    private static final String KEY_HOME_INTERSTITIAL_AD_DAY_SHOW_COUNT = "home_interstitial_ad_day_show_count";
    private static final String KEY_LOCK_LAST_SHOW_TIME = "lock_last_show_time";
    private static final String KEY_HOME_LAST_SHOW_TIME = "home_last_show_time";
    private static final String KEY_OUT_AD_DIALOG_CLOSE_LAST_TIME = "out_ad_dialog_close_last_time";

    private static final String KEY_IS_APP_FIRST_START = "is_app_first_start_in_devices";

    public static void saveLockNativeAdDayShowCount(int value) {
        getAppOutPref().put(KEY_LOCK_NATIVE_AD_DAY_SHOW_COUNT, value);
    }

    public static int getLockNativeAdDayShowCount() {
        return getAppOutPref().getInt(KEY_LOCK_NATIVE_AD_DAY_SHOW_COUNT, 0);
    }

    public static void saveLockInterstitialAdDayShowCount(int value) {
        getAppOutPref().put(KEY_LOCK_INTERSTITIAL_AD_DAY_SHOW_COUNT, value);
    }

    public static int getLockInterstitialAdDayShowCount() {
        return getAppOutPref().getInt(KEY_LOCK_INTERSTITIAL_AD_DAY_SHOW_COUNT, 0);
    }

    public static void saveHomeNativeAdDayShowCount(int value) {
        getAppOutPref().put(KEY_HOME_NATIVE_AD_DAY_SHOW_COUNT, value);
    }

    public static int getHomeNativeAdDayShowCount() {
        return getAppOutPref().getInt(KEY_HOME_NATIVE_AD_DAY_SHOW_COUNT, 0);
    }

    public static void saveHomeInterstitialAdDayShowCount(int value) {
        getAppOutPref().put(KEY_HOME_INTERSTITIAL_AD_DAY_SHOW_COUNT, value);
    }

    public static int getHomeInterstitialAdDayShowCount() {
        return getAppOutPref().getInt(KEY_HOME_INTERSTITIAL_AD_DAY_SHOW_COUNT, 0);
    }

    public static void saveLockLastShowTime(long value) {
        getAppOutPref().put(KEY_LOCK_LAST_SHOW_TIME, value);
    }

    public static long getLockLastShowTime() {
        return getAppOutPref().getLong(KEY_LOCK_LAST_SHOW_TIME, 0);
    }


    public static void saveHomeLastShowTime(long value) {
        getAppOutPref().put(KEY_HOME_LAST_SHOW_TIME, value);
    }

    public static long getHomeLastShowTime() {
        return getAppOutPref().getLong(KEY_HOME_LAST_SHOW_TIME, 0);
    }

    public static void saveOutAdDialogCloseLastTime(long value) {
        getAppOutPref().put(KEY_OUT_AD_DIALOG_CLOSE_LAST_TIME, value);
    }

    public static long getOutAdDialogCloseLastTime() {
        return getAppOutPref().getLong(KEY_OUT_AD_DIALOG_CLOSE_LAST_TIME, 0);
    }

    private static SPUtils getAppOutPref() {
        if (OutHelp.get().getContext() != null) {
            return SPUtils.getInstance(OutHelp.get().getContext(), APP_OUT_PREF_FILE_NAME);
        }
        return null;
    }

    public static boolean isAppFirstStart() {
        return getAppOutPref().getBoolean(KEY_IS_APP_FIRST_START, true);
    }

    public static void setIsAppFirstStart(boolean firstStart) {
        getAppOutPref().put(KEY_IS_APP_FIRST_START, firstStart);
    }

}
