package com.zl.sdk.ad;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;

import androidx.annotation.Nullable;

import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.nativead.api.ATNativeAdView;
import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.interstitial.TopOnAdInterstitialCallBack;
import com.zl.sdk.ad.interstitial.TopOnInterstitialAdLoad;
import com.zl.sdk.ad.natives.TopOnAdNativeCallBack;
import com.zl.sdk.ad.natives.TopOnNativeAdManager;
import com.zl.sdk.bean.OutAdData;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.AppOutSP;
import com.zl.sdk.out.OutAdManager;
import com.zl.sdk.util.LogUtil;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TopOnAdLoadManager {
    public static final String TAG = "OutShow TopOnAdLoadManager";

    public static final String REGISTER_TAG_WEATHER_PURE_AD = "WeatherPureAdDialog";
    private Context mContext;
    private final HashMap<String, AdCacheData> adCacheDataMap = new HashMap<>();

    private final TopOnInterstitialAdLoad topOnInterstitialAdLoad = new TopOnInterstitialAdLoad();
    private final TopOnNativeAdManager topOnNativeAdManager = new TopOnNativeAdManager();
    private final HashMap<String, WeakReference<OnInAdListener>> interstitialListenerHashMap = new HashMap<>();
    private final HashMap<String, WeakReference<OnInAdListener>> nativeListenerHashMap = new HashMap<>();
    private final HashMap<String, Boolean> flagLoadMap = new HashMap<>();

    private TopOnAdInterstitialCallBack adInterstitialCallBack = new TopOnAdInterstitialCallBack() {

        @Override
        public void onAdLoaded(String adUnitId, String adScenes, OutAdData.NormalAdData adData, ATInterstitial ad) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdLoaded adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            adCacheDataMap.put(adUnitId, new AdCacheData(ad, System.currentTimeMillis(), adUnitId));

//            AppOutNotifyManager.getInstance().resetOutAdFailCount();

            callInterstitialAdLoaded();

            OutAdManager.get().cleanLoadAdFailTime();

            //只要有广告加载成功就去走播放逻辑
            new Handler().postDelayed(() -> {
                //加载成功，调用播放纯广告逻辑
                LogUtil.d(TAG + "doWork 222");
                OutAdManager.get().doWork(ActionFrom.ACTION_UNKNOWN);
            }, IconHelp.get().isIconHide() ? 0 : 1000);
        }

        @Override
        public void onAdDisplayed(String adUnitId, OutAdData.NormalAdData adData) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdDisplayed adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            adCacheDataMap.remove(adUnitId);
            callInterstitialAdShow();
            countAdShowTimes(adData);
        }

        @Override
        public void onAdHidden(String adUnitId) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdHidden adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            adCacheDataMap.remove(adUnitId);
            callInterstitialCloseAd();
        }

        @Override
        public void onAdClicked(String adUnitId) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdClicked adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            callInterstitialAdClk();
        }

        @Override
        public void onAdLoadFailed(String adUnitId, String errorMsg) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdLoadFailed adUnitId =" + adUnitId + ", Error=" + errorMsg);
//            AppOutNotifyManager.getInstance().loadOutAdFail();
            flagLoadMap.put(adUnitId, true);

            OutAdManager.get().showAdFail();
            callInterstitialNotAd(null == errorMsg ? "" : errorMsg);
        }

        @Override
        public void onAdDisplayFailed(String adUnitId, String errorMsg) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdDisplayFailed adUnitId =" + adUnitId + ", errorMsg=" + errorMsg);
            flagLoadMap.put(adUnitId, true);
            adCacheDataMap.remove(adUnitId);
            callInterstitialCloseAd();
        }

        @Override
        public void onAdRevenuePaid(String adUnitId) {
            LogUtil.d(TAG, "AdInterstitialCallBack onAdRevenuePaid adUnitId =" + adUnitId);
        }
    };
    private TopOnAdNativeCallBack adNativeCallBack = new TopOnAdNativeCallBack() {
        @Override
        public void onNativeAdLoaded(String adUnitId, String adScenes, OutAdData.NormalAdData adData, @Nullable ATNativeAdView atNative) {
            LogUtil.d(TAG, "AdNativeCallBack onNativeAdLoaded adUnitId =" + adUnitId);

            if (null == atNative) {
                Statistics.getInstance().onEvent(OutHelp.get().getContext(), EventUtils.TOPON_LOAD_SUCCESS_BUT_CALLBACK_NULL, "");
            }

            adCacheDataMap.put(adUnitId, new AdCacheData(atNative, System.currentTimeMillis(), adUnitId));
            flagLoadMap.put(adUnitId, true);

            callNativeAdLoaded();

            //只要有广告加载成功就去走播放逻辑
            new Handler().postDelayed(() -> {
                //加载成功，调用播放纯广告逻辑
                LogUtil.d(TAG + "doWork 333");
                OutAdManager.get().doWork(ActionFrom.ACTION_UNKNOWN);
            }, 1000L);
        }

        @Override
        public void onNativeAdLoadFailed(String adUnitId, String errorMsg) {
            LogUtil.d(TAG, "AdNativeCallBack onNativeAdLoadFailed adUnitId =" + adUnitId + ", errorMsg=" + errorMsg);
            flagLoadMap.put(adUnitId, true);
            OutAdManager.get().showAdFail();
            callNativeNotAd(null == errorMsg ? "" : errorMsg.toString());
        }

        @Override
        public void onNativeAdClicked(String adUnitId) {
            LogUtil.d(TAG, "AdNativeCallBack onNativeAdClicked adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            adCacheDataMap.remove(adUnitId);
            callNativeAdClk();
        }

        @Override
        public void onNativeAdExpired(String adUnitId) {
            LogUtil.d(TAG, "AdNativeCallBack onNativeAdExpired adUnitId =" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            adCacheDataMap.remove(adUnitId);
            callNativeCacheTimeOut();
        }

        @Override
        public void onAdRevenuePaid(String adUnitId) {
            LogUtil.d(TAG, "AdNativeCallBack onAdRevenuePaid adUnitId =" + adUnitId);
        }

        @Override
        public void onAdImpression(String adUnitId, OutAdData.NormalAdData adData) {
            LogUtil.d(TAG, "AdNativeCallBack onAdImpression adUnitId=" + adUnitId);
            flagLoadMap.put(adUnitId, true);
            adCacheDataMap.remove(adUnitId);
            callNativeAdShow();
            countAdShowTimes(adData);
        }

        @Override
        public void onCloseAd() {
            callNativeCloseAd();
        }
    };

    private TopOnAdLoadManager() {
        mContext = OutHelp.get().getContext();
    }

    private static class Holder {
        private static final TopOnAdLoadManager INSTANCE = new TopOnAdLoadManager();
    }

    public static TopOnAdLoadManager getInstance() {
        return Holder.INSTANCE;
    }

    public Object getAdCacheData(String adUnitId) {
        if (TextUtils.isEmpty(adUnitId)) {
            return null;
        }
        return adCacheDataMap.get(adUnitId);
    }

    public void loadInterstitialAd(OutAdData.NormalAdData normalAdData, String adScenes) {
        if (null == normalAdData || TextUtils.isEmpty(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "loadInterstitialAd data or adId empty");
            callInterstitialNotAd(AdErrorMessage.AD_DATA_IS_NULL_OR_NOT_ADUNITID);
            return;
        }

        AdCacheData adCacheData = adCacheDataMap.get(normalAdData.cpAdslot);
        if (null != adCacheData && topOnInterstitialAdLoad.isReady(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "loadInterstitialAd isReady");
            callInterstitialAdLoaded();
            return;
        }

        Boolean canLoadAd = flagLoadMap.get(normalAdData.cpAdslot);
        if (null != canLoadAd && !canLoadAd) {
            LogUtil.d(TAG, "loadInterstitialAd canLoadAd loading");
            return;
        }

        String adType = normalAdData.cpAdtype;
        if (TextUtils.isEmpty(adType)) {
            LogUtil.d(TAG, "loadInterstitialAd adType empty");
            callInterstitialNotAd(AdErrorMessage.NOT_ADTYPE);
            return;
        }

        String cpName = normalAdData.cpName;
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG, "loadInterstitialAd cpName empty");
            callInterstitialNotAd(AdErrorMessage.NOT_AD_CP);
            return;
        }
        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "loadInterstitialAd adCp not support");
            callInterstitialNotAd(AdErrorMessage.AD_CP_NOT_SUPPORT);
            return;
        }

        flagLoadMap.put(normalAdData.cpAdslot, false);

        try {
            AdBean adBean = AdBean.getInstance(adScenes)
                    .setAdUnitId(normalAdData.cpAdslot)
                    .setAdPosition("home")
                    .setAdData(normalAdData);
            topOnInterstitialAdLoad.loadInterstitialAd(adBean, adInterstitialCallBack);
        } catch (Exception e) {
            flagLoadMap.put(normalAdData.cpAdslot, true);
            callInterstitialNotAd(e.toString());
        }
    }

    private AdBean showingAdBean = null;

    public void showInterstitialAd(Activity activity, AdBean adBean) {
        LogUtil.d(TAG, "showInterstitialAd really");
        showingAdBean = adBean;
        topOnInterstitialAdLoad.showInterstitialAd(activity, adBean);
    }

    public boolean isInterstitialReady(String cpName, String adUnitId) {
        if (TextUtils.isEmpty(cpName) || TextUtils.isEmpty(adUnitId)) {
            LogUtil.d(TAG, "isInterstitialReady data empty");
            return false;
        }
        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "isInterstitialReady no ad");
            return false;
        }
        if (!topOnInterstitialAdLoad.isReady(adUnitId)) {
            LogUtil.d(TAG, "isInterstitialReady no ready");
            return false;
        }
        return true;
    }

    public boolean isNativeReady(String adUnitId) {
        AdCacheData adCacheData = adCacheDataMap.get(adUnitId);
        if (null != adCacheData
                && adCacheData.object instanceof ATNativeAdView
                && !((AdCacheData) adCacheData).isNativeTimeout()) {
            LogUtil.d(TAG, "loadNativeAd isReady");
            return true;
        }
        return false;
    }

    public void showInterstitialAd(Activity activity, OutAdData.NormalAdData normalAdData, String adScenes) {
        if (null == normalAdData || TextUtils.isEmpty(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "showInterstitialAd data or adId empty");
            callInterstitialNotAd(AdErrorMessage.AD_DATA_IS_NULL_OR_NOT_ADUNITID);
            return;
        }
        String adType = normalAdData.cpAdtype;
        if (TextUtils.isEmpty(adType)) {
            LogUtil.d(TAG, "showInterstitialAd adType empty");
            callInterstitialNotAd(AdErrorMessage.NOT_ADTYPE);
            return;
        }
        String cpName = normalAdData.cpName;
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG, "showInterstitialAd cpName empty");
            callInterstitialNotAd(AdErrorMessage.NOT_AD_CP);
            return;
        }
        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "showInterstitialAd adCp not support");
            callInterstitialNotAd(AdErrorMessage.AD_CP_NOT_SUPPORT);
            return;
        }
        if (!topOnInterstitialAdLoad.isReady(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "showInterstitialAd ad no Ready");
            callInterstitialNotAd(AdErrorMessage.AD_NOT_CACHE);
            return;
        }
        boolean adScenesSupport = false;
        if (normalAdData.position == OutAdData.POSITION_HOME) {
            LogUtil.d(TAG, "showInterstitialAd AdScenes HOME");
            adScenesSupport = true;
        } else if (normalAdData.position == OutAdData.POSITION_LOCK) {
            LogUtil.d(TAG, "showInterstitialAd AdScenes LOCK");
            adScenesSupport = true;
        }
        if (!adScenesSupport) {
            LogUtil.d(TAG, "showInterstitialAd adScenes no Support");
            callInterstitialNotAd(AdErrorMessage.AD_SCENES_NOT_SUPPORT);
            return;
        }

        AdBean adBean = AdBean.getInstance(adScenes).setAdUnitId(normalAdData.cpAdslot)
                .setAdPosition("home")
                .setAdData(normalAdData);
        showInterstitialAd(activity, adBean);

        Map<String, Object> para = new HashMap<>();
        para.put("ad_scenes", adScenes);
        para.put("ad_type", "interstitial");
        para.put("adUnitId", normalAdData.cpAdslot);
        Statistics.getInstance().onEvent(mContext, EventUtils.LOAD_CACHE_AD, "", para);
    }

    private void statInterstitialAdLoadedState(boolean isScreenOn, boolean isLock) {
        Map<String, Object> map = new HashMap<>();
        map.put("isScreenOn", String.valueOf(isScreenOn));
        map.put("isLock", String.valueOf(isLock));
        Statistics.getInstance().dotEvent(mContext, "it_state", "", map);
    }

    private void statNativeAdLoadedState(boolean isScreenOn, boolean isLock) {
        Map<String, Object> map = new HashMap<>();
        map.put("isScreenOn", String.valueOf(isScreenOn));
        map.put("isLock", String.valueOf(isLock));
        Statistics.getInstance().dotEvent(mContext, "nt_state", "", map);
    }

    public void loadNativeAd(OutAdData.NormalAdData normalAdData, String adScenes) {
        if (null == normalAdData || TextUtils.isEmpty(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "loadNativeAd data or adId empty");
            callNativeNotAd(AdErrorMessage.AD_DATA_IS_NULL_OR_NOT_ADUNITID);
            return;
        }
        AdCacheData adCacheData = adCacheDataMap.get(normalAdData.cpAdslot);
        if (null != adCacheData && adCacheData.object instanceof ATNativeAdView) {
            LogUtil.d(TAG, "loadNativeAd isReady");
            callNativeAdLoaded();
            return;
        }
        Boolean canLoadAd = flagLoadMap.get(normalAdData.cpAdslot);
        if (null != canLoadAd && !canLoadAd) {
            LogUtil.d(TAG, "loadNativeAd canLoadAd loading");
            return;
        }
        String adType = normalAdData.cpAdtype;
        if (TextUtils.isEmpty(adType)) {
            LogUtil.d(TAG, "loadNativeAd adType empty");
            callNativeNotAd(AdErrorMessage.NOT_ADTYPE);
            return;
        }
        String cpName = normalAdData.cpName;
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG, "loadNativeAd cpName empty");
            callNativeNotAd(AdErrorMessage.NOT_AD_CP);
            return;
        }
        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "loadNativeAd adCp not support");
            callNativeNotAd(AdErrorMessage.AD_CP_NOT_SUPPORT);
            return;
        }
        flagLoadMap.put(normalAdData.cpAdslot, false);
//        int layoutId = 0;
//        if (normalAdData.adStyle == 3) {
//            layoutId = R.layout.m_small_template_view;
//        } else if (normalAdData.adStyle == 4 || normalAdData.adStyle == 5) {
//            layoutId = R.layout.m_medium_template_view;
//        }
        try {
            AdBean bean = AdBean.getInstance(adScenes).setAdUnitId(normalAdData.cpAdslot)
                    .setAdPosition("home")
                    .setNativeTemplate(normalAdData.adStyle)
                    .setAdData(normalAdData);

            LogUtil.d(TAG, "loadNativeAd bean=" + bean);
            topOnNativeAdManager.showNative(bean, adNativeCallBack);
        } catch (Exception e) {
            flagLoadMap.put(normalAdData.cpAdslot, true);
            callNativeNotAd(e.toString());
        }
    }

    public void showNativeAd(OutAdData.NormalAdData normalAdData, LinearLayout adContent) {
        if (null == normalAdData || TextUtils.isEmpty(normalAdData.cpAdslot)) {
            LogUtil.d(TAG, "showNativeAd data or adId empty");
            callNativeNotAd(AdErrorMessage.AD_DATA_IS_NULL_OR_NOT_ADUNITID);
            return;
        }
        String adType = normalAdData.cpAdtype;
        if (TextUtils.isEmpty(adType)) {
            LogUtil.d(TAG, "showNativeAd adType empty");
            callNativeNotAd(AdErrorMessage.NOT_ADTYPE);
            return;
        }
        String cpName = normalAdData.cpName;
        if (TextUtils.isEmpty(cpName)) {
            LogUtil.d(TAG, "showNativeAd cpName empty");
            callNativeNotAd(AdErrorMessage.NOT_AD_CP);
            return;
        }
        if (!cpName.equalsIgnoreCase(OutAdData.CP_AD_TOPON)) {
            LogUtil.d(TAG, "showNativeAd adCp not support");
            callNativeNotAd(AdErrorMessage.AD_CP_NOT_SUPPORT);
            return;
        }
        AdCacheData adCacheData = adCacheDataMap.get(normalAdData.cpAdslot);
        if (null == adCacheData || null == adCacheData.object) {
            LogUtil.d(TAG, "showNativeAd ad no Ready");
            callNativeNotAd(AdErrorMessage.AD_NOT_CACHE);
            return;
        }

        if (adCacheData.isNativeTimeout()) {
            LogUtil.d(TAG, "showNativeAd ad Timeout");
            adCacheDataMap.remove(normalAdData.cpAdslot);
            callNativeCacheTimeOut();
            return;
        }

        new Handler().post(() -> {
            if (adCacheData.object instanceof ATNativeAdView) {
                adContent.setVisibility(View.VISIBLE);
                adContent.removeAllViews();

                adCacheDataMap.remove(normalAdData.cpAdslot);

                ATNativeAdView adView = (ATNativeAdView) adCacheData.object;
                if (adView.getParent() == null) {
                    adContent.addView(adView);
                }
            } else {
                adCacheDataMap.remove(normalAdData.cpAdslot);
                callNativeNotAd(AdErrorMessage.AD_TYPE_VIEW_ERROR);
            }
        });
    }

    private void callNativeNotAd(String errorMessage) {
        callNotAd(nativeListenerHashMap, errorMessage);
    }

    private void callInterstitialNotAd(String errorMessage) {
        callNotAd(interstitialListenerHashMap, errorMessage);
    }

    private void callNotAd(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap, String errorMessage) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onNotAd(errorMessage);
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callNativeAdLoaded() {
        callAdLoaded(nativeListenerHashMap);
    }

    private void callInterstitialAdLoaded() {
        callAdLoaded(interstitialListenerHashMap);
    }

    private void callAdLoaded(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onLoadAd();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callNativeAdShow() {
//        stop5MinTimer();
//        OutAdManager.get().refreshShowAdNowRule(android.os.Process.myPid(), false);
        callAdShow(nativeListenerHashMap);
    }

    private void callInterstitialAdShow() {
//        stop5MinTimer();
//        OutAdManager.get().refreshShowAdNowRule(android.os.Process.myPid(), false);
        callAdShow(interstitialListenerHashMap);
    }

    private void callAdShow(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        LogUtil.d("OutShow 重置最后展示时间");
        AppOutSP.saveHomeLastShowTime(System.currentTimeMillis());

        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onShow();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callNativeCloseAd() {
        callCloseAd(nativeListenerHashMap);
    }

    private void callInterstitialCloseAd() {
//        stop5MinTimer();
//        OutAdManager.get().refreshShowAdNowRule(android.os.Process.myPid(), false);
        topOnInterstitialAdLoad.destroy(showingAdBean);
        callCloseAd(interstitialListenerHashMap);
    }

    private void callCloseAd(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onCloseAd();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callNativeAdClk() {
        callAdClk(nativeListenerHashMap);
    }

    private void callInterstitialAdClk() {
        callAdClk(interstitialListenerHashMap);
    }

    private void callAdClk(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.onClk();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    private void callNativeCacheTimeOut() {
        callCacheTimeOut(nativeListenerHashMap);
    }

    private void callInterstitialCacheTimeOut() {
        callCacheTimeOut(interstitialListenerHashMap);
    }

    private void callCacheTimeOut(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap) {
        Iterator<Map.Entry<String, WeakReference<OnInAdListener>>> iterator = listenerHashMap.entrySet().iterator();
        ArrayList<String> deleteKeys = new ArrayList<>();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<OnInAdListener>> entry = iterator.next();
            WeakReference<OnInAdListener> reference = entry.getValue();
            if (reference != null) {
                OnInAdListener adListener = reference.get();
                if (adListener != null) {
                    adListener.cacheDataTimeOut();
                } else {
                    String key = entry.getKey();
                    if (!TextUtils.isEmpty(key)) {
                        deleteKeys.add(key);
                    }
                }
            } else {
                String key = entry.getKey();
                if (!TextUtils.isEmpty(key)) {
                    deleteKeys.add(key);
                }
            }
        }
        for (String key : deleteKeys) {
            listenerHashMap.remove(key);
        }
    }

    public void registerCallBack(String adType, String tag, OnInAdListener onInAdListener) {
        if (TextUtils.isEmpty(adType)) {
            return;
        }
        switch (adType) {
            case OutAdData.CP_AD_TYPE_CHAPING:
                registerInterstitialCallBack(tag, onInAdListener);
                break;
            case OutAdData.CP_AD_TYPE_NATIVE:
                registerNativeCallBack(tag, onInAdListener);
                break;
            default:
                break;
        }
    }

    public void unregisterCallBack(String adType, String tag) {
        if (TextUtils.isEmpty(adType)) {
            return;
        }
        switch (adType) {
            case OutAdData.CP_AD_TYPE_CHAPING:
                unregisterInterstitialCallBack(tag);
                break;
            case OutAdData.CP_AD_TYPE_NATIVE:
                unregisterNativeCallBack(tag);
                break;
            default:
                break;
        }
    }

    public void registerInterstitialCallBack(String tag, OnInAdListener onInAdListener) {
        LogUtil.d(TAG, "registerInterstitialCallBack tag =" + tag);
        registerCallBack(interstitialListenerHashMap, tag, onInAdListener);
    }

    public void registerNativeCallBack(String tag, OnInAdListener onInAdListener) {
        LogUtil.d(TAG, "registerNativeCallBack tag =" + tag);
        registerCallBack(nativeListenerHashMap, tag, onInAdListener);
    }

    public void registerCallBack(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap, String tag, OnInAdListener onInAdListener) {
        if (TextUtils.isEmpty(tag)) {
            return;
        }
        if (onInAdListener != null) {
            WeakReference<OnInAdListener> reference = new WeakReference<OnInAdListener>(onInAdListener);
            if (listenerHashMap.isEmpty()) {
                LogUtil.d(TAG, "registerCallBack tag =" + tag);
                listenerHashMap.put(tag, reference);
                return;
            }
            WeakReference<OnInAdListener> oldReference = listenerHashMap.get(tag);
            if (oldReference != null) {
                OnInAdListener adListener = oldReference.get();
                if (adListener != null && adListener.equals(onInAdListener)) {
                    return;
                }
            }
            listenerHashMap.put(tag, reference);
            LogUtil.d(TAG, "registerCallBack add tag =" + tag);
        }
    }

    public void unregisterInterstitialCallBack(String tag) {
        LogUtil.d(TAG, "unregisterInterstitialCallBack tag =" + tag);
        unregisterCallBack(interstitialListenerHashMap, tag);
    }

    public void unregisterNativeCallBack(String tag) {
        LogUtil.d(TAG, "unregisterNativeCallBack tag =" + tag);
        unregisterCallBack(nativeListenerHashMap, tag);
    }

    private void unregisterCallBack(HashMap<String, WeakReference<OnInAdListener>> listenerHashMap, String tag) {
        if (TextUtils.isEmpty(tag)) {
            return;
        }
        listenerHashMap.remove(tag);
    }

    private void countAdShowTimes(OutAdData.NormalAdData adData) {
        LogUtil.d(TAG, "countAdShowTimes adData =" + adData);
        OutAdManager.get().showAdSuccess(adData);
    }
}
