/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.content.ContentValues;
import android.text.TextUtils;
import com.or.ange.database.LikePalException;
import com.or.ange.database.Type;
import com.or.ange.database.annotation.Column;
import java.lang.reflect.Field;

class ColumnModel {
    private final Field field;
    private String name;
    private boolean notnull;
    private boolean primaryKey;
    private boolean autoIncrement;
    private boolean unique;
    private String check;
    private String index;
    private boolean ignore;
    private Type<?> type;

    ColumnModel(Field field) {
        this.field = field;
        this.name = field.getName();
        Column column = field.getAnnotation(Column.class);
        if (column != null) {
            if (!TextUtils.isEmpty((CharSequence)column.name())) {
                this.name = column.name();
            }
            this.notnull = column.notnull();
            this.primaryKey = column.primaryKey();
            this.autoIncrement = column.autoIncrement();
            this.unique = column.unique();
            this.index = column.index();
            this.check = column.check();
            this.ignore = column.ignore();
        }
        if (!this.ignore) {
            this.type = Type.getType(field.getType());
        }
    }

    void put(ContentValues values, String key, Object obj) {
        if (this.isAutoIncrement()) {
            return;
        }
        if (Type.Integer.equals(this.type)) {
            values.put(key, Type.Integer.cast(obj));
        } else if (Type.Float.equals(this.type)) {
            values.put(key, Type.Float.cast(obj));
        } else if (Type.Double.equals(this.type)) {
            values.put(key, Type.Double.cast(obj));
        } else if (Type.Long.equals(this.type)) {
            values.put(key, Type.Long.cast(obj));
        } else if (Type.Short.equals(this.type)) {
            values.put(key, Type.Short.cast(obj));
        } else if (Type.Boolean.equals(this.type)) {
            values.put(key, Type.Boolean.cast(obj));
        } else if (Type.Character.equals(this.type) || Type.String.equals(this.type)) {
            values.put(key, Type.String.cast(obj));
        } else if (Type.ByteArray.equals(this.type) || Type.Bitmap.equals(this.type) || Type.Serializable.equals(this.type) || Type.Parcelable.equals(this.type)) {
            values.put(key, Type.ByteArray.cast(obj));
        }
    }

    String getDbType() {
        if (Type.Float.equals(this.type) || Type.Double.equals(this.type)) {
            return "REAL";
        }
        if (Type.Integer.equals(this.type) || Type.Long.equals(this.type) || Type.Short.equals(this.type) || Type.Boolean.equals(this.type)) {
            return "INTEGER";
        }
        if (Type.Character.equals(this.type) || Type.String.equals(this.type)) {
            return "TEXT";
        }
        if (Type.Bitmap.equals(this.type) || Type.Serializable.equals(this.type) || Type.Parcelable.equals(this.type) || Type.ByteArray.equals(this.type)) {
            return "BLOB";
        }
        throw new LikePalException("db not support for type:" + this.type);
    }

    public boolean isLegalKey() {
        return this.getDbType().equals("TEXT") || this.getDbType().equals("INTEGER");
    }

    public boolean isAutoIncrementKey() {
        return this.getDbType().equals("INTEGER");
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNotnull() {
        return this.notnull;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getCheck() {
        return this.check;
    }

    public String getIndex() {
        return this.index;
    }

    public Type<?> getType() {
        return this.type;
    }

    public boolean isIgnore() {
        return this.ignore;
    }
}

