package com.zl.sdk.data;

import static com.zl.sdk.bean.WeatherAdData.CP_AD_TOPON;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;

import com.google.gson.Gson;
import com.zl.sdk.bean.OutConfig;
import com.zl.sdk.bean.IconOpt;
import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.SPUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据管理类
 */
public class DataManager {
    private DataManager() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final DataManager INSTANCE = new DataManager();
    }

    public static DataManager get() {
        return DataManager.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow DataManager ---> ";
    private static final String CONFIG_SP = "configSp";
    private static final String AD_CONFIG = "ads_config";
    private static final String OUT_CONFIG = "out_config";
    private static final String ICON_CONFIG = "icon_config";

    private Map<Integer, ArrayList<WeatherAdData.NormalAdData>> adDataMap = null;
    private IconOpt iconOpt = null;
    private OutConfig outConfig = null;

    /**
     * 从SP中获取广告信息
     */
    public Map<Integer, ArrayList<WeatherAdData.NormalAdData>> getAdDataFromSP(Context context) {
        if (adDataMap != null) {
            return adDataMap;
        }

        String adConfigString = SPUtils.getInstance(context, CONFIG_SP).getString(AD_CONFIG, "");

        WeatherAdData weatherAdData = null;

        if (!TextUtils.isEmpty(adConfigString)) {
            try {
                weatherAdData = new Gson().fromJson(adConfigString, WeatherAdData.class);
            } catch (Exception ignored) {
            }
            if (weatherAdData == null) {
                SPUtils.getInstance(context, CONFIG_SP).remove(AD_CONFIG, true);
            }
        }


        if (weatherAdData == null || !weatherAdData.isDataOK()) {
            return null;
        }

        WeatherAdData.Data data = weatherAdData.getData();
        if (data == null) {
            return null;
        }

        if (data.normal.isEmpty()) {
            return null;
        }

        adDataMap = new HashMap<>();

        for (WeatherAdData.NormalAdData adData : data.normal) {
            if (adData.isSelfFlag()) {
                continue;
            }
            List<WeatherAdData.CpAdData> cpList = adData.cpList;
            if (cpList.isEmpty()) {
                continue;
            }

            if (adData.isWZAdType()) {
                ArrayList<WeatherAdData.NormalAdData> adDataList = new ArrayList<>();
                for (WeatherAdData.CpAdData cpAdData : cpList) {
                    String cpName = cpAdData.name;
                    String appid = cpAdData.appid;
                    String adslot = cpAdData.adslot;
                    String adType = cpAdData.adType;
                    if (CP_AD_TOPON.equalsIgnoreCase(cpName)
                            && !TextUtils.isEmpty(cpName)
                            && !TextUtils.isEmpty(appid)
                            && !TextUtils.isEmpty(adslot)
                            && !TextUtils.isEmpty(adType)) {
                        adData.cpName = cpAdData.name;
                        adData.cpAppid = cpAdData.appid;
                        adData.cpAdslot = cpAdData.adslot;
                        adData.cpAdtype = cpAdData.adType;
                        adData.showTimes = cpAdData.showTimes;
                        adData.showTimesHideForAdId = cpAdData.showTimesHide;
                        adData.adStyle = cpAdData.adStyle;
                        adData.ad_Scenes = "wz";
                        WeatherAdData.NormalAdData newAdData = adData.cloneAdData();
                        adDataList.add(newAdData);
                    }
                }
                LogUtil.d(TAG + "adData = " + data);
                adDataMap.put(adData.position, adDataList);
            }
        }

        return adDataMap;
    }

    /**
     * 从SP中获取外展配置数据
     */
    public OutConfig getOutDataFromSP(Context context) {
        if (outConfig != null) {
            return outConfig;
        }

        String outConfigString = SPUtils.getInstance(context, CONFIG_SP).getString(OUT_CONFIG, "");

        if (!TextUtils.isEmpty(outConfigString)) {
            try {
                outConfig = new Gson().fromJson(outConfigString, OutConfig.class);
            } catch (Exception ignored) {
            }

            if (outConfig == null) {
                SPUtils.getInstance(context, CONFIG_SP).remove(OUT_CONFIG, true);
            }
        }

        LogUtil.d(TAG + "outConfig = " + outConfig);
        return outConfig;
    }

    /**
     * 从SP中获取Icon配置数据
     */
    public IconOpt getIconDataFromSP(Context context) {
        if (iconOpt != null) {
            return iconOpt;
        }

        String outConfigString = SPUtils.getInstance(context, CONFIG_SP).getString(ICON_CONFIG, "");
        if (!TextUtils.isEmpty(outConfigString)) {
            try {
                iconOpt = new Gson().fromJson(outConfigString, IconOpt.class);
            } catch (Exception ignored) {
            }

            if (iconOpt == null) {
                SPUtils.getInstance(context, CONFIG_SP).remove(ICON_CONFIG, true);
            }
        }
        LogUtil.d(TAG + "iconOpt = " + iconOpt);
        return iconOpt;
    }

}
