package com.zl.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;

import androidx.annotation.Keep;

import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.ad.topOn.TopOnAdManager;
import com.zl.sdk.icon.IcOptManager;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.icon.IconStateCallBack;
import com.zl.sdk.keeplive.KplvManager;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.DialogShowStatusCallback;
import com.zl.sdk.out.OutAdManager;

@Keep
public final class OutHelp {
    private OutHelp() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final OutHelp INSTANCE = new OutHelp();
    }

    public static OutHelp get() {
        return OutHelp.Holder.INSTANCE;
    }

    private Context mContext = null;
    private boolean isDebug = false;

    private String sdkName = null;
    private Intent intent = null;
    //icon状态返回
    private IconStateCallBack iconStateCallBack = null;
    //外展弹窗拉起回调
    private DialogShowStatusCallback dialogShowStatusCallback = null;

    /**
     * 初始化
     *
     * @param context 上下文
     * @param appInfo topon应用信息
     * @param isDebug 开启调试
     */
    public void init(Context context, AdAppInfo appInfo, boolean isDebug, String sdkName) {
        this.mContext = context;
        this.isDebug = isDebug;
        this.sdkName = sdkName;

        //初始化保活
        KplvManager.getInstance().attachBase(context);

        //初始化广告SDK
        TopOnAdManager.get().initSDK(context, appInfo);

        //Icon初始化
        IcOptManager.getInstance().init(context);
        IconHelp.get().init(context);
    }

    /**
     * 监听icon状态
     */
    public void setIconStateCallBack(IconStateCallBack iconStateCallBack) {
        this.iconStateCallBack = iconStateCallBack;
    }


    /**
     * 进入外展广告播放逻辑（解锁）
     *
     * @param targetClass 目标页
     * @param actionFrom  动作来源
     * @param callback    结果回调
     */
    public void showOutAd(Class targetClass, ActionFrom actionFrom, DialogShowStatusCallback callback) {
        intent = new Intent(mContext, targetClass);
        dialogShowStatusCallback = callback;
        OutAdManager.get().startShowOutAd(actionFrom);
    }


    /**
     * 进入外展广告播放逻辑 （轮询）
     *
     * @param targetClass 目标页
     * @param isFirst     是否第一次检查
     * @param callback    结果回调
     */
    public void showOutAd(Class targetClass, boolean isFirst, DialogShowStatusCallback callback) {
        intent = new Intent(mContext, targetClass);
        dialogShowStatusCallback = callback;
        OutAdManager.get().checkShowOutAd(isFirst);
    }


    /**
     * 隐藏icon
     *
     * @param componentName 启动页完整路径
     */
    public void hideIcon(String componentName) {
        KplvManager.getInstance().hideIcon(mContext, componentName);
    }

    /**
     * 显示icon
     *
     * @param componentName 启动页完整路径
     */
    public void showIcon(String componentName) {
        KplvManager.getInstance().showIcon(mContext, componentName);
    }


    public Context getContext() {
        return mContext;
    }

    public Intent getIntent() {
        return intent;
    }

    public boolean isDebug() {
        return isDebug;
    }

    public IconStateCallBack getIconStateCallBack() {
        return iconStateCallBack;
    }

    public DialogShowStatusCallback getDialogShowStatusCallback() {
        return dialogShowStatusCallback;
    }

    public void cleanDialogCallBack() {
        dialogShowStatusCallback = null;
    }

    public String getSdkName() {
        return sdkName;
    }
}