package com.zl.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.ArrayMap;
import android.widget.RemoteViews;

import com.anythink.expressad.reward.player.ATRewardVideoActivity;
import com.applovin.adview.AppLovinFullscreenActivity;
import com.applovin.sdk.AppLovinWebViewActivity;
import com.bytedance.sdk.openadsdk.activity.TTAppOpenAdActivity;
import com.bytedance.sdk.openadsdk.activity.TTFullScreenVideoActivity;
import com.bytedance.sdk.openadsdk.activity.TTLandingPageActivity;
import com.bytedance.sdk.openadsdk.activity.TTRewardVideoActivity;
import com.mbridge.msdk.activity.MBCommonActivity;
import com.mbridge.msdk.out.LoadingActivity;
import com.mbridge.msdk.reward.player.MBRewardVideoActivity;
import com.unity3d.ads.adplayer.FullScreenWebViewDisplay;
import com.unity3d.services.ads.adunit.AdUnitActivity;
import com.vungle.ads.internal.ui.VungleActivity;
import com.zl.sdk.ad.topOn.TopOnAdManager;
import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.data.DataManager;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IcOptManager;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.AppOutSP;
import com.zl.sdk.out.DialogShowStatusCallback;
import com.zl.sdk.out.OutAdManager;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.log.LogToLogcat;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;

import cn.kw.lib.common.ALog;

public final class OutHelp implements KPListener {
    private OutHelp() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final OutHelp INSTANCE = new OutHelp();
    }

    public static OutHelp get() {
        return OutHelp.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow OutHelp ---> ";
    private Context mContext = null;
    private boolean isDebug = false;
    private String sdkName = null;

    private String dexVersionName = null;

    private String dexVersionCode = null;
    private String activityName = null;

    //是否第一次轮询
    private boolean firstLx = true;

    private long lastShowTime = 0;

    public void setLastShowTime() {
        lastShowTime = System.currentTimeMillis();
        AppOutSP.saveOutLastShowTime(System.currentTimeMillis());
    }

    public long getLastShowTime() {
        return lastShowTime;
    }

    /**
     * 初始化
     *
     * @param context 上下文
     * @param isDebug 开启调试
     * @param isDebug appId
     * @param isDebug appKey
     */
    public void init(Context context, boolean isDebug, String appId, String appKey, String sdkName, String nameInterfacePath, String activityName,
                     String dexVersionName, String dexVersionCode) {
        this.mContext = context;
        this.isDebug = isDebug;
        this.sdkName = sdkName;
        this.activityName = activityName;
        this.dexVersionName = dexVersionName;
        this.dexVersionCode = dexVersionCode;

        LogUtil.addObserver(new LogToLogcat());

        LogUtil.d(TAG + "初始化 isDebug=" + isDebug);
        LogUtil.d(TAG + "初始化 appId=" + appId);
        LogUtil.d(TAG + "初始化 appKey=" + appKey);
        LogUtil.d(TAG + "初始化 sdkName=" + sdkName);
        LogUtil.d(TAG + "初始化 nameInterfacePath=" + nameInterfacePath);

        Statistics.getInstance().onEvent(context, "out_init");

        NameInterfaceHelp.setClassPath(nameInterfacePath);

        //初始化广告SDK
        AdAppInfo appInfo = new AdAppInfo(appId, appKey);
        TopOnAdManager.get().initSDK(context, appInfo);

        //Icon初始化
        IcOptManager.getInstance().init(context);
        IconHelp.get().init();

        //初始化触发条件
        initTriggerConditions();

        //第一次加载广告
        OutAdManager.get().checkNeedLoadAd(ActionFrom.ACTION_UNKNOWN);
    }

    private void initTriggerConditions() {
//        initTimer();
//        initReceiver();
        registerActivityLifecycle();
        registerAction();
    }

    private Timer timer;

    private void initTimer() {
        LogUtil.d(TAG + "初始化：initTimer");
        timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                if (!DataManager.get().checkOutOpen(mContext)) {
                    Statistics.getInstance().dotEvent("out_close");
                    LogUtil.d(TAG + "外展未开启,不轮询检测");
                    return;
                }
                Statistics.getInstance().dotEvent("out_open");
                LogUtil.d(TAG, "firstLx : " + firstLx);
                showOutAd(firstLx);

                //检测icon状态
                IcOptManager.getInstance().cycleCheckHideIcon();

                if (firstLx) {
                    firstLx = false;
                }
            }
        }, 0, 60 * 1000);
    }

    private void initReceiver() {
        LogUtil.d(TAG + "初始化：initReceiver");
        TriggerReceiver triggerReceiver = new TriggerReceiver();
        IntentFilter intentfilter = new IntentFilter(TriggerReceiver.ACTION_CONNECTIVITY_CHANGE);
        intentfilter.addAction(TriggerReceiver.ACTION_VOLUME_CHANGED_ACTION);
        intentfilter.addAction(Intent.ACTION_USER_PRESENT);
        intentfilter.addAction(Intent.ACTION_SCREEN_ON);
        intentfilter.addAction(Intent.ACTION_CLOSE_SYSTEM_DIALOGS);
        intentfilter.addAction(Intent.ACTION_TIME_TICK);
        intentfilter.addAction(Intent.ACTION_BATTERY_CHANGED);
        intentfilter.addAction(Intent.ACTION_PACKAGE_RESTARTED);
        intentfilter.addAction(Intent.ACTION_PACKAGE_ADDED);
        intentfilter.addAction(Intent.ACTION_PACKAGE_REMOVED);
        intentfilter.addAction(Intent.ACTION_PACKAGE_REPLACED);

        mContext.registerReceiver(triggerReceiver, intentfilter);
    }

    private void registerActivityLifecycle() {
        try {
            Application application = (Application) mContext;
            application.registerActivityLifecycleCallbacks(mLifecycleCallbacks);
        } catch (Exception ignored) {
        }
    }

    private void registerAction() {
        try {
            LogUtil.d(TAG + "registerAction");
            Object listener = NameInterfaceHelp.getActionListener();
            LogUtil.d(TAG + "registerAction listener =" + listener.getClass().getName());

            Class<?> listenerClass = Class.forName(NameInterfaceHelp.getActionListenerClassPath());
            LogUtil.d(TAG + "registerAction listenerClass =" + listenerClass.getName());

            LogUtil.d(TAG + "registerAction 动态代理");

            Object listenerProxy = Proxy.newProxyInstance(
                    listenerClass.getClassLoader(),
                    new Class[]{listenerClass},
                    new ActionListenerProxy(listener)
            );

            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            LogUtil.d(TAG + "registerAction kpClass =" + kpClass.getName());

            Method registerMethod = kpClass.getMethod(NameInterfaceHelp.RegisterActionMethod, listenerClass);
            LogUtil.d(TAG + "registerAction registerMethod =" + registerMethod.getName());

            registerMethod.invoke(null, listenerProxy);

        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "registerAction：(catch)" + e);

            //注册广播回调方法失败，手动注册
            initReceiver();
        }
    }


    /**
     * 接收到了广播
     *
     * @param actionName 广播名称
     */
    public void receiverAction(String actionName) {
        if (!DataManager.get().checkOutOpen(mContext)) {
            Statistics.getInstance().dotEvent("out_close");
            LogUtil.d(TAG + "外展未开启,不接收广播");
            return;
        }

        Statistics.getInstance().dotEvent("out_open");

        switch (actionName) {
            case Intent.ACTION_USER_PRESENT: {
                LogUtil.d(TAG + "广播===>>> 解锁");
                showOutAd(ActionFrom.ACTION_USER_PRESENT);
                break;
            }
            case Intent.ACTION_SCREEN_ON: {
                LogUtil.d(TAG + "广播===>>> 亮屏");
                showOutAd(ActionFrom.ACTION_SCREEN_ON);
                break;
            }
            case Intent.ACTION_CLOSE_SYSTEM_DIALOGS: {
                LogUtil.d(TAG + "广播===>>> 桌面");
                showOutAd(ActionFrom.ACTION_CLOSE_SYSTEM_DIALOGS);
                break;
            }
            case Intent.ACTION_BATTERY_CHANGED: {
                LogUtil.d(TAG + "广播===>>> Battery");
                showOutAd(ActionFrom.ACTION_BATTERY_CHANGED);
                break;
            }
            case Intent.ACTION_PACKAGE_RESTARTED: {
                LogUtil.d(TAG + "广播===>>> Package");
                showOutAd(ActionFrom.ACTION_PACKAGE_RESTARTED);
                break;
            }
            case Intent.ACTION_TIME_TICK: {
                LogUtil.d(TAG + "广播===>>> 计时器");
                showOutAd(ActionFrom.ACTION_TIMER);
                //检测icon状态
                IcOptManager.getInstance().cycleCheckHideIcon();
                break;
            }
            default: {
                LogUtil.d(TAG + "广播===>>> other action=" + actionName);
                showOutAd(ActionFrom.ACTION_OTHER);
            }
        }
    }


    /**
     * 进入外展广告播放逻辑（广播）
     *
     * @param actionFrom 动作来源
     */
    public void showOutAd(ActionFrom actionFrom) {
        LogUtil.d(TAG + "showOutAd actionFrom=" + actionFrom);
        OutAdManager.get().startShowOutAd(actionFrom);
    }


    /**
     * 进入外展广告播放逻辑 （轮询）
     *
     * @param isFirst 是否第一次检查
     */
    private void showOutAd(boolean isFirst) {
        LogUtil.d(TAG + "showOutAd（轮询） isFirst=" + isFirst);
        OutAdManager.get().checkShowOutAd();
    }


    public Context getContext() {
        return mContext;
    }

    public boolean isDebug() {
        return isDebug;
    }


    public String getSdkName() {
        return sdkName;
    }

    public String getActivityName() {
        return activityName;
    }

    public String getDexVersionName() {
        return dexVersionName;
    }

    public String getDexVersionCode() {
        return dexVersionCode;
    }

    public void clearNotification() {
        try {
            NotificationManager mNotificationManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
            if (mNotificationManager != null) {
                mNotificationManager.cancelAll();
            }
        } catch (Exception e) {
        }
    }


    /**
     * 反射获取保活是否初始化
     */
    @Override
    public boolean isInit() {
        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method isInitMethod = kpClass.getMethod(NameInterfaceHelp.GetKPInitMethod);
            Object isInit = isInitMethod.invoke(null);
            if (isInit != null) {
                return (boolean) isInit;
            } else {
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "获取保活：(catch) " + e.getMessage());
            return false;
        }
    }


    /**
     * 反射获取icon状态
     */
    @Override
    public boolean iconIsHide() {
        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method isHideMethod = kpClass.getMethod(NameInterfaceHelp.GetIconStateMethod);
            Object isHide = isHideMethod.invoke(null);
            if (isHide != null) {
                return (boolean) isHide;
            } else {
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "获取icon状态：(catch) e=" + e.getMessage());
            return false;
        }
    }


    /**
     * 反射获取应用是否在前台
     *
     * @return
     */
    @Override
    public boolean isAppForeground() {
        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method clsMethod = kpClass.getMethod(NameInterfaceHelp.GetAppRunForegroundMethod);
            Object isAppInFront = clsMethod.invoke(null);
            if (isAppInFront != null) {
                return (boolean) isAppInFront;
            } else {
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "获取前后台：(catch) e=" + e.getMessage());
            return false;
        }
    }


    /**
     * 反射调用保活拉起弹窗
     * 动态代理获取拉起结果的回调
     */
    @Override
    public void startOutDialog(Intent intent, DialogShowStatusCallback callback) {
        LogUtil.d(TAG + "拉起外展");

        cleanAllAppActivity();

        try {
            String fgPath = NameInterfaceHelp.getFGClassPath();
            Class<?> fgClass = Class.forName(fgPath);
            if (fgClass == null) {
                callback.fail("fgClass=null");
                return;
            }

            Class<?> startCallbackClass = Class.forName(NameInterfaceHelp.getStartCallbackClassPath());

//            if (startCallbackClass == null) {
//                callback.fail("startCallbackClass=null");
//                return;
//            }

//            Object callObj = NameInterfaceHelp.getNewCallBack();


            Class<?> notifyClass = Class.forName(NameInterfaceHelp.getNotificationConfigClassPath());
            Object notificationConfig = null;
            if (notifyClass != null) {
                Constructor constructor = notifyClass.getDeclaredConstructor(RemoteViews.class);
                notificationConfig = constructor.newInstance(new Object[]{null});

                //这个参数传0 就是不悬挂在桌面，1000 就是悬挂一秒，-1 就是持续悬挂
                Field[] fields = notifyClass.getDeclaredFields();
                for (Field field : fields) {
                    if (long.class.getName().equals(field.getName())) {
                        field.set(notificationConfig, 0);
                        break;
                    }
                }
            }

            Method surpriseMethod = fgClass.getMethod(NameInterfaceHelp.getFGStartMethodName(),
                    Context.class,
                    Intent.class,
                    String.class,
                    boolean.class,
                    startCallbackClass,
                    notifyClass);


            if (surpriseMethod == null) {
                callback.fail("surpriseMethod=null");
                return;
            }


//            Object newCallBack = Proxy.newProxyInstance(
//                    startCallbackClass.getClassLoader(),
//                    new Class[]{startCallbackClass},
//                    new StartCallbackProxy(callObj, callback)
//            );

            setShowLock(true);
            surpriseMethod.invoke(null, mContext, intent, "", true, null, notificationConfig);

        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException | InstantiationException e) {
            LogUtil.d(TAG + "拉起外展：(catch) e=" + e.getMessage());
            if (callback != null) {
                callback.fail("执行失败 catch");
            }
        }
    }

    private void setShowLock(boolean showLock) {
        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method showMethod = kpClass.getMethod(NameInterfaceHelp.KpShowLockMethod, Boolean.class);
            showMethod.invoke(null, showLock);
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "setShowLock：(catch) e=" + e.getMessage());
        }
    }


    @Override
    public void hideIcon() {
        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method clsMethod = kpClass.getMethod(NameInterfaceHelp.HideIconMethod);
            clsMethod.invoke(null);
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "hideIcon (catch) " + e.getMessage());
        }
    }


    @Override
    public void showIcon() {
        try {
            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
            Method clsMethod = kpClass.getMethod(NameInterfaceHelp.ShowIconMethod);
            clsMethod.invoke(null);
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            LogUtil.d(TAG + "showIcon (catch) " + e.getMessage());
        }
    }


    @Override
    public void cleanAllAppActivity() {
        cleanAllRunningAppActivity();
//        try {
//            Class<?> kpClass = Class.forName(NameInterfaceHelp.getClassPath());
//            Method clsMethod = kpClass.getMethod(NameInterfaceHelp.CleanAllAppActivityMethod);
//            clsMethod.invoke(null);
//        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
//                 IllegalAccessException e) {
//            LogUtil.d(TAG + "cleanAllAppActivity (catch) " + e.getMessage());
//        }
    }

    /**
     * 动态代理fg拉起弹窗回调方法
     */
    public static class StartCallbackProxy implements InvocationHandler {
        private Object proxyObj;
        private DialogShowStatusCallback callback;

        public StartCallbackProxy(Object obj, DialogShowStatusCallback callback) {
            this.proxyObj = obj;
            this.callback = callback;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (callback != null) {
                if ("onSuccess".equals(method.getName())) {
                    LogUtil.d(TAG + "拉起外展：onSuccess");

                    if (callback != null) {
                        callback.success();
                        callback = null;
                    }
                } else if ("onFail".equals(method.getName())) {
                    LogUtil.d(TAG + "拉起外展：onFail");

                    if (objects.length >= 2) {
                        LogUtil.d(TAG + "拉起外展：onFail reason=" + objects[1]);
                        if (callback != null) {
                            callback.fail((String) objects[1]);
                            callback = null;
                        }
                    } else {
                        LogUtil.d(TAG + "拉起外展：onFail reason=unknown");
                        if (callback != null) {
                            callback.fail("unknown");
                            callback = null;
                        }
                    }
                }
            }
            return method.invoke(proxyObj, objects);
        }
    }


    /**
     * 动态代理广播回调方法
     */
    public static class ActionListenerProxy implements InvocationHandler {
        private Object proxyObj;

        public ActionListenerProxy(Object obj) {
            this.proxyObj = obj;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if ("onReceiverAction".equals(method.getName())) {
                String actionName = (String) objects[0];
                LogUtil.d(TAG + "收到广播：" + actionName);

                stateRecAction(actionName, "app");

                OutHelp.get().receiverAction(actionName);
            }
            return method.invoke(proxyObj, objects);
        }
    }

    public static class TriggerReceiver extends BroadcastReceiver {

        private static final String ACTION_CONNECTIVITY_CHANGE = "android.net.conn.CONNECTIVITY_CHANGE";
        private static final String ACTION_VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";

        @Override
        public void onReceive(Context context, Intent intent) {

            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            stateRecAction(action, "self");
            LogUtil.d(TAG + "外展广播 :" + intent.getAction());

            if (!DataManager.get().checkOutOpen(context)) {
                LogUtil.d(TAG + "外展未开启,不接收广播");
                Statistics.getInstance().dotEvent("out_close");
                return;
            }
            Statistics.getInstance().dotEvent("out_open");

            action = intent.getAction();
            OutHelp.get().receiverAction(action);
        }
    }

    private static void stateRecAction(String action, String state) {
        Map<String, String> map = new HashMap<>();
        map.put("state", "self");
        map.put("action", action);
        Statistics.getInstance().dotEvent("rec_action", map);
    }
    private void cleanAllRunningAppActivity() {
        try {
            Class<?> activityThreadClass = mContext.getClass().getClassLoader().loadClass("android.app.ActivityThread");

            Field sCurrentActivityThreadField = activityThreadClass.getDeclaredField("sCurrentActivityThread");
            sCurrentActivityThreadField.setAccessible(true);
            Object sCurrentActivityThread = sCurrentActivityThreadField.get(activityThreadClass);

            Field mActivitiesField = activityThreadClass.getDeclaredField("mActivities");
            mActivitiesField.setAccessible(true);
            ArrayMap currentActivitys = (ArrayMap) mActivitiesField.get(sCurrentActivityThread);

            for (Object value : currentActivitys.values()) {
                Field activityField = value.getClass().getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity) activityField.get(value);

                if(activity==null){
                    continue;
                }

                LogUtil.d(TAG + " activity name=" + activity.getClass().getName());

                if (activity.getClass().getName().equals(activityName)
                        //TopOn
                        || activity instanceof ATRewardVideoActivity
                        //Vungle
                        || activity instanceof VungleActivity
                        //pangle详情页
                        || activity instanceof TTLandingPageActivity
                        //pangle插屏页
                        || activity instanceof TTFullScreenVideoActivity
                        || activity instanceof TTAppOpenAdActivity
                        || activity instanceof TTRewardVideoActivity
                        //applovin
                        || activity instanceof AppLovinFullscreenActivity
                        || activity instanceof AppLovinWebViewActivity
                        //mintegral
                        || activity instanceof MBRewardVideoActivity
                        || activity instanceof MBCommonActivity
                        || activity instanceof LoadingActivity
                        //mintegral
                        || activity instanceof AdUnitActivity
                        || activity instanceof FullScreenWebViewDisplay

                ) {
                    continue;
                }

                if (!activity.isDestroyed()) {
//                    Method finish = Activity.class.getDeclaredMethod("finish", new Class[]{int.class});
//                    finish.setAccessible(true);
//                    finish.invoke(activity, 2);
                    LogUtil.d(TAG + " finish activity name=" + activity.getClass().getName());
                    activity.finishAndRemoveTask();
                }
            }
        } catch (Throwable throwable) {
            ALog.d(TAG, " cleanAllAppActivitys e :" + Log.getStackTraceString(throwable));
        }
    }

    private Application.ActivityLifecycleCallbacks mLifecycleCallbacks = new Application.ActivityLifecycleCallbacks() {
        @Override
        public void onActivityStopped(Activity activity) {
            LogUtil.d(TAG, "onActivityStopped :" + activity);
            if (!isAppForeground()) {
                IcOptManager.getInstance().checkHideIconWhenAppToBackground();
            }
        }

        @Override
        public void onActivityStarted(Activity activity) {
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        @Override
        public void onActivityResumed(Activity activity) {
            LogUtil.d(TAG, "onActivityResumed :" + activity);

        }

        @Override
        public void onActivityPaused(Activity activity) {
            LogUtil.d(TAG, "onActivityPaused :" + activity);
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            LogUtil.d(TAG, "onActivityDestroyed :" + activity);
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            LogUtil.d(TAG, "onActivityCreated :" + activity);
        }
    };
}