package com.zl.sdk.out.deepNightModle;

import android.util.Log;

import com.zl.sdk.ad.AdDataManager;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.out.AppOutSP;
import com.zl.sdk.out.CheckHelper;
import com.zl.sdk.util.LogUtil;

import java.util.Calendar;

public class DeepNight {
    private static boolean isOpen = true;
    private static int start_time = 2;
    private static int end_time = 5;

    private static boolean deepNightRunning = false;

    /**
     * 深夜模式是否开启
     *
     * @return
     */
    public static boolean deepNightIsOpen() {
        return isOpen;
    }

    /**
     * 深夜模式能否开始
     *
     * @return
     */
    public static boolean checkDeepNightRunning() {
//        if (deepNightRunning) {
//            deepNightRunning = checkTime() && checkAdTimes();
//        } else {
//            deepNightRunning = deepNightIsOpen() && checkTime() && checkAdTimes();
//        }
        return deepNightIsOpen() && checkTime();
    }


    /**
     * 深夜模式 检查当前时间
     *
     * @return
     */
    private static boolean checkTime() {
        int curr_hour = Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
        LogUtil.d("OutShow curr_hour =" + curr_hour);
        return start_time <= curr_hour && curr_hour < end_time;
    }

    /**
     * 深夜模式 检查上次熄屏时间
     *
     * @return
     */
    private static boolean checkLastScreenOffTime() {
        return System.currentTimeMillis() - AppOutSP.getLastScreenOffTime() >= 10 * 60 * 1000L;
    }


    private static boolean checkAdTimes() {
        return CheckHelper.checkCanShowAdByTimesFromAdData(AdDataManager.get().getShowAdData(), -1, EventUtils.SCENES_SHOW);
    }
}
