package com.zl.sdk.ad.interstitial;

import android.app.Activity;

import com.anythink.core.api.ATAdInfo;
import com.anythink.core.api.AdError;
import com.anythink.interstitial.api.ATInterstitial;
import com.anythink.interstitial.api.ATInterstitialListener;
import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.AdBean;
import com.zl.sdk.event.AdsParamsInfo;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.ReportBean;
import com.zl.sdk.util.LogUtil;

import java.util.Date;

public class TopOnInterstitialAdManager implements ATInterstitialListener {

    private AdBean adBean;
    private ATInterstitial interstitialAd;
    private TopOnAdInterstitialCallBack adInterstitialCallBack;
    private long requestTime;
    private String netWorkName;

    public TopOnInterstitialAdManager() {
    }

    public TopOnInterstitialAdManager setAdBean(AdBean adBean) {
        this.adBean = adBean;
        return this;
    }

    public boolean isReady() {
        return null != this.interstitialAd && this.interstitialAd.isAdReady();
    }

    public void showInterstitialAd(Activity activity) {
        if (isReady()) {
            interstitialAd.show(activity);
        }
    }

    public void loadInterstitialAd(TopOnAdInterstitialCallBack adInterstitialCallBack) {
        String adUnitId = adBean.getAdUnitId();
        if (null == interstitialAd) {
            interstitialAd = new ATInterstitial(OutHelp.get().getContext(), adUnitId);
            interstitialAd.setAdListener(this);
        } else {
            if (!adBean.getAdUnitId().equals(adUnitId)) {
                destroy();
                interstitialAd = new ATInterstitial(OutHelp.get().getContext(), adUnitId);
                interstitialAd.setAdListener(this);
            }
        }
        interstitialAd.load();
        this.adInterstitialCallBack = adInterstitialCallBack;
        requestTime = System.currentTimeMillis();

        EventUtils.statAdReport(getReportRequestBean());
    }

    public void destroy() {
        try {
            if (interstitialAd != null) {
                interstitialAd = null;
            }
        } catch (Exception e) {
        }
    }

    public ReportBean getReportBean(ATAdInfo adInfo, String errorMsg) {
        ReportBean bean = new ReportBean();
        bean.adtype = AdsParamsInfo.INTERSTITIAL;
        if (null != adBean) {
            bean.ad_position = adBean.getAdPosition();
            bean.adUnitId = adBean.getAdUnitId();
            bean.ad_scenes = adBean.getAdScenes();
        }
        try {
            if (null != adInfo) {
                bean.platform = adInfo.getNetworkPlacementId();
                bean.source = adInfo.getAdNetworkType();
            } else if (null != netWorkName) {
                bean.source = netWorkName;
                netWorkName = null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        bean.ad_msg_error = errorMsg;
        bean.time = (new Date()).getTime();
        return bean;
    }

    private ReportBean getReportRequestBean() {
        ReportBean bean = new ReportBean();
        bean.eventid = AdsParamsInfo.F_REQUEST;
        bean.adtype = AdsParamsInfo.INTERSTITIAL;
        if (null != adBean) {
            bean.ad_scenes = adBean.getAdScenes();
            bean.ad_position = adBean.getAdPosition();
            bean.adUnitId = adBean.getAdUnitId();
        }
        return bean;
    }

    @Override
    public void onInterstitialAdLoaded() {
        LogUtil.d("anythink cp 加载完成");

        if (interstitialAd == null) {
            return;
        }

        adInterstitialCallBack.onAdLoaded(adBean.getAdUnitId(), adBean.getAdScenes(), adBean.getAdData(), interstitialAd);
        if (interstitialAd.checkValidAdCaches() == null || interstitialAd.checkValidAdCaches().isEmpty()) {
            EventUtils.statAdLoaded(getReportBean(null, null), requestTime);
        } else {
            EventUtils.statAdLoaded(getReportBean(interstitialAd.checkValidAdCaches().get(0), null), requestTime);
        }
        //记录广告返回的时间，供上报缓存时间和价格
        requestTime = System.currentTimeMillis();
    }

    @Override
    public void onInterstitialAdLoadFail(AdError adError) {
        LogUtil.d("anythink cp 加载失败");
        StringBuilder builder = new StringBuilder();
        builder.append("error info : code=").append(adError.getCode())
                .append(" msg=").append(adError.getDesc())
                .append(" all=").append(adError.getFullErrorInfo());
        adInterstitialCallBack.onAdLoadFailed(adBean.getAdUnitId(), builder.toString());
        EventUtils.statAdLoadFail(getReportBean(null, builder.toString()), requestTime);
    }

    @Override
    public void onInterstitialAdClicked(ATAdInfo atAdInfo) {
        LogUtil.d("anythink cp 点击");
        adInterstitialCallBack.onAdClicked(adBean.getAdUnitId());
        EventUtils.statAdClick(getReportBean(atAdInfo, null));
    }

    @Override
    public void onInterstitialAdShow(ATAdInfo atAdInfo) {
        LogUtil.d("anythink cp 广告播放");

        adInterstitialCallBack.onAdDisplayed(adBean.getAdUnitId(), adBean.getAdData());

        EventUtils.statAdExpose(getReportBean(atAdInfo, null));

        adInterstitialCallBack.onAdRevenuePaid(adBean.getAdUnitId());

//        AdjustAdRevenue adjustAdRevenue = new AdjustAdRevenue("TopOn");
//        adjustAdRevenue.setRevenue(atAdInfo.getEcpm(), "USD");
//        adjustAdRevenue.setAdRevenueNetwork(atAdInfo.getAdNetworkType());
//        adjustAdRevenue.setAdRevenueUnit(atAdInfo.getEcpmPrecision());
//        adjustAdRevenue.setAdRevenuePlacement(atAdInfo.getCountry());
//        Adjust.trackAdRevenue(adjustAdRevenue);

        ReportBean reportBean = getReportBean(atAdInfo, null);
        reportBean.valueMicros = atAdInfo.getEcpmLevel();
        reportBean.currencyCode = "USD";
        reportBean.precision = String.valueOf(atAdInfo.getEcpm());

        EventUtils.statAdPaidEven(reportBean, requestTime);
    }

    @Override
    public void onInterstitialAdClose(ATAdInfo atAdInfo) {
        LogUtil.d("anythink cp 关闭");
        adInterstitialCallBack.onAdHidden(adBean.getAdUnitId());
        EventUtils.statAdClose(getReportBean(atAdInfo, null));
    }

    @Override
    public void onInterstitialAdVideoStart(ATAdInfo atAdInfo) {
        LogUtil.d("anythink cp VideoStart");
        adInterstitialCallBack.adVideoStart(adBean.getAdUnitId());
    }

    @Override
    public void onInterstitialAdVideoEnd(ATAdInfo atAdInfo) {
        LogUtil.d("anythink cp VideoEnd");
        adInterstitialCallBack.adVideoEnd(adBean.getAdUnitId());
    }

    @Override
    public void onInterstitialAdVideoError(AdError adError) {
        StringBuilder builder = new StringBuilder();
        builder.append("error info : code=").append(adError.getCode())
                .append(" msg=").append(adError.getDesc())
                .append(" all=").append(adError.getFullErrorInfo());
        adInterstitialCallBack.onAdDisplayFailed(adBean.getAdUnitId(), builder.toString());
        EventUtils.statDisplayFail(getReportBean(null, builder.toString()));

        LogUtil.d("anythink cp VideoError " + builder);
    }
}