package com.zl.sdk.out;

import android.content.Context;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.format.DateUtils;

import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.OutAdData;
import com.zl.sdk.event.DialogFailReason;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;

import java.util.Calendar;

public class CheckHelper {
    private static final String TAG = "OutShow CheckHelper --> ";

    /**
     * 检查当前场景是否能播放外展广告
     * 解锁/回到桌面 触发展示的外展广告
     */
    public static boolean checkAdCanShowByScene(int actionState, String scenes) {
        if ((actionState == ActionFrom.ACTION_TIMER.getAction())
                && !AppOutUtils.isScreenOn()) {
            LogUtil.d(TAG + "（场景检查）手机未亮屏，不能展示");
            EventUtils.staDialogFail(DialogFailReason.SCREEN_OFF, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (isTelephonyCalling()) {
            LogUtil.d(TAG + "（场景检查）通话中，不能展示");
            EventUtils.staDialogFail(DialogFailReason.CALLING, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        if (OutHelp.get().isAppForeground()) {
            LogUtil.d(TAG + "（场景检查）应用在前台，不能展示");
            EventUtils.staDialogFail(DialogFailReason.IS_FOREGROUND, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
            return false;
        }

        LogUtil.d(TAG + "（场景检查）能展示");
        return true;
    }

    /**
     * 检查广告数据是否可以播放
     */
    public static boolean checkCanShowAdByTimesFromAdData(OutAdData.NormalAdData data, int actionState, String scenes) {

        long curTime = System.currentTimeMillis();
        int homeInterstitialAdDayShowCount = AppOutSP.getOutInterstitialAdDayShowCount();
        int homeDayShowCount = homeInterstitialAdDayShowCount;

        if (!isSameDay(curTime, AppOutSP.getOutLastShowTime())) {
            LogUtil.d(TAG + "（次数检查）上次播放不是今天 重置播放次数");
            homeDayShowCount = 0;
            homeInterstitialAdDayShowCount = 0;
            AppOutSP.saveOutInterstitialAdDayShowCount(0);
        }

        if (OutHelp.get().iconIsHide()) {
            LogUtil.d(TAG + "（次数检查）总次数 （icon隐藏） 当前次数=" + homeDayShowCount);
            LogUtil.d(TAG + "（次数检查）总次数 （icon隐藏） 配置次数=" + data.showTimeHide);
            if (homeDayShowCount >= data.showTimeHide) {
                LogUtil.d(TAG + "（次数检查）总次数 （icon隐藏） 超过播放次数");
                EventUtils.staDialogFail(DialogFailReason.COUNT_EXCEEDS, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        } else {
            LogUtil.d(TAG + "（次数检查）总次数 （icon未隐藏） 当前次数=" + homeDayShowCount);
            LogUtil.d(TAG + "（次数检查）总次数 （icon未隐藏） 配置次数=" + data.showCount);
            if (homeDayShowCount >= data.showCount) {
                LogUtil.d(TAG + "（次数检查）总次数 （icon未隐藏） 超过播放次数");
                EventUtils.staDialogFail(DialogFailReason.COUNT_EXCEEDS, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        }

        if (OutHelp.get().iconIsHide()) {
            LogUtil.d(TAG + "（次数检查）插屏 （icon隐藏） 当前次数=" + homeInterstitialAdDayShowCount);
            LogUtil.d(TAG + "（次数检查）插屏 （icon隐藏） 配置次数=" + data.showTimesHideForAdId);
            if (homeInterstitialAdDayShowCount >= data.showTimesHideForAdId) {
                LogUtil.d(TAG + "（次数检查）插屏 （icon隐藏） 超过播放次数");
                EventUtils.staDialogFail(DialogFailReason.CP_EXCEEDS, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        } else {
            LogUtil.d(TAG + "（次数检查）插屏 （icon未隐藏） 当前次数=" + homeInterstitialAdDayShowCount);
            LogUtil.d(TAG + "（次数检查）插屏 （icon未隐藏） 配置次数=" + data.showTimes);
            if (homeInterstitialAdDayShowCount >= data.showTimes) {
                LogUtil.d(TAG + "（次数检查）插屏 （icon未隐藏） 超过播放次数");
                EventUtils.staDialogFail(DialogFailReason.CP_EXCEEDS, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
                return false;
            }
        }

        LogUtil.d(TAG + "（次数检查）可播放");
        return true;
    }


    public static boolean checkCanShowAdByInterValFromAdData(OutAdData.NormalAdData data, int actionState, String scenes) {
        long curTime = System.currentTimeMillis();
        long showIntervalTime = Math.abs(curTime - OutHelp.get().getLastShowTime());

        LogUtil.d(TAG + "（次数检查）上次展示时间=" + OutHelp.get().getLastShowTime());

        long spaceTime;

        if (OutHelp.get().iconIsHide()) {
            spaceTime = data.intervalHide * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "（次数检查）间隔时间（icon隐藏）=" + spaceTime);
        } else {
            spaceTime = data.interval * DateUtils.SECOND_IN_MILLIS;
            LogUtil.d(TAG + "（次数检查）间隔时间（icon未隐藏）=" + spaceTime);
        }


        if (showIntervalTime < spaceTime) {
            LogUtil.d(TAG + "（次数检查）未到间隔时间 不能播放");
            EventUtils.staDialogFail(DialogFailReason.INTERVAL_TIME, actionState, scenes, EventUtils.DIALOG_TYPE_AD);
            return false;
        }
        LogUtil.d(TAG + "（时间间隔检查）可播放");
        return true;
    }

    public static boolean isSameDay(long time1, long time2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTimeInMillis(time1);
        cal2.setTimeInMillis(time2);
        return cal1.get(Calendar.YEAR) == cal2.get(Calendar.YEAR) &&
                cal1.get(Calendar.DAY_OF_YEAR) == cal2.get(Calendar.DAY_OF_YEAR);
    }


    /**
     * 是否在通话中
     */
    public static boolean isTelephonyCalling() {
        Context context = OutHelp.get().getContext();
        AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
        boolean calling = (audioManager.getMode() == AudioManager.MODE_IN_CALL
                || audioManager.getMode() == AudioManager.MODE_IN_COMMUNICATION);
        LogUtil.d("监听是否在通话中 Calling=" + calling);
        return calling;
    }

    public static boolean isNetworkAvailable(final Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }
}