package com.zl.sdk.out.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;

import com.zl.sdk.OutHelp;
import com.zl.sdk.ad.AdManagerV2;
import com.zl.sdk.ad.OnInAdListener;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.util.AppOutUtils;
import com.zl.sdk.util.LogUtil;

import java.util.HashMap;
import java.util.Map;

public class DxActivity extends BaseActivity {
    private static final String TAG = "OutShow Dx ---> ";

    private long onceStayTime;

    private boolean hadStart = false;

    private Handler mainHandler = new Handler(Looper.getMainLooper());


    public DxActivity(Activity activity) {
        super(activity);
    }

    @Override
    public void onBeforeCreate(Bundle bundle) {
        hadStart = false;
    }

    @Override
    public void onAfterCreate(Bundle bundle) {
        LogUtil.d(TAG + "onCreate");
    }


    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }


    @Override
    public void onStart() {
        super.onStart();

        LogUtil.d(TAG + "onStart");

        if (hadStart) {
            close();
            return;
        }
        mainHandler.removeCallbacksAndMessages(null);
        mainHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                execute();
                hadStart = true;
            }
        }, 500);
    }

    @Override
    public void onResume() {
        super.onResume();
        LogUtil.d(TAG + "onResume  hashCode=" + hashCode());
    }

    @Override
    public void onPause() {
        super.onPause();
        LogUtil.d(TAG + "onPause hashCode=" + hashCode());
    }

    @Override
    public void onStop() {
        super.onStop();
        LogUtil.d(TAG + "onStop hashCode=" + hashCode());
    }

    @Override
    public void onDestroy() {
        LogUtil.d(TAG + "onDestroy hashCode=" + hashCode());

        mainHandler.removeCallbacksAndMessages(null);
        AdManagerV2.get().removeListener();

        final long time = Math.abs(onceStayTime - System.currentTimeMillis());
        Map<String, Object> map = new HashMap<>();
        map.put("s_d_t", String.valueOf(time));
        Statistics.getInstance().onEvent(OutHelp.get().getContext(), EventUtils.OUT_DIALOG_EXPOSE_ONCE_STAY_TIME, null, map);
        super.onDestroy();
    }

    @Override
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        return false;
    }

    public void close() {
        try {
            activity.finish();
        } catch (Throwable e) {
            LogUtil.d(TAG + "close e=" + Log.getStackTraceString(e));
        }
    }

    public void finishAndRemoveTask() {
        activity.finishAndRemoveTask();
    }

    @Override
    public boolean beforeBackPressed() {
        close();
        return true;
    }


    private void statSLKStart(boolean isHide) {
        Map<String, Object> map = new HashMap<>();
        map.put("hide", String.valueOf(isHide));
        map.put("screen_state", String.valueOf(AppOutUtils.isScreenOn()));
        map.put("foreground", OutHelp.get().isAppForeground());
        Statistics.getInstance().dotEvent(activity, "slk_start", "", map);
    }

    private void execute() {
        startShowDialog();
    }

    private void startShowDialog() {
        statSLKStart(IconHelp.get().isIconHide());

        Window window = activity.getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_SECURE);

        FrameLayout rootView = new FrameLayout(activity);
        activity.setContentView(rootView);

        onceStayTime = System.currentTimeMillis();

        AdManagerV2.get().showAd(activity, new OnInAdListener() {
            @Override
            public void onCloseAd() {
                LogUtil.d(TAG + "onCloseAd");
                close();
            }

            @Override
            public void onShow() {
                LogUtil.d(TAG + "onShow");
            }

            @Override
            public void showFail() {
                LogUtil.d(TAG + "showFail");
                close();
            }
        });
    }
}
