package com.zl.sdk.out.ui;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;

import com.zl.sdk.Config;
import com.zl.sdk.OutHelp;
import com.zl.sdk.bean.RemindersInfo;
import com.zl.sdk.bean.WeatherAdData;
import com.zl.sdk.event.EventUtils;
import com.zl.sdk.event.statistics.Statistics;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.DxManager;
import com.zl.sdk.util.LogUtil;

import java.util.HashMap;
import java.util.Map;

public class DxActivity extends BaseActivity {
    private static final String TAG = "OutShow Dx ---> ";

    private Intent intent = null;
    private RemindersInfo remindersInfo;
    private WeatherAdData.NormalAdData adData;

    private IView proxyView;

    private long onceStayTime;

    //activity生命周期中是否已经执行过execute()方法
    private boolean hasExecuteInLifeCycle = false;


    public DxActivity(Activity activity) {
        super(activity);
    }

    @Override
    public void onBeforeCreate(Bundle bundle) {
    }

    @Override
    public void onAfterCreate(Bundle bundle) {
        LogUtil.d(TAG + "onCreate");
    }


    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        LogUtil.d(TAG + "onNewIntent : " + hasExecuteInLifeCycle);
        if (!hasExecuteInLifeCycle) {
            execute();
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        LogUtil.d(TAG + "onStart :" + hasExecuteInLifeCycle + " hashCode=" + hashCode());

        if (!hasExecuteInLifeCycle) {
            execute();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        LogUtil.d(TAG + "onResume  hashCode=" + hashCode());
        if (proxyView != null) {
            proxyView.onResume();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        LogUtil.d(TAG + "onPause hashCode=" + hashCode());
        if (proxyView != null) {
            proxyView.onPause();
        }
    }

    @Override
    public void onStop() {
        hasExecuteInLifeCycle = false;
        super.onStop();
        LogUtil.d(TAG + "onStop hashCode=" + hashCode());
    }

    @Override
    public void onDestroy() {
        LogUtil.d(TAG + "onDestroy hashCode=" + hashCode());
        hasExecuteInLifeCycle = false;
        if (proxyView != null) {
            proxyView.onDestroy();
            proxyView = null;
        }

        final long time = Math.abs(onceStayTime - System.currentTimeMillis());
        Map<String, Object> map = new HashMap<>();
        map.put("s_d_t", String.valueOf(time));
        Statistics.getInstance().onEvent(OutHelp.get().getContext(), EventUtils.OUT_DIALOG_EXPOSE_ONCE_STAY_TIME, null, map);
        super.onDestroy();
    }

    @Override
    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        return false;
    }

    public void close() {
        if (IconHelp.get().isIconHide()) {
            LogUtil.d(TAG + "icon隐藏 退回到后台");
            if (proxyView != null) {
                proxyView.onDestroy();
                proxyView = null;
            }
            activity.moveTaskToBack(true);
        } else {
            LogUtil.d(TAG + "icon未隐藏 finish");
            if (proxyView != null) {
                proxyView.onDestroy();
                proxyView = null;
            }
            activity.finish();
        }
    }

    @Override
    public boolean beforeBackPressed() {
        close();
        return true;
    }


    private void statSLKStart(RemindersInfo remindersInfo, boolean isHide) {
        Map<String, Object> map = new HashMap<>();
        String type = "";
        if (remindersInfo != null) {
            type = String.valueOf(remindersInfo.reminderType);
        }
        map.put("type", type);
        map.put("hide", String.valueOf(isHide));
        Statistics.getInstance().dotEvent(activity, "slk_start", "", map);
    }

    private void execute() {
        hasExecuteInLifeCycle = true;
        checkIntent();
        startShowDialog();
    }

    private void checkIntent() {
        adData = null;
        remindersInfo = null;

        adData = (WeatherAdData.NormalAdData) DxManager.get().getOutAdData();
        LogUtil.d(TAG + "广告信息 =" + adData);

        remindersInfo = DxManager.get().getOutRemindersInfo();
        LogUtil.d(TAG + "弹窗信息 =" + remindersInfo);
    }

    private void startShowDialog() {
        statSLKStart(remindersInfo, IconHelp.get().isIconHide());

        if (remindersInfo == null) {
            LogUtil.d(TAG + "finish remindersInfo为空");
            close();
            return;
        }

        if (remindersInfo.reminderType != Config.REMINDER_TYPE_WEATHER_PURE_AD && IconHelp.get().isIconHide()) {
            LogUtil.d(TAG + "finish 不是纯广告并且隐藏了icon");
            close();
            return;
        }

        Window window = activity.getWindow();
        window.addFlags(WindowManager.LayoutParams.FLAG_SECURE);

        FrameLayout rootView = new FrameLayout(activity);
        activity.setContentView(rootView);

        onceStayTime = System.currentTimeMillis();

        LogUtil.d(TAG + "加载新的Dialog");
        proxyView = DialogFactory.createDialog(remindersInfo, adData);

        if (proxyView == null) {
            LogUtil.d(TAG + "finish 5 View=null");
            close();
            return;
        }

        proxyView.onCreate(activity, intent, rootView);
    }
}
