package com.zl.sdk.out;

import android.app.Activity;
import android.os.Build;

import com.zl.sdk.bean.RemindersInfo;
import com.zl.sdk.bean.WeatherAdData;

import java.util.Stack;

public class DxManager {
    private DxManager() {
    }

    private static class Holder {
        private static final DxManager INSTANCE = new DxManager();
    }

    public static DxManager get() {
        return DxManager.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow DxManager --> ";


    private RemindersInfo outRemindersInfo = null;
    private WeatherAdData.NormalAdData outAdData = null;

    public RemindersInfo getOutRemindersInfo() {
        return outRemindersInfo;
    }

    public void setOutRemindersInfo(RemindersInfo outRemindersInfo) {
        this.outRemindersInfo = outRemindersInfo;
    }

    public WeatherAdData.NormalAdData getOutAdData() {
        return outAdData;
    }

    public void setOutAdData(WeatherAdData.NormalAdData outAdData) {
        this.outAdData = outAdData;
    }


    private final Stack<Activity> appOutActivities = new Stack<Activity>();


    public boolean existAppOutActivities() {
        return !appOutActivities.isEmpty();
    }

    public Stack<Activity> getAppOutActivities() {
        return appOutActivities;
    }


    public void addActivity(Activity activity) {
        appOutActivities.push(activity);
    }

    public void removeActivity(Activity activity) {
        appOutActivities.remove(activity);
    }

    public void removeAllSLKActivity() {
        if (appOutActivities.isEmpty()) {
            return;
        }

        for (Activity activity : appOutActivities) {
            activity.finishAndRemoveTask();
        }

        appOutActivities.clear();
    }
}
