package com.zl.sdk;

import android.annotation.SuppressLint;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

import com.zl.sdk.ad.topOn.TopOnAdManager;
import com.zl.sdk.bean.AdAppInfo;
import com.zl.sdk.icon.IconHelp;
import com.zl.sdk.out.ActionFrom;
import com.zl.sdk.out.DialogShowStatusCallback;
import com.zl.sdk.out.OutAdManager;
import com.zl.sdk.util.LogUtil;
import com.zl.sdk.util.log.LogToLogcat;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Timer;
import java.util.TimerTask;

public final class OutHelp implements KPListener {
    private OutHelp() {
    }

    private static class Holder {
        @SuppressLint("StaticFieldLeak")
        private static final OutHelp INSTANCE = new OutHelp();
    }

    public static OutHelp get() {
        return OutHelp.Holder.INSTANCE;
    }

    private static final String TAG = "OutShow OutHelp ---> ";
    private Context mContext = null;
    private boolean isDebug = false;
    private String sdkName = null;

    //是否第一次轮询
    private boolean firstLx = true;


    /**
     * 初始化
     *
     * @param context 上下文
     * @param isDebug 开启调试
     * @param isDebug appId
     * @param isDebug appKey
     */
    public void init(Context context, boolean isDebug, String appId, String appKey, String sdkName) {
        this.mContext = context;
        this.isDebug = isDebug;
        this.sdkName = sdkName;

        LogUtil.addObserver(new LogToLogcat());

        //初始化广告SDK
        AdAppInfo appInfo = new AdAppInfo(appId, appKey);
        TopOnAdManager.get().initSDK(context, appInfo);
        //Icon初始化
        IconHelp.get().init();
        //初始化触发条件
        initTriggerConditions();
    }

    private void initTriggerConditions() {
        initTimer();
        initReceiver();
    }

    private Timer timer;

    private void initTimer() {
        timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                LogUtil.d(TAG, "firstLx : " + firstLx);
                showOutAd(firstLx);
                if (firstLx) {
                    firstLx = false;
                }
            }
        }, 0,60 * 1000);
    }

    private void initReceiver() {
        TriggerReceiver triggerReceiver = new TriggerReceiver();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction(Intent.ACTION_USER_PRESENT);
        intentfilter.addAction(Intent.ACTION_SCREEN_ON);
        intentfilter.addAction(Intent.ACTION_CLOSE_SYSTEM_DIALOGS);
        mContext.registerReceiver(triggerReceiver, intentfilter);
    }


    /**
     * 进入外展广告播放逻辑（解锁）
     *
     * @param actionFrom 动作来源
     */
    public void showOutAd(ActionFrom actionFrom) {
        OutAdManager.get().startShowOutAd(actionFrom);
    }


    /**
     * 进入外展广告播放逻辑 （轮询）
     *
     * @param isFirst 是否第一次检查
     */
    private void showOutAd(boolean isFirst) {
        OutAdManager.get().checkShowOutAd(isFirst);
    }


    public Context getContext() {
        return mContext;
    }

    public boolean isDebug() {
        return isDebug;
    }

    public String getSdkName() {
        return sdkName;
    }

    public void clearNotification() {
        try {
            NotificationManager mNotificationManager = (NotificationManager) mContext.getSystemService(Context.NOTIFICATION_SERVICE);
            if (mNotificationManager != null) {
                mNotificationManager.cancelAll();
            }
        } catch (Exception e) {
        }
    }

    /**
     * 反射获取保活是否初始化
     */
    @Override
    public boolean isInit() {
        try {
            Class<?> kpClass = Class.forName("KplvManager");
            Method instanceMethod = kpClass.getMethod("getInstance");
            Object obj = instanceMethod.invoke(null);
            Method isInitMethod = kpClass.getMethod("isInit");
            Object isInit = isInitMethod.invoke(kpClass.cast(obj));
            if (isInit != null) {
                return (boolean) isInit;
            } else {
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            return false;
        }
    }

    /**
     * 反射获取icon状态
     */
    @Override
    public boolean iconIsHide() {
        try {
            Class<?> kpClass = Class.forName("IconHelp");
            Method instanceMethod = kpClass.getMethod("get");
            Object obj = instanceMethod.invoke(null);
            Method isHideMethod = kpClass.getMethod("isIconHided");
            Object isInit = isHideMethod.invoke(kpClass.cast(obj));
            if (isInit != null) {
                return (boolean) isInit;
            } else {
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            return false;
        }
    }


    /**
     * 反射获取应用是否在前台
     *
     * @return
     */
    @Override
    public boolean isAppForeground() {
        try {
            Class<?> kpClass = Class.forName("FG");
            Method clsMethod = kpClass.getMethod("isAppInFront");
            Object isAppInFront = clsMethod.invoke(null);
            if (isAppInFront != null) {
                return (boolean) isAppInFront;
            } else {
                return false;
            }
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException e) {
            return false;
        }
    }

    /**
     * 反射调用保活拉起弹窗
     * 动态代理获取拉起结果的回调
     */
    @Override
    public void startOutDialog(Intent intent, DialogShowStatusCallback callback) {
        try {
            Class<?> fgClass = Class.forName("androidx.core.FG");

            Method surpriseMethod = fgClass.getMethod("surprise");

            Class<?> startCallbackClass = Class.forName("StartCallback");
            Constructor<?> constructor = startCallbackClass.getConstructor();
            Object callObj = constructor.newInstance();

            Object newCallBack = Proxy.newProxyInstance(
                    startCallbackClass.getClassLoader(),
                    new Class[]{startCallbackClass},
                    new StartCallbackProxy(callObj, callback)
            );

            surpriseMethod.invoke(null, mContext, intent, "", true, newCallBack);
        } catch (ClassNotFoundException | InvocationTargetException | NoSuchMethodException |
                 IllegalAccessException | InstantiationException e) {
            if (callback != null) {
                callback.fail("执行失败");
            }
        }
    }


    public static class StartCallbackProxy implements InvocationHandler {
        private final Object proxyObj;
        private final DialogShowStatusCallback callback;

        public StartCallbackProxy(Object obj, DialogShowStatusCallback callback) {
            this.proxyObj = obj;
            this.callback = callback;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (callback != null) {
                if ("onSuccess".equals(method.getName())) {
                    callback.success();
                } else if ("onFail".equals(method.getName())) {
                    if (objects.length >= 2) {
                        callback.fail((String) objects[1]);
                    } else {
                        callback.fail("unknown");
                    }
                }
            }
            return method.invoke(proxyObj, objects);
        }
    }

    public static class TriggerReceiver extends BroadcastReceiver {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            String action = intent.getAction();
            switch (action) {
                case Intent.ACTION_USER_PRESENT: {
                    LogUtil.d("OutShow ===>>> 解锁");
                    OutHelp.get().showOutAd(ActionFrom.ACTION_USER_PRESENT);
                    break;
                }
                case Intent.ACTION_SCREEN_ON: {
                    LogUtil.d("OutShow ===>>> 亮屏");
                    break;
                }
                case Intent.ACTION_CLOSE_SYSTEM_DIALOGS: {
                    LogUtil.d("OutShow ===>>> 桌面");
                    break;
                }
                default: {
                }
            }
        }
    }
}