/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.text.TextUtils;
import com.or.ange.database.LikePalException;
import com.or.ange.database.TableModel;
import com.or.ange.database.annotation.Table;

class ModelHolder<T> {
    private TableModel<T> tableModel;
    private final Class<T> clazz;
    private final String dbName;
    private final String tableName;

    ModelHolder(Class<T> clazz, String dName, String tableName) {
        this.clazz = clazz;
        Table table = this.clazz.getAnnotation(Table.class);
        if (table == null) {
            throw new LikePalException("can't find Table annotation for class:" + clazz);
        }
        this.tableName = tableName;
        this.dbName = this.getDbName(dName, table);
    }

    private String getDbName(String dName, Table table) {
        if (!TextUtils.isEmpty((CharSequence)dName)) {
            return dName;
        }
        if (!TextUtils.isEmpty((CharSequence)table.db())) {
            return table.db();
        }
        return this.clazz.getSimpleName().toLowerCase();
    }

    TableModel<T> getTable() {
        if (this.tableModel == null) {
            this.tableModel = new TableModel<T>(this.clazz, this.dbName, this.tableName);
        }
        return this.tableModel;
    }

    String getDbName() {
        return this.dbName;
    }

    void releaseTable() {
        this.tableModel = null;
    }
}

