package com.zl.sdk.event.statistics;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;

import com.google.firebase.analytics.FirebaseAnalytics;

import java.util.Map;

class FireAnalytics extends AbsStatistics {

    private FirebaseAnalytics mFirebaseAnalytics;
    public FireAnalytics(Context context) {
        mFirebaseAnalytics = FirebaseAnalytics.getInstance(context.getApplicationContext());
    }

    @Override
    public void onResume(Context context) {
    }

    @Override
    public void onPause(Context context) {
    }

    @Override
    public void onPageStart(Context context, String pageName) {
    }

    @Override
    public void onPageEnd(Context context, String pageName) {
    }

    @Override
    public void onEvent(Context context, String eventId) {
        try {
            Bundle bundle = new Bundle();
            mFirebaseAnalytics.logEvent(eventId, bundle);
        } catch (Exception e) {
        }
    }

    @Override
    public void onEvent(Context context, String eventId, String eventLabel) {
        try {
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty(eventLabel)) {
                bundle.putString("label", eventLabel);
            }
            mFirebaseAnalytics.logEvent(eventId, bundle);
        } catch (Exception e) {
        }
    }

    @Override
    public void onEvent(Context context, String eventId, String eventLabel, Map<String, Object> eventMap) {
        try {
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty(eventLabel)) {
                bundle.putString("label", eventLabel);
            }
            if (eventMap != null) {
                for (String key : eventMap.keySet()) {
                    Object value = eventMap.get(key);
                    if (value != null) {
                        if (value instanceof String) {
                            bundle.putString(key, (String) value);
                        } else {
                            try {
                                bundle.putString(key, String.valueOf(value));
                            } catch (Exception ex) {
                            }
                        }
                    }
                }
            }
            mFirebaseAnalytics.logEvent(eventId, bundle);
        } catch (Exception e) {
        }
    }

    @Override
    public void dotEvent(Context context, String eventId, String eventLabel, Map<String, Object> eventMap) {

    }

    @Override
    public void onError(Context context, Throwable throwable) {
    }

    public void onEvent(Context context, String eventId, Map<String, String> eventMap) {
        try {
            Bundle bundle = new Bundle();
            if (eventMap != null) {
                for (String key : eventMap.keySet()) {
                    Object value = eventMap.get(key);
                    if (value != null && value instanceof String) {
                        bundle.putString(key, (String) value);
                    }
                }
            }
            mFirebaseAnalytics.logEvent(eventId, bundle);
        } catch (Exception e) {
        }
    }

    @Override
    public void dotEvent(String eventId) {

    }

    @Override
    public void dotEvent(String eventId, Map<String, String> eventMap) {

    }
}
