/*
 * Decompiled with CFR 0.152.
 */
package com.or.ange.database;

import android.graphics.Bitmap;
import android.os.Parcelable;
import com.or.ange.database.LikePalException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Type<T> {
    public static final Type<Integer> Integer = new Type<Integer>(java.lang.Integer.TYPE);
    public static final Type<Boolean> Boolean = new Type<Boolean>(java.lang.Boolean.TYPE);
    public static final Type<byte[]> ByteArray = new Type<byte[]>(byte[].class);
    public static final Type<Float> Float = new Type<Float>(java.lang.Float.TYPE);
    public static final Type<Double> Double = new Type<Double>(java.lang.Double.TYPE);
    public static final Type<Long> Long = new Type<Long>(java.lang.Long.TYPE);
    public static final Type<Short> Short = new Type<Short>(java.lang.Short.TYPE);
    public static final Type<Character> Character = new Type<Character>(java.lang.Character.TYPE);
    public static final Type<Bitmap> Bitmap = new Type<Bitmap>(Bitmap.class);
    public static final Type<String> String = new Type<String>(String.class);
    public static final Type<Serializable> Serializable = new Type<Serializable>(Serializable.class);
    public static final Type<Parcelable> Parcelable = new Type<Parcelable>(Parcelable.class);
    private Class<T> clazz;

    private Type(Class<T> clazz) {
        this.clazz = clazz;
    }

    T cast(Object obj) {
        if (obj == null) {
            return null;
        }
        return (T)obj;
    }

    static Type getType(Class clz) {
        if (clz == null) {
            throw new NullPointerException("getType class is null.");
        }
        String type = clz.getCanonicalName();
        if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            return Boolean;
        }
        if ("byte[]".equals(type)) {
            return ByteArray;
        }
        if ("float".equals(type) || "java.lang.Float".equals(type)) {
            return Float;
        }
        if ("double".equals(type) || "java.lang.Double".equals(type)) {
            return Double;
        }
        if ("int".equals(type) || "java.lang.Integer".equals(type)) {
            return Integer;
        }
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return Long;
        }
        if ("short".equals(type) || "java.lang.Short".equals(type)) {
            return Short;
        }
        if ("char".equals(type) || "java.lang.Character".equals(type)) {
            return Character;
        }
        if ("java.lang.String".equals(type)) {
            return String;
        }
        if ("android.graphics.Bitmap".equals(type)) {
            return Bitmap;
        }
        if (Type.isSerializable(clz)) {
            return Serializable;
        }
        if (Type.isParcelable(clz)) {
            return Parcelable;
        }
        throw new LikePalException("not support type for " + clz);
    }

    private static boolean isParcelable(Class clz) {
        return Type.getInterfaces(clz).contains(Parcelable.class);
    }

    private static boolean isSerializable(Class clz) {
        return Type.getInterfaces(clz).contains(Serializable.class);
    }

    private static List<Class> getInterfaces(Class clz) {
        ArrayList<Class> interfaces = new ArrayList<Class>(Arrays.asList(clz.getInterfaces()));
        while (!Object.class.equals(clz.getSuperclass()) && (clz = clz.getSuperclass()) != null) {
            interfaces.addAll(Arrays.asList(clz.getInterfaces()));
        }
        return interfaces;
    }
}

